/*
 *    $Id: toolbar.c,v 1.1.1.1 1998/04/21 02:21:27 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>

#include "preferences.h"
#include "pages.h"
#include "files.h"
#include "d_message.h"
#include "file_attr.h"
#include "if_workplace.h"
#include "gui_preference.h"
#include "suffix.h"
#include "toolbar.h"

#include "HandOpen.xpm"
#define PIXMAP_DATA HandOpen_xpm

#define ICON_WIDTH  136
#define ICON_HEIGHT  76

static void arrange_icon (void);
static void create_dialog (FileList *fl);
static void cancel_dialog(GtkWidget *widget);
static void ok_dialog(GtkWidget *widget, FileList *fl);
static void exit_handler (GtkWidget * widget, gpointer * data);

extern Preference *Preferences;
extern GtkWidget *Mainwindow;
extern FileList *current_file;
extern Fileinfo *file_info;
extern GtkWidget *workplace;
extern FileList *Files;
extern DisplayType Display_type;

static GtkWidget  *dialog;

void
init_toolbar(GtkWidget *parent)
{
	GtkWidget *main_box;
	GtkWidget *button;
	

        /* box */
	main_box = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);

       /* button */
	button = gtk_button_new_with_label(" Arrange ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(arrange_icon), NULL);
	gtk_box_pack_start(GTK_BOX(main_box), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	/* button */
	button = gtk_button_new_with_label(" Delete ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(wp_delete_file), NULL);
	gtk_box_pack_start(GTK_BOX(main_box), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	/* button */
	button = gtk_button_new_with_label(" Preferences ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(create_PreferenceWindow), NULL);
	gtk_box_pack_start(GTK_BOX(main_box), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	/* button */
	button = gtk_button_new_with_label(" Exit ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(exit_handler), NULL);
	gtk_box_pack_end(GTK_BOX(main_box), button, FALSE, FALSE, 0);
	gtk_widget_show(button);
}

static void 
arrange_icon (void)
{
	FileList *buf;
	int       main_width;
	int       width;
	int       max_num;
	int       margin;
	int       xp;
	int       x = 0;
	int       y = 0;

	if (!Files) {
		return;
	}

	/* This is an easy hack */
	main_width = Mainwindow->allocation.width-30;
	width = ICON_WIDTH + 2;
	max_num = main_width / width;
	margin  = (main_width % width) / 2;

	buf = Files;
	while (1){
		if (!buf) {
			break;
		}
		if (x >= max_num) {
			y++;
			x = 0;
		}
		xp = x*width + margin;

		if (buf->icon && GTK_WIDGET_VISIBLE(buf->icon)) {
			if (buf->x != xp) {
				buf->x = xp;
			}
			if (buf->y != y*width) {
				buf->y = y*80;
			}
			gtk_fixed_move(GTK_FIXED(workplace), buf->icon, buf->x, buf->y);
			x++;
		}
		buf = buf->next;
	}
}

void 
wp_delete_file (GtkWidget *widget)
{
	FileList  *fl;
	FileList  *tmp2;
	int       result;
	char      *pathname;

	fl = current_file;

	if (!fl) {
		init_dialog_message("You must select a file.");
		return;
	}

	pathname = (char *) g_malloc(strlen(fl->info->path)+ strlen(fl->info->name)+1);
	strcpy(pathname, fl->info->path);
	strcat(pathname, fl->info->name);

	if (S_ISREG(fl->info->stat->st_mode)) {

		/* remove */
		result = check_permission(fl->info->stat);
		if (result == 0) {
			tmp2 = fl->next;
			/* set linked list *
			tmp1 = fl->prev;
			tmp2 = fl->next;
			if (tmp1) {
				tmp1->next = tmp2;
			}
			if (tmp2) {
				tmp2->prev = tmp1;
			}
			
			* free this FileList *
			if (fl->info) {
				if (fl->info->name) {
					g_free(fl->info->name);
					fl->info->name = NULL;
				}
				if (fl->info->name_abbr) {
					g_free(fl->info->name_abbr);
					fl->info->name_abbr = NULL;
				}
				if (fl->info->stat) {
					g_free(fl->info->stat);
					fl->info->stat = NULL;
				}
				if (fl->info->day_abbr) {
					g_free(fl->info->day_abbr);
					fl->info->day_abbr = NULL;
				}
				g_free(fl->info);
				fl->info = NULL;
			}
			*/
			if (Display_type == ICON) {
				/* destroy widget */
				if (fl->icon) {
					gtk_widget_hide(fl->icon);
					fl->icon = NULL;
				}
			}
			else if (Display_type == LIST) {
				/*
				if (fl->size) {
					g_free(fl->size);
					fl->size = NULL;
				}
				if (fl->time) {
					g_free(fl->time);
					fl->time = NULL;
				}
				*/

				/* destroy widget */
				gtk_clist_remove (GTK_CLIST(workplace), fl->row);

				/* Is it need ? */
				while (1) {
				  	if (!tmp2) {
				 		break;
				 	}
					fl->row -= 1;
					tmp2 = tmp2->next;
				}
				
				 
			}
			unlink(pathname);
			/* g_free(fl); */

			/* set NULL */
			current_file = NULL;
			file_info = NULL;
		}
		else if (result > 0) {
			create_dialog(fl);
		}
		else {
			init_dialog_message("Permission denied\n");
		}
	}
	else {
		init_dialog_message("This file is not normal file.");
	}
	g_free(pathname);
}

static void 
create_dialog (FileList *fl)
{
	GtkWidget  *main_box;
	GtkWidget  *vbox;
	GtkWidget  *pixmap;
	GtkWidget  *label;
	GtkWidget  *separator;
	GtkWidget  *box;
	GtkWidget  *hbox1;
	GtkWidget  *hbox2;
	GtkWidget  *ok_button;
	GtkWidget  *cancel_button;
	GdkPixmap  *pixmap_data = NULL;
	GdkBitmap  *mask;
	GtkStyle   *style;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();

	if (!dialog) {
		/* set style */
		style = gtk_style_new();
		style->font = gdk_font_load ("-adobe-times-medium-*-*--*-160-*-*-*-*-*-*");
		
		
		/* Create the main window */
		dialog = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_widget_set_usize(dialog, 300, 200);
		gtk_window_set_title(GTK_WINDOW(dialog), "Delete");
		gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
		gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
				   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

		/* Create a container to hold everything */
		main_box = gtk_vbox_new(FALSE, 4);
		gtk_container_add(GTK_CONTAINER(dialog), main_box);
		gtk_widget_show(main_box);
		
		/* box */
		vbox = gtk_vbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX (main_box), vbox, TRUE, TRUE, 0);
		gtk_container_border_width(GTK_CONTAINER(vbox), 10);
		gtk_widget_show(vbox);	
		
		
		/* message type box */
		box = gtk_hbox_new(FALSE, 14);
		gtk_box_pack_start(GTK_BOX (vbox), box, TRUE, TRUE, 0);
		gtk_widget_show(box);
		
		/* pixmap */
		pixmap_data = gdk_pixmap_colormap_create_from_xpm_d(NULL,cmap,&mask, 
								    &style->bg[GTK_STATE_NORMAL],
								    PIXMAP_DATA);
		
		if (pixmap_data) {
			pixmap = gtk_pixmap_new(pixmap_data, mask);
			gtk_box_pack_start(GTK_BOX (box), pixmap, FALSE, FALSE, 0);
			gtk_widget_show(pixmap);
		}
		
		/* label */
		label = gtk_label_new("Warning !");
		gtk_widget_set_style(label, style);
		gtk_box_pack_start(GTK_BOX (box), label, FALSE, FALSE, 0);
		gtk_widget_show(label);
		
		/* label */
		label = gtk_label_new("Do you want to delete ?");
		gtk_box_pack_start(GTK_BOX (vbox), label, TRUE, TRUE, 0);
		gtk_widget_show(label);
		
		/*separator*/
		separator = gtk_hseparator_new ();
		gtk_box_pack_start (GTK_BOX (main_box), separator, FALSE, TRUE, 0);
		gtk_widget_show (separator);
		
		/* box 1 */
		hbox1 = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_end(GTK_BOX (main_box), hbox1, FALSE, FALSE, 0);
		gtk_container_border_width(GTK_CONTAINER(hbox1), 10);
		gtk_widget_show(hbox1);

		/* box 2 */
		hbox2 = gtk_hbox_new(TRUE, 0);
		gtk_box_pack_end(GTK_BOX (hbox1), hbox2, FALSE, FALSE, 0);
		gtk_widget_show(hbox2);
	
		/*  The OK button  */
		ok_button = gtk_button_new_with_label(" Ok ");
		GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(hbox2), ok_button, TRUE, TRUE, 0);
		gtk_signal_connect(GTK_OBJECT(ok_button), "clicked",
				   GTK_SIGNAL_FUNC(ok_dialog), fl);
		gtk_widget_show(ok_button);
		
		/*  The Cancel button  */
		cancel_button = gtk_button_new_with_label(" Cancel ");
		GTK_WIDGET_SET_FLAGS(cancel_button, GTK_CAN_DEFAULT);
		gtk_box_pack_start(GTK_BOX(hbox2), cancel_button, TRUE, TRUE, 0);
		gtk_widget_grab_default(cancel_button);
		gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
				   GTK_SIGNAL_FUNC(cancel_dialog), NULL);
		gtk_widget_show(cancel_button);
	}
	if (!GTK_WIDGET_VISIBLE(dialog)){
		/* show all */
		gtk_widget_show(dialog);
	
	}
}

static void 
cancel_dialog(GtkWidget *widget)
{	
	/* Destroy Message */
	gtk_widget_destroy(dialog);
	dialog = NULL;
}


static void 
ok_dialog(GtkWidget *widget, FileList *fl)
{	
	FileList  *tmp1;
	FileList  *tmp2;
	char      *pathname;

	pathname = (char *) g_malloc(strlen(fl->info->path)+strlen(fl->info->name)+1);
	strcpy(pathname, fl->info->path);
	strcat(pathname, fl->info->name);

	/* set linked list */
	tmp1 = fl->prev;
	tmp2 = fl->next;
	if (tmp1) {
		tmp1->next = tmp2;
	}
	if (tmp2) {
		tmp2->prev = tmp1;
	}
	
	/* free this FileList */
	if (fl->info) {
		if (fl->info->name) {
			g_free(fl->info->name);
			fl->info->name = NULL;
		}
		if (fl->info->name_abbr) {
			g_free(fl->info->name_abbr);
			fl->info->name_abbr = NULL;
		}
		if (fl->info->stat) {
			g_free(fl->info->stat);
			fl->info->stat = NULL;
		}
		if (fl->info->day_abbr) {
			g_free(fl->info->day_abbr);
			fl->info->day_abbr = NULL;
		}
		g_free(fl->info);
		fl->info = NULL;
	}

	/* destroy widget */
	if (Display_type == ICON) {
		if (fl->label) {
			if (fl->label->window) 
				gdk_window_clear(fl->label->window);
			fl->label = NULL;
		}
		if (fl->icon) {
			if (fl->image->window) 
				gdk_window_clear(fl->image->window);
			gtk_widget_destroy(fl->icon);
			fl->icon = NULL;
			fl->image = NULL;
		}
	}
	else if  (Display_type == LIST) {
		if (fl->size) {
			g_free(fl->size); 
			fl->size = NULL;
		}
		if (fl->time) {
			g_free(fl->time); 
			fl->time = NULL;
		}
	}
	
	unlink(pathname);
        /* set NULL */
	current_file = NULL;
	file_info = NULL;

	/* Destroy Message */
	gtk_widget_destroy(dialog);
	dialog = NULL;
}

static void 
exit_handler (GtkWidget * widget, gpointer * data)
{
	/* set size */
	Preferences->width = Mainwindow->allocation.width;
	Preferences->height = Mainwindow->allocation.height;

	restore_page();
	write_config_file();
	save_suffix_pref();
	gtk_exit(0);
}














