/*
 *    $Id: suffix.h,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#ifndef _SUFFIX_H
#define _SUFFIX_H
#include <gtk/gtk.h>
#include "files.h"

typedef struct Suffix {
	struct  Suffix *next;
	char           *suffix;
	char           *image;

	/* 1st */
	char           *name0;
	char           *cmd0;
	char           *arg0;

	/* 2nd */
	char           *name1;
	char           *cmd1;
	char           *arg1;

	/* 3rd */
	char           *name2;
	char           *cmd2;
	char           *arg2;

	GdkPixmap      *pixmap;
	GdkBitmap      *mask;
	
	/* widget for preference */
	GtkWidget  *gw_pref;
} Suffix;

void init_pixmaps (void);
void init_suffix_pref(void);
void save_suffix_pref(void);
Suffix *get_suffix_from_name (char *name);
GtkWidget *get_pixmap_from_name (char *name, FileType type);

#endif /* _SUFFIX_H */







