/*
 *    $Id: suffix.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <ctype.h>
#include "Workplace.h"
#include "misc.h"
#include "preferences.h"
#include "suffix.h"

#define MAX_OBJ  24

#include "File.xpm"
#define DEFAULT_XPM File_xpm
#include "Folder.xpm" 
#define DEFAULT_DIRECTORY_XPM Folder_xpm

extern Preference *Preferences;

static void parse_string (char *string);
static char * parse_words(char *symbol, char *src);

Suffix *suffix_data;
Suffix *suffix_data_p;
Suffix *default_data;

static Suffix *default_data_p;

static GdkPixmap *default_xpm  = NULL;
static GdkBitmap *default_mask = NULL;
static GdkBitmap *dir_mask = NULL;
static GdkPixmap *dir_xpm  = NULL;

void 
init_suffix_pref (void)
{
	char         *text;
	char         *buf;
	char         *tmp;
	char         *p[MAX_OBJ];
	int          inside = 0;
	int          i = 0, j = 0;
	const char   del[] = "\n";

	/* read _home_ directory */
	buf = (char *) g_malloc(strlen(Preferences->home) + strlen(DOT_DIR) 
				+ strlen(SUFFIX_PREF) +3);
	strcpy(buf, Preferences->home);
	strcat(buf, "/");
	strcat(buf, DOT_DIR);
	strcat(buf, "/");
	strcat(buf, SUFFIX_PREF);
	text = read_file(buf);
	g_free(buf);

	if (!text) {
		suffix_data = NULL;
		return;
	}	
	tmp = (char *) g_malloc(strlen(text));
	memset((char *) tmp, 0, sizeof(tmp));

	buf = strtok(text, del);
	while (1) {
		if (i > MAX_OBJ) {
			fprintf(stderr,"Over\n");
			break;
		}
		if (*buf == '#'){ 
                        /* do nothing. this is a comment. */
			;
		}
		else {
			if (inside) {
				if (strchr(buf, '{')) {
					fprintf(stderr,"%s: Suffix parse err\n", Myname);
					for (j = 0; j < i; j++) {
						g_free(p[j]);
					}
					g_free(text);
					return;
				}
				else if (strchr(buf, '}')) {
					inside = 0;
					strcat(tmp, buf);
					p[i] = (char *)g_malloc(strlen(tmp)+1);
					strcpy(p[i++], tmp);
				}
				else {
					strcat(tmp, buf);
				}
				
			} /* end of inside */
			else { /* outside */
				if (strchr(buf, '{')) {
					inside = 1;
					strcpy(tmp, buf);
				}
				else if (strchr(buf, '}')) {
					fprintf(stderr,"%s: Suffix parse err\n", Myname);
					for (j = 0; j < i; j++) {
						g_free(p[j]);
					}
					g_free(text);
					return;
				}
				else if (strchr(buf, ';')) {
					p[i] = (char *) g_malloc(strlen(buf)+1);
					strcpy(p[i++], buf);
				}
				else {
					fprintf(stderr,"%s: Suffix parse err\n", Myname);
					for (j = 0; j < i; j++) {
						g_free(p[j]);
					}
					g_free(text);
					return;
				}
			}
		}
		/* get next token */
		buf = strtok(NULL, del);
		if (buf == NULL) {
			break;
		}
	}
	g_free(text);

	for (j=0;j<i;j++) {
		parse_string(p[j]);
		g_free(p[j]);
	}
}

void
init_pixmaps (void)
{	
	GtkStyle    *style;
	Suffix      *buf;
	char        *pathname;
	GdkColormap *cmap;

	cmap = gdk_colormap_get_system();

        /* set style */
	style = gtk_style_new();

	/* load pixmap */
	default_xpm = gdk_pixmap_colormap_create_from_xpm_d
		(NULL,cmap,&default_mask, &style->bg[GTK_STATE_NORMAL], DEFAULT_XPM);
	dir_xpm = gdk_pixmap_colormap_create_from_xpm_d
		(NULL,cmap,&dir_mask, &style->bg[GTK_STATE_NORMAL],DEFAULT_DIRECTORY_XPM);
	
	buf = suffix_data;
	while (1) {
		if (!buf) {
			break;
		}

		pathname = (char *) g_malloc(strlen(Preferences->home)+strlen(DOT_DIR)
					     +strlen(buf->image)+10);
		strcpy(pathname, Preferences->home);
		strcat(pathname, "/");
		strcat(pathname, DOT_DIR);
		strcat(pathname, "/Images/");
		strcat(pathname, buf->image);

		/* create pixmap */
		buf->pixmap = gdk_pixmap_colormap_create_from_xpm
			(NULL, cmap, &buf->mask, &style->bg[GTK_STATE_NORMAL], pathname);
		/* next */
		buf = buf->next;
	}

}

Suffix *
get_suffix_from_name (char *name)
{
	Suffix  *buf;
	char    *p;

	p = strrchr(name, '.');
	if (!p)
		return default_data;

	p += 1;

	if (!p || strlen(p) < 1)
		return default_data;

	buf = suffix_data;
	while (1) {
		if (!buf) {
			return default_data;
		}
		else {
			if (strcasecmp(buf->suffix, p) == 0) {
				return buf;
			}

			buf = buf->next;
		}
	}
}

GtkWidget *
get_pixmap_from_name (char *name, FileType type)
{
	Suffix    *buf;
	GtkWidget *pixmap;
	char      *p;

	if (type == DIRECTORY) {
		pixmap = gtk_pixmap_new(dir_xpm, dir_mask);
		return pixmap;
	}

	p = strrchr(name, '.');
	if (!p) {
		pixmap = gtk_pixmap_new(default_xpm, default_mask);
		return pixmap;
	}
	else {
		if (strlen(p) < 2) {
			pixmap = gtk_pixmap_new(default_xpm, default_mask);
			return pixmap;
		}
	}

	p += 1;
	
	/* search suffix */
	buf = suffix_data;
	while (1) {
		if (!buf) {
			pixmap = gtk_pixmap_new(default_xpm, default_mask);
			break;
		}
		else {
			if (strcasecmp(buf->suffix, p) == 0) {
				if (buf->pixmap && buf->mask) {
					pixmap = gtk_pixmap_new(buf->pixmap, buf->mask);
					break;
				}
				else {
					pixmap = gtk_pixmap_new(default_xpm, default_mask);
					break;
				}
			}
			buf = buf->next;
		}
	}

	return pixmap;
}

void
save_suffix_pref(void)
{
	FILE      *fp;
	Suffix    *buf_suffix;
	char      *buf;
	char      *pathname;

	buf = (char *) g_malloc(2000);

	/* size */
	sprintf(buf, "# This is a suffix preference file.\n\n");

	/* Default */
	buf_suffix = default_data;
	strcat(buf, "Default {\n");
       
	/* 1st */
	strcat(buf, "\tITEM0_NAME = ");
	if (buf_suffix->name0)
		strcat(buf, buf_suffix->name0);
	else
		strcat(buf, "NULL");
	strcat(buf, ";\n");
	strcat(buf, "\tITEM0_CMD = ");
	if (buf_suffix->cmd0)
		strcat(buf, buf_suffix->cmd0);
	else
		strcat(buf, "NULL");
	strcat(buf, ";\n");
	strcat(buf, "\tITEM0_ARG = ");
	if (buf_suffix->arg0)
		strcat(buf, buf_suffix->arg0);
	else
		strcat(buf, "NULL");
	strcat(buf, ";\n");

	/* 2nd */
	strcat(buf, "\tITEM1_NAME = ");
	if (buf_suffix->name1)
		strcat(buf, buf_suffix->name1);
	else
		strcat(buf, "NULL");
	strcat(buf, ";\n");
	strcat(buf, "\tITEM1_CMD = ");
	if (buf_suffix->cmd1)
		strcat(buf, buf_suffix->cmd1);
	else
		strcat(buf, "NULL");
	strcat(buf, ";\n");
	strcat(buf, "\tITEM1_ARG = ");
	if (buf_suffix->arg1)
		strcat(buf, buf_suffix->arg1);
	else
		strcat(buf, "NULL");
	strcat(buf, ";\n");

	/* 3rd */
	strcat(buf, "\tITEM2_NAME = ");
	if (buf_suffix->name2)
		strcat(buf, buf_suffix->name2);
	else
		strcat(buf, "NULL");
	strcat(buf, ";\n");
	strcat(buf, "\tITEM2_CMD = ");
	if (buf_suffix->cmd2)
		strcat(buf, buf_suffix->cmd2);
	else
		strcat(buf, "NULL");
	strcat(buf, ";\n");
	strcat(buf, "\tITEM2_ARG = ");
	if (buf_suffix->arg2)
		strcat(buf, buf_suffix->arg2);
	else
		strcat(buf, "NULL");
	strcat(buf, ";\n");
	strcat(buf, "}\n\n");


	buf_suffix = suffix_data;

	while (1) {
		if (!buf_suffix) {
			break;
		}
		
		/* suffix */
		strcat(buf, "Suffix ");
		strcat(buf, buf_suffix->suffix);
		strcat(buf," {\n");

		/* image */
		strcat(buf, "\tIMAGE = ");
		if (buf_suffix->image)
			strcat(buf, buf_suffix->image);
		else
			strcat(buf, "NULL");
		strcat(buf, ";\n");

		/* 1st */
		strcat(buf, "\tITEM0_NAME = ");
		if (buf_suffix->name0)
			strcat(buf, buf_suffix->name0);
		else
			strcat(buf, "NULL");
		strcat(buf, ";\n");
		strcat(buf, "\tITEM0_CMD = ");
		if (buf_suffix->cmd0)
			strcat(buf, buf_suffix->cmd0);
		else
			strcat(buf, "NULL");
		strcat(buf, ";\n");
		strcat(buf, "\tITEM0_ARG = ");
		if (buf_suffix->arg0)
			strcat(buf, buf_suffix->arg0);
		else
			strcat(buf, "NULL");
		strcat(buf, ";\n");
		
		/* 2nd */
		strcat(buf, "\tITEM1_NAME = ");
		if (buf_suffix->name1)
			strcat(buf, buf_suffix->name1);
		else
			strcat(buf, "NULL");
		strcat(buf, ";\n");
		strcat(buf, "\tITEM1_CMD = ");
		if (buf_suffix->cmd1)
			strcat(buf, buf_suffix->cmd1);
		else
		strcat(buf, "NULL");
		strcat(buf, ";\n");
		strcat(buf, "\tITEM1_ARG = ");
		if (buf_suffix->arg1)
			strcat(buf, buf_suffix->arg1);
		else
			strcat(buf, "NULL");
		strcat(buf, ";\n");

		/* 3rd */
		strcat(buf, "\tITEM2_NAME = ");
		if (buf_suffix->name2)
			strcat(buf, buf_suffix->name2);
		else
			strcat(buf, "NULL");
		strcat(buf, ";\n");
		strcat(buf, "\tITEM2_CMD = ");
		if (buf_suffix->cmd2)
			strcat(buf, buf_suffix->cmd2);
		else
			strcat(buf, "NULL");
		strcat(buf, ";\n");
		strcat(buf, "\tITEM2_ARG = ");
		if (buf_suffix->arg2)
			strcat(buf, buf_suffix->arg2);
		else
			strcat(buf, "NULL");
		strcat(buf, ";\n");
		strcat(buf, "}\n\n");

		/* next */
		buf_suffix = buf_suffix->next;
	}

	/* end mark */
	strcat(buf, "#END" );

	pathname = (char *) g_malloc(strlen(Preferences->home)+strlen(DOT_DIR)+strlen(SUFFIX_PREF)+3);
	strcpy(pathname, Preferences->home);
	strcat(pathname, "/");
	strcat(pathname, DOT_DIR);
	strcat(pathname, "/");
	strcat(pathname, SUFFIX_PREF);

	fp = fopen(pathname, "w+");
	g_free(pathname);

	fprintf(fp,"%s\n",buf);
	g_free(buf);
	fclose(fp);
}


static void 
parse_string (char *str)
{
	char        *buf;
	char        *tmp;
	char        *arg;
	Suffix      *p;
	const char  del[] = " ;\t"; 


	buf = strtok(str, del);
	if (strcmp(buf, "Suffix") == 0) {

		p = (Suffix *) g_malloc(sizeof(Suffix));
		p->next = NULL;

		/* suffix */
		buf = strtok(NULL, del);
		p->suffix = (char *) g_malloc(strlen(buf)+1);
		strcpy(p->suffix, buf);
		
		tmp = buf+strlen(buf)+1;
		arg = (char *) g_malloc(strlen(tmp)+1);
		memset((char *) arg, 0, strlen(tmp)+1);
		strcpy(arg, tmp);

		p->image = parse_words("IMAGE", arg);
		
		/* 1st */
		p->name0 = parse_words("ITEM0_NAME", arg);
		p->cmd0 = parse_words("ITEM0_CMD", arg);
		p->arg0 = parse_words("ITEM0_ARG", arg);

		/* 2nd */
		p->name1 = parse_words("ITEM1_NAME", arg);
		p->cmd1 = parse_words("ITEM1_CMD", arg);
		p->arg1 = parse_words("ITEM1_ARG", arg);

		/* 3rd */
		p->name2 = parse_words("ITEM2_NAME", arg);
		p->cmd2 = parse_words("ITEM2_CMD", arg);
		p->arg2 = parse_words("ITEM2_ARG", arg);

		if (!suffix_data) {
			suffix_data = p;
			suffix_data_p = suffix_data;
		}
		else {
			suffix_data_p->next = p;
			suffix_data_p = suffix_data_p->next;
		}
	}
	else if (strcmp(buf, "Default") == 0) {

		p = (Suffix *) g_malloc(sizeof(Suffix));
		p->next = NULL;

		/* suffix */
		buf = strtok(NULL, del);
		p->suffix = NULL;
		
		tmp = buf+strlen(buf)+1;
		arg = (char *) g_malloc(strlen(tmp)+1);
		memset((char *) arg, 0, strlen(tmp)+1);
		strcpy(arg, tmp);

		p->image = NULL;

		/* 1st */
		p->name0 = parse_words("ITEM0_NAME", arg);
		p->cmd0 = parse_words("ITEM0_CMD", arg);
		p->arg0 = parse_words("ITEM0_ARG", arg);

		/* 2nd */
		p->name1 = parse_words("ITEM1_NAME", arg);
		p->cmd1 = parse_words("ITEM1_CMD", arg);
		p->arg1 = parse_words("ITEM1_ARG", arg);

		/* 3rd */
		p->name2 = parse_words("ITEM2_NAME", arg);
		p->cmd2 = parse_words("ITEM2_CMD", arg);
		p->arg2 = parse_words("ITEM2_ARG", arg);

		if (!suffix_data) {
			default_data = p;
			default_data_p = default_data;
		}
		else {
			default_data_p->next = p;
			default_data_p = default_data_p->next;
		}
	}
}

static char *
parse_words(char *symbol, char *src)
{
	char *dest;
	char *tmp;
	char buf[256];
	int  l;
	int  i = 0, j = 0;

	l = strlen(symbol);

	tmp = src;
	while (1) {
		if ((int) *tmp == (int) *(symbol+i)){
			tmp += 1;
			i++;
			if (i>=l) {
				break;
			}
		}
		else {
			tmp = strchr(tmp, (int) *symbol);
			if (!tmp) {
				fprintf(stderr,"parse err in parse_words.\n");
				return NULL;
			}
			tmp += 1; 
			i = 1;
		}
	}
	tmp = strchr(tmp+1, '=');
	tmp += 1;

	/* space */
	i = 0;
	while (1) {
		if (isspace((int) *(tmp+i)) != 0) { 
			i++;
		}
		else {
			tmp += i;
			break;
		}
	}

	i = 0;
	j = 0;
	while (1) {
		buf[j] = *(tmp+i);
		if (buf[j] == ';') {
			buf[j] = '\0';
			break;
		}
		i++;
		j++;
	}

	if (strcmp(buf, "NULL") == 0) {
		dest = NULL;
	}
	else {
		/* dest = (char *) g_malloc(j+1); */
		dest = (char *) g_malloc(strlen(buf)+1);
		strcpy(dest, buf);
	}

	return dest;
}












