/*
 *    $Id: preferences.h,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */
#ifndef _PREFERENCES_H
#define _PREFERENCES_H
#include "files.h"

typedef enum Boolen {
	NO,
	YES
} Boolen;

typedef struct  App {
	struct App *next;
	char  *name;
	char  *cmd;
	char  *args;
	char  *image;
	Boolen  dnd;
} App;

typedef struct  Note {
	struct Note  *next;
	char         *name;
	App          *top_app;
	App          *app;
} Note; 

typedef struct  Shortcut {
	struct Shortcut  *next;
	char             *path;
} Shortcut;

typedef struct Preference {
	Note         *top_note;
	Note         *note;
	int          width;
	int          height;
	Shortcut     *shortcut;
	DisplayType  d_type;
	char         *icon_path;
	char         *home;
} Preference;

/* This var hold a name of workplace */
extern char *Myname;


void init_preferences(void);
void write_config_file(void);
void free_applist(void);

#endif /* _PREFERENCES_H */
