/*
 *    $Id: preferences.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */
#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stddef.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "Workplace.h"
#include "main.h"
#include "pages.h"
#include "misc.h"
#include "files.h"
#include "preferences.h"

#define MAX_OBJ 64
#define MAX_DOTFILE_SIZE 10240

static Preference * new_preference(void);
static void init_default_preference(void);
static void parse_string(char *origin);
static void wp_window_size(char *arg);
static void wp_display_type(char *arg);
static void wp_iconpath(char *arg);
static void wp_shortcut(char *arg);
static void wp_note(char *arg1, char *arg2);
static void wp_app(char *arg1, char *arg2);

/* This var hold preferences of workplace */
Preference *Preferences;

static App  *applist;
static App  *current_app;

/* This func initialize preference */
void 
init_preferences (void)
{
	struct stat  *sb;
	char         *text;
	char         *buf_tkn;
	char         *buf;
	char         *p[MAX_OBJ];
	char         *tmp = NULL;
	char         *tmp2;
	int          i =0;
	int          j = 0;
	int          inside = 0;
	const char   del[] = "\n";


	Preferences = new_preference();

	/* get HOME env */
	buf = getenv("HOME");
	Preferences->home = (char *) g_malloc(strlen(buf) + 1);
	memset((char *) Preferences->home, 0, strlen(buf)+1);
	strcpy(Preferences->home, buf);

	/* read _home_ directory */
	buf = (char *) g_malloc(strlen(Preferences->home) + strlen(DOT_DIR) +2);
	memset((char *) buf, 0, strlen(Preferences->home) + strlen(DOT_DIR) +2);
	strcpy(buf, Preferences->home);
	strcat(buf, "/");
	strcat(buf, DOT_DIR);
	
	/* check directory */
	sb = (struct stat *) g_malloc(sizeof(struct stat));
	if (stat(buf, sb) == -1) {
		if (mkdir(buf,S_IRWXU) == -1) {
			fprintf(stderr,"I cannot create directory.\n");
			g_free(buf);
			g_free(sb);
			exit (1);
		}
		text = NULL;
		g_free(buf);
		buf = NULL;
	}
	else {
		if (!S_ISDIR(sb->st_mode)) {
			fprintf(stderr,"%s exist. \n", buf);
			g_free(buf);
			g_free(sb);
			exit(1);
		}
		else {
			g_free(buf);
			buf = (char *) g_malloc(strlen(Preferences->home) + strlen(DOT_DIR) 
						+ strlen(WPPREF) +3);
			memset((char *) buf, 0, strlen(Preferences->home)+strlen(DOT_DIR) 
			       + strlen(WPPREF) +3);
			strcpy(buf, Preferences->home);
			strcat(buf, "/");
			strcat(buf, DOT_DIR);
			strcat(buf, "/");
			strcat(buf, WPPREF);
			text = read_file(buf);
			g_free(buf);
			buf = NULL;
		}
	}
	g_free(sb);
	if (!text) {
		init_default_preference();
		return;
	}

	/* begin parse */
	i = 0;
	buf_tkn = strtok(text, del);
	while (1) {
		if (*buf_tkn == '#'){ 
                        /* do nothing. this is a comment. */
			;
		}
		else {
			if (inside) {
				if (strchr(buf_tkn, '{')) {
					fprintf(stderr,"%s: parse err\n", Myname);
					fprintf(stderr,"We read a default preferene.");
					for (j = 0; j < i; j++) {
						g_free(p[j]);
					}
					g_free(text);
					init_default_preference();
					return;
				}
				else if (strchr(buf_tkn, '}')) {
					inside = 0;
					tmp2 = (char *) g_malloc(strlen(tmp)+strlen(buf_tkn)+1);
					strcpy(tmp2, tmp);
					strcat(tmp2, buf_tkn);
					memset((char *) tmp, 0, sizeof(tmp));
					g_free(tmp);
					p[i++] = tmp2;
					tmp = NULL;
					tmp2 = NULL;
				}
				else {
					tmp2 = (char *) g_malloc(strlen(tmp)+strlen(buf_tkn)+1);
					strcpy(tmp2, tmp);
					strcat(tmp2, buf_tkn);
					memset((char *) tmp, 0, sizeof(tmp));
					g_free(tmp);
					tmp = tmp2;
					tmp2 = NULL;
				}
				
			} /* end of inside */
			else { /* outside */
				if (strchr(buf_tkn, '{')) {
					inside = 1;
					if (tmp) {
						tmp2 = (char *) g_malloc(strlen(tmp)+
									 strlen(buf_tkn)+2);
						strcpy(tmp2, tmp);
						strcat(tmp2, " ");
						strcat(tmp2, buf_tkn);
						memset((char *) tmp, 0, sizeof(tmp));
						g_free(tmp);
						tmp = tmp2;
						tmp2 = NULL;
					}
					else {
						tmp = (char *) g_malloc(strlen(buf_tkn)+1);
						memset((char *) tmp, 0, strlen(buf_tkn)+1);
						strcpy(tmp, buf_tkn);
					}
				}
				else if (strchr(buf_tkn, '}')) {
					fprintf(stderr,"%s: parse err\n", Myname);
					fprintf(stderr,"We read a default preferene.");
					for (j = 0; j < i; j++) {
						g_free(p[j]);
					}
					g_free(text);
					init_default_preference();
					return;
				}
				else if (strchr(buf_tkn, ';')) {
					p[i] = (char *) g_malloc(strlen(buf_tkn)+1);
					memset((char *) p[i], 0, strlen(buf_tkn)+1);
					strcpy(p[i++], buf_tkn);
					tmp = NULL;
				}
				else {
					tmp = (char *) g_malloc(strlen(buf_tkn)+1);
					memset((char *) tmp, 0, strlen(buf_tkn)+1);
					strcpy(tmp, buf_tkn);
				}
			}
		}
		/* get next token */
		buf_tkn = strtok(NULL, del);
		if (buf_tkn == NULL) {
			break;
		}
	}

	for (j = 0; j < i; j++) {
		parse_string(p[j]);
	}

	g_free(text);
}

/* This func free a linked-list of app */
void 
free_applist(void)
{
	App  *garbage;
	App  *buf;

	/* remove app */
	buf = applist;
	while (1) {
		if (!buf) {
			break;
		}
		garbage = buf;

		if (buf->name) {
			g_free(buf->name);
			buf->name = NULL;
		}
		if (buf->image) {
			g_free(buf->image);
			buf->image = NULL;
		}
		if (buf->cmd) {
			g_free(buf->cmd);
			buf->cmd = NULL;
		}
		if (buf->args) {
			g_free(buf->args);
			buf->args = NULL;
		}

		/* next */
		buf = buf->next;

		g_free (garbage);
	}
	applist = NULL;
}

static Preference * 
new_preference(void)
{
	Preference *pref;

	pref = (Preference *) g_malloc(sizeof(Preference));
	pref->note = NULL;
	pref->top_note = NULL;
	pref->icon_path = NULL;
	pref->home = NULL;

	return pref;
}

static void 
init_default_preference(void)
{
	char *str_note = "Noname";
	char *str_app = "Readme";
	/*char *str_image = "Book.xpm"; */
	char *str_cmd = "xterm";
	char *str_args = "-e man workplace";

	Preferences->icon_path  = (char *) g_malloc(strlen(D_ICON_PATH)+1); 
	strcpy(Preferences->icon_path,  D_ICON_PATH); 
	Preferences->d_type = ICON;
	Preferences->width = 640;
	Preferences->height = 480;

	Preferences->note   = (Note *) g_malloc(sizeof(Note));
	Preferences->top_note  = Preferences->note;
	Preferences->note->next  = NULL;
 
	Preferences->note->name = (char *) g_malloc(strlen(str_note)+1);
	memset((char *) Preferences->note->name, 0, strlen(str_note)+1);
	strcpy(Preferences->note->name, str_note);

	Preferences->note->app = (App *) g_malloc(sizeof(App));
	Preferences->note->top_app  = Preferences->note->app;
	Preferences->note->app->next  = NULL;

	Preferences->note->app->name =  (char *) g_malloc(strlen(str_app)+1);
	memset((char *) Preferences->note->app->name, 0, strlen(str_app)+1);
	strcpy(Preferences->note->app->name,str_app);

	Preferences->note->app->image = NULL;
	/* (char *) g_malloc(strlen(str_image)+1);
	 * memset((char *) Preferences->note->app->image, 0, strlen(str_image)+1);
	 * strcpy(Preferences->note->app->image,str_image);
	 */
	Preferences->note->app->cmd  = (char *) g_malloc(strlen(str_cmd)+1);
	memset((char *) Preferences->note->app->cmd, 0, strlen(str_cmd)+1);
	strcpy(Preferences->note->app->cmd, str_cmd);

	Preferences->note->app->args = (char *) g_malloc(strlen(str_args)+1);
	memset((char *) Preferences->note->app->args, 0, strlen(str_args)+1);
	strcpy(Preferences->note->app->args, str_args);

	Preferences->note->app->dnd = NO;
}

static void 
parse_string(char *text)
{
	char  *tmp;
	char  *arg1, *arg2;

	int i;
	const char del[] = " ";

	if (!text) {
		return;
	}

	i = 0;
	tmp = strtok(text, del);
	if (strcmp(tmp, "Size") == 0) { 
                /* size fo workplace */
		tmp = strtok(NULL, del);

		/* set arg */
		arg1 = (char *) g_malloc(strlen(tmp));
		memset((char *) arg1, 0, strlen(tmp));
		strcpy(arg1, tmp);
		*(arg1+strlen(arg1)-1) = '\0';

                /* free */
		g_free(text);

		wp_window_size(arg1);
	}
	else if (strcmp(tmp, "Display_type") == 0) { 
                /* display type fo workplace */
		tmp = strtok(NULL, del);

		/* set arg */
		arg1 = (char *) g_malloc(strlen(tmp));
		memset((char *) arg1, 0, strlen(tmp));
		strcpy(arg1, tmp);
		*(arg1+strlen(arg1)-1) = '\0';

                /* free */
		g_free(text);

		wp_display_type(arg1);
	}
	else if (strcmp(tmp, "Icon_path") == 0) { 
                /* icon path */
		tmp = strtok(NULL, del);

		/* set arg */
		arg1 = (char *) g_malloc(strlen(tmp));
		memset((char *) arg1, 0, strlen(tmp));
		strcpy(arg1, tmp);
		*(arg1+strlen(arg1)-1) = '\0';

                /* free */
		g_free(text);

		wp_iconpath(arg1);
	}
	else if (strcmp(tmp, "Shortcut") == 0) { 
                /* shortcut path */
		tmp = strtok(NULL, del);

		/* set arg */
		arg1 = (char *) g_malloc(strlen(tmp)+1);
		memset((char *) arg1, 0, strlen(tmp)+1);
		strcpy(arg1, tmp);

		/* free */
		g_free(text);

		wp_shortcut(arg1);
	}
	else if (strcmp(tmp, "Note") == 0) {
		/* notebook */
		tmp = strtok(NULL, del);

		/* set arg */
		arg1 = (char *) g_malloc(strlen(tmp)+1);
		memset((char *) arg1, 0, strlen(tmp)+1);
		strcpy(arg1, tmp);

		tmp = tmp+strlen(tmp)+1;
		arg2 = (char *) g_malloc(strlen(tmp)+1);
		memset((char *) arg2, 0, strlen(tmp)+1);
		strcpy(arg2, tmp);

		/* free */
		g_free(text);

		wp_note(arg1, arg2);
	}
	else if (strcmp(tmp, "App") == 0) {
		/* notebook */
		tmp = strtok(NULL, del);

		/* set arg */
		arg1 = (char *) g_malloc(strlen(tmp)+1);
		memset((char *) arg1, 0, strlen(tmp)+1);
		strcpy(arg1, tmp);
		
		tmp = tmp+strlen(tmp)+1;
		arg2 = (char *) g_malloc(strlen(tmp)+1);
		memset((char *) arg2, 0, strlen(tmp)+1);
		strcpy(arg2, tmp);
		
		/* free */
		g_free(text);

		wp_app(arg1, arg2);
	}
	else {
		fprintf(stderr,"%s: not implemented symbol %s\n", Myname, tmp);
	}
}

static void
wp_window_size(char *arg)
{
	char *tmp;
	int  width;
	int  height;

	if (!arg) {
		fprintf(stderr,"%s: window_size != NULL \n", Myname);
		return;
	}

	tmp = strchr(arg, 'x');
	if (tmp) {
		*tmp = '\0';
		width = atoi(arg);
		height = atoi(tmp+1);

		Preferences->width = width;
		Preferences->height = height;
	}

}

static void
wp_display_type(char *arg)
{
	if (!arg) {
		fprintf(stderr,"%s: display_type != NULL \n", Myname);
		return;
	}
	if (strcmp(arg, "List") == 0) {
		Preferences->d_type = LIST;
	}
	else {
		Preferences->d_type = ICON;
	}
	g_free(arg);
}

static void
wp_iconpath(char *arg)
{
	if (!arg) {
		fprintf(stderr,"%s: wp_iconpath != NULL \n", Myname);
		return;
	}
	Preferences->icon_path = arg;
}

static void
wp_shortcut(char *arg)
{
	char         *buf;
	Shortcut     *tmp = NULL;
	const char del[] = " \t;{}";

	if (!arg) {
		fprintf(stderr,"%s: wp_shortcut != NULL \n", Myname);
		return;
	}

	buf = strtok(arg, del);
	while (1) {
		if (!buf) {
			break;
		}
		else {
			if (!tmp) {
				Preferences->shortcut = (Shortcut *) g_malloc(sizeof(Shortcut));
				tmp = Preferences->shortcut;
				tmp->next = NULL;
			}
			else {
				tmp->next =  (Shortcut *) g_malloc(sizeof(Shortcut));
				tmp = tmp->next;
				tmp->next = NULL;
			}
			tmp->path = (char *) g_malloc(strlen(buf)+1);
			strcpy(tmp->path, buf);
			
			/* next */
			buf = strtok(NULL, del);
		}
	}
	g_free(arg);
}

static void
wp_note(char *arg1, char *arg2)
{
	App        *app;
	char       *buf;
	const char del[] = " \t;{}";

	if (!arg1 || !arg2) {
		fprintf(stderr,"%s: wp_note != NULL \n", Myname);
		return;
	}


	if (!Preferences->top_note) {
		Preferences->note = (Note *) g_malloc(sizeof(Note));
		Preferences->top_note = Preferences->note;
		Preferences->note->name = arg1;
		Preferences->note->next = NULL;
		Preferences->note->top_app  = NULL;
	}
	else {
		Preferences->note->next = (Note *) g_malloc(sizeof(Note));
		Preferences->note = Preferences->note->next; 
		Preferences->note->name = arg1;
		Preferences->note->next = NULL;
		Preferences->note->top_app  = NULL;
	}
	/* app */
	buf = strtok(arg2, del);
	while (1) {
		if (!buf) {
			break;
		}
		if (!Preferences->note->top_app) {
			Preferences->note->app = (App *) g_malloc(sizeof(App));
			Preferences->note->top_app = Preferences->note->app;
			Preferences->note->app->next = NULL;

			/* search trayicon in app linked list */
			app = applist;
			while (1) {
				if (!app) {
					fprintf(stderr, "%s: parse err\n", Myname);
					break;
				}
				if (strcmp(buf, app->name) == 0) {
					Preferences->note->app->name = app->name;
					Preferences->note->app->image = app->image;
					Preferences->note->app->cmd = app->cmd;
					Preferences->note->app->args = app->args;
					Preferences->note->app->dnd = app->dnd;
					Preferences->note->app->next = NULL;
					break;
				}
				else {
					app = app->next;
				}
			}
		}
		else {
			Preferences->note->app->next = (App *) g_malloc(sizeof(App));
			Preferences->note->app = Preferences->note->app->next;
			Preferences->note->app->next = NULL;

			/* search trayicon in app linked list*/
			app = applist;
			while (1) {
				if (!app) {
					fprintf(stderr, "%s: parse err\n", Myname);
					break;
				}
				if (strcmp(buf, app->name) == 0) {
					Preferences->note->app->name = app->name;
					Preferences->note->app->image = app->image;
					Preferences->note->app->cmd = app->cmd;
					Preferences->note->app->args = app->args;
					Preferences->note->app->dnd = app->dnd;
					Preferences->note->app->next = NULL;
					break;
				}
				else {
					app = app->next;
				}
			}
		}
		buf = strtok(NULL, del);
	}
	g_free(arg2);
}

static void
wp_app (char *arg1, char *arg2)
{
	char       tmp1[256], tmp2[256];
	char       *buf = NULL;
	char       *eq = NULL;
	char       *p = NULL;
	char       *p_start = NULL;
	char       *p_end = NULL;
	char       *image = NULL;
	char       *cmd = NULL;
	char       *args = NULL;
	int        size = 0;
	int        i = 0;
	Boolen     dnd = 0;
	const char del[] = ";{}";

	if (!arg1 || !arg2) {
		fprintf(stderr,"%s: wp_app != NULL \n", Myname);
		return;
	}

	buf = strtok(arg2, del);
	while (1) {
		if (!buf) {
			break;
		}
		size = strlen(buf);

		eq = strchr(buf, '=');
		if (!eq) {
			return;
		}
		i = 0;
		for (p=buf ; p<eq ; p++) {
			if (isspace((int) *p) != 0); /* do nothing */
			else {
				tmp1[i++] = *p;
			}
		}
		tmp1[i] = '\0';

		p_start = strchr(eq, 0x22);
		p_end = strrchr(eq, 0x22);
		if (p_start && p_end && p_start != p_end) {
			i = 0;
			for (p = p_start+1; p < p_end ; p++) {
				tmp2[i++] = *p;
			}
			tmp2[i] = '\0';
		}
		else {
			i = 0;
			for (p = eq+1 ; p < buf+size ; p++) {
				if (isspace((int) *p) != 0);
				else {
					tmp2[i++] = *p;
				}
			}
			tmp2[i] = '\0';
		}


		if (strcmp(tmp1, "IMAGE") == 0) {
			if (strcmp(tmp2, "NULL") == 0) {
				args = NULL;
			}
			else {
				image = (char *) malloc(strlen(tmp2)+1);
				if (image) {
					memset((char *) image, 0, strlen(tmp2)+1);
					strcpy(image, tmp2);
				}
				else {
					/* free */
					g_free(arg2);
					fprintf(stderr,"g_malloc err\n");
					return;
				}
			}
		}
		else if (strcmp(tmp1, "CMD") == 0) {
			cmd = (char *) malloc(strlen(tmp2)+1);
			if (cmd) {
				memset((char *) cmd, 0, strlen(tmp2)+1);
				strcpy(cmd, tmp2);
			}
			else {
				/* free */
				g_free(arg2);
				fprintf(stderr,"g_malloc err\n");
				return;
			}
		}
		else if (strcmp(tmp1, "ARGS") == 0) {
			if (strcmp(tmp2, "NULL") == 0) {
				args = NULL;
			}
			else {
				args = (char *) malloc(strlen(tmp2)+1);
				if (args) {
					memset((char *) args, 0, strlen(tmp2)+1);
					strcpy(args, tmp2);
				}
				else {
					/* free */
					g_free(arg2);
					fprintf(stderr,"g_malloc err\n");
					return;
				}
			}
		}
		else if (strcmp(tmp1, "DND") == 0) {
			if (strcmp(tmp2, "NO") == 0) {
				dnd = NO;
			}
			else if (strcmp(tmp2, "YES") == 0) {
				dnd = YES;
			}
		}
		else {
			fprintf (stderr, "%s: parse err\n", Myname);
			fprintf (stderr, "We get a invalid name: %s \n", tmp1);
			exit(1);
		}
		/* get next token */
		buf = strtok(NULL, del);
	}
	if (!applist) {
		applist = (App *) g_malloc(sizeof(App));
		applist->next = NULL;
		current_app = applist;
	}
	else {
		current_app->next = (App *) g_malloc(sizeof(App));
		current_app = current_app->next;
		current_app->next = NULL;
	}

	/* free */
	g_free(arg2);
	current_app->name = arg1;
	current_app->image = image;
	current_app->cmd = cmd;
	current_app->args = args;
	current_app->dnd = dnd;
}

/* This func write preferences into a config file. */
void 
write_config_file (void)
{
	FILE      *fp;
	Shortcut  *buf_scut;
	App       *app;
	App       *tmp;
	char      *buf;
	char      *path;

	buf = (char *) g_malloc(MAX_DOTFILE_SIZE);

	/* size */
	sprintf(buf, "# This file is generated by Workplace.\n\nSize %ix%i;\n\n",
		Preferences->width, Preferences->height);

	/* Display type */
	strcat(buf, "Display_type");
	strcat(buf, " ");
	if (Preferences->d_type == LIST) {
		strcat(buf, "List");
	}
	else {
		strcat(buf, "Icon");
	}
	strcat(buf, ";\n\n");

	/* Icon */
	strcat(buf, "Icon_path");
	strcat(buf, " ");
	strcat(buf, Preferences->icon_path);
	strcat(buf, ";\n\n");

	/* Shortcut */
	strcat(buf, "Shortcut");
	strcat(buf, " ");
	strcat(buf, "{\n");
	buf_scut = Preferences->shortcut;
	while (1) {
		if (!buf_scut) {
			break;
		}
		strcat(buf, "\t");
		strcat(buf, buf_scut->path);
		strcat(buf, ";\n");
		
		/* next */
		buf_scut = buf_scut->next;

	}
	strcat(buf, "}\n\n");

	/* App */
	applist = NULL;
	Preferences->note =  Preferences->top_note;
	while (1){
		if (!Preferences->note) {
			break;
		}

		/* note label name*/
		Preferences->note->app =  Preferences->note->top_app;
		app = Preferences->note->app;
		while (1) {
			if (!app) {
				break;
			}

			tmp = applist;
			while (1) {
				if (!tmp) {
					if (!applist) {
						applist = (App *) g_malloc(sizeof(App));
						applist->next = NULL;
						applist->name = app->name;
						applist->image = app->image;
						applist->cmd = app->cmd;
						applist->args = app->args;
						applist->dnd = app->dnd;
						current_app = applist;

					}
					else {
						current_app->next = (App *) g_malloc(sizeof(App));
						current_app = current_app->next;
						current_app->next = NULL;
						
						current_app->name = app->name;
						current_app->image = app->image;
						current_app->cmd = app->cmd;
						current_app->args = app->args;
						current_app->dnd = app->dnd;
					}
					break;
				}
				if (strcmp(tmp->name , app->name) == 0) {
						break;
				}
				tmp = tmp->next;
			}
			app = app->next;
		}
		/* next note */
		Preferences->note = Preferences->note->next;
	}

	current_app = applist;
	while (1) {
		if(!current_app) {
			break;
		}
		strcat(buf, "App ");
		strcat(buf, current_app->name);
		strcat(buf, "\n");
		strcat(buf, "{\n");
		
		/* image */
		strcat(buf, "\tIMAGE = ");
		if (current_app->image) {
			strcat(buf, "\"");
			strcat(buf, current_app->image);
			strcat(buf, "\";\n");
		}
		else {
			strcat(buf, "NULL");
			strcat(buf, ";\n");	
		}

                /* command */
		strcat(buf, "\tCMD = ");
		strcat(buf, "\"");
		strcat(buf, current_app->cmd);
		strcat(buf, "\";\n");

		/* args */
		strcat(buf, "\tARGS = ");
		if (current_app->args) {
			strcat(buf, "\"");
			strcat(buf, current_app->args);
			strcat(buf, "\";\n");	
		}
		else {
			strcat(buf, "NULL");
			strcat(buf, ";\n");	
		}

		/* dnd */
		strcat(buf, "\tDND = ");
		if (current_app->dnd == NO) {
			strcat(buf, "NO;\n");
		}
		else {
			strcat(buf, "YES;\n");
		}

		/* end */
		strcat(buf, "};\n\n");

		current_app = current_app->next;
	}

	/* note */
	Preferences->note =  Preferences->top_note;
	while (1){
		if (!Preferences->note) {
			break;
		}

		/* note label name*/
		strcat(buf, "Note");
		strcat(buf, " ");
		strcat(buf, Preferences->note->name);
		strcat(buf, "\n{\n");
	
		Preferences->note->app =  Preferences->note->top_app;
		app = Preferences->note->app;
		while (1){
			if (!app) {
				break;
			}
			strcat(buf, "\t");
			strcat(buf, app->name);
			strcat(buf, ";\n");
			app = app->next;
		}
		strcat(buf, "};\n\n");
	
		/* next note */
		Preferences->note = Preferences->note->next;
	}
	/* end mark */
	strcat(buf, "#END" );

	path = (char *) g_malloc(strlen(Preferences->home) + strlen(DOT_DIR)
				 + strlen(WPPREF)+ 3);
	strcpy(path, Preferences->home);
	strcat(path, "/");
	strcat(path, DOT_DIR);
	strcat(path, "/");
	strcat(path, WPPREF);

	fp = fopen(path, "w+");
	g_free(path);

	fprintf(fp,"%s\n",buf);
	g_free(buf);
	fclose(fp);
}




