/*
 *    $Id: pref_suffix.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include "Workplace.h"
#include "suffix.h"
#include "d_message.h"
#include "preferences.h"
#include "gui_preference.h"
#include "app_preference.h"
#include "pref_suffix.h"

#define PW_COMPONET_HEIGHT 340
#define FILE_LIST_WIDTH  180
#define FILE_LIST_HEIGHT 100


typedef enum MenuNum {
	First,
	Second,
	Third
} MenuNum;

static Suffix *modified_default_menu;
static ModifiedMenu *modified_menu;
static ModifiedMenu *modified_menu_p;
static RemovedMenu *removed_menu;
static RemovedMenu *removed_menu_p;
static NewMenu *new_menu;
static NewMenu *new_menu_p;


static void init_suffix_tree(GtkWidget *parent);
static void init_buttons(GtkWidget *parent);
static GtkWidget * init_menu_preference(Suffix *suffix);
static void init_pixmap_parts (GtkWidget *box);
static void init_menu_parts (GtkWidget *box);
static void init_image_parts(GtkWidget *box);
static void press_name_handler(GtkWidget *widget,GdkEventButton *event);
static void new_handler(GtkWidget * widget);
static void updata_new (void);
static void undo_new (void);
static void remove_handler(GtkWidget * widget);
static void change_suffix(GtkWidget * widget, gpointer data);
static void change_xpm(GtkWidget *widget, GdkEventButton *event);
static void restore_menu (void);
static void change_to_1 (void);
static void change_to_2 (void);
static void change_to_3 (void);
static void destroy_menu_preference(GtkWidget *widget);
static void emphasize_suffixname(GtkWidget *widget);
static void free_SuffixPref (void);


extern Preference *Preferences;
extern Suffix *suffix_data;
extern Suffix *suffix_data_p;
extern Suffix *default_data;
extern SLL *image_files; 
extern GdkColor removed_color;
extern GdkColor new_color;

static GtkWidget *emphasized_suffixname;
static GtkWidget *new_widget_tmp;
static int flags_new;
static Suffix *current_data;
static Suffix *new_tmp;
static GtkWidget *right_box;
static GtkWidget *right_box_child;
static GtkWidget *left_box;
static GtkWidget *entry_suffix;
static GtkWidget *entry_name;
static GtkWidget *entry_cmd;
static GtkWidget *entry_args;
static GtkWidget *image_name;
static GtkWidget *pixmap_box;
static GtkWidget *pixmap;
static char  *suffix_name;
static char  *suffix_image;
static MenuNum menu_num;
static char *name1_str;
static char *cmd1_str;
static char *args1_str;
static char *name2_str;
static char *cmd2_str;
static char *args2_str;
static char *name3_str;
static char *cmd3_str;
static char *args3_str;

void
init_SuffixPref (GtkWidget *parent)
{
	GtkWidget  *main_box;
	GtkWidget  *window;

	/* main box */
	main_box = gtk_vbox_new(FALSE, 8);
	gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);

	/* window */
	window = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_usize(window, 130, PW_COMPONET_HEIGHT-30);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(window),GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(main_box), window, FALSE, FALSE, 0);
	gtk_widget_show(window);


	/* left box */
	left_box = gtk_vbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(left_box), 4);
	gtk_container_add(GTK_CONTAINER(window), left_box);
	gtk_widget_show(left_box);

	/* right box */
	right_box = gtk_vbox_new(FALSE, 0);
	gtk_widget_set_usize(right_box, 300, PW_COMPONET_HEIGHT);
	gtk_box_pack_start(GTK_BOX (parent), right_box,FALSE, FALSE, 0);
	gtk_widget_show(right_box);

	/* init suffix */
	init_suffix_tree(left_box);

	/* init button */
	init_buttons(main_box);
}

void
save_SuffixPref (void)
{
	NewMenu       *buf_new;
	NewMenu       *garbage_new;
	RemovedMenu   *buf_removed;
	RemovedMenu   *garbage_removed;
	ModifiedMenu  *buf_menu;
	ModifiedMenu  *garbage_modified;
	Suffix        *buf;

	/* new */
	updata_new();

	/* check */
	check_modified_menu_suffix(); 


	/* real_new */
	buf_new = new_menu;
	while (1) {
		if (!buf_new) {
			break;
		}
		suffix_data_p->next = buf_new->data;
		suffix_data_p = suffix_data_p->next;
		suffix_data_p->next = NULL;
		
		garbage_new = buf_new;

		/* next */
		buf_new = buf_new->next;
		g_free(garbage_new);
	}

	/* default */
	if (modified_default_menu) {
		/* 1st */
		if (default_data->name0)
			g_free(default_data->name0);
		default_data->name0 = modified_default_menu->name0;
		if (default_data->cmd0)
			g_free(default_data->cmd0);
		default_data->cmd0 = modified_default_menu->cmd0;
		if (default_data->arg0)
			g_free(default_data->arg0);
		default_data->arg0 = modified_default_menu->arg0;
		
		/* 2nd */
		if (default_data->name1)
			g_free(default_data->name1);
		default_data->name1 = modified_default_menu->name1;
		if (default_data->cmd1)
			g_free(default_data->cmd1);
		default_data->cmd1 = modified_default_menu->cmd1;
		if (default_data->arg1)
			g_free(default_data->arg1);
		default_data->arg1 = modified_default_menu->arg1;
		
		/* 3rd */
		if (default_data->name2)
			g_free(default_data->name2);
		default_data->name2 = modified_default_menu->name2;
		if (default_data->cmd2)
			g_free(default_data->cmd2);
		default_data->cmd2 = modified_default_menu->cmd2;
		if (default_data->arg2)
			g_free(default_data->arg2);
		default_data->arg2 = modified_default_menu->arg2;
		
		/* garbage */
		g_free(modified_default_menu);
	}

	buf_menu = modified_menu;
	while (1) {
		if (!buf_menu) {
			break;
		}
		
		buf = suffix_data;
		while (1) {
			if (!buf) {
				/* New ? */
				break;
			}
			else {
				if (buf == buf_menu->origin) {
					/* suffix */
					if (buf->suffix)
						g_free(buf->suffix);
					buf->suffix = buf_menu->data->suffix;
					
					/* image */
					if (buf->image) 
						g_free(buf->image);
					buf->image = buf_menu->data->image;

					/* 1st */
					if (buf->name0)
						g_free(buf->name0);
					buf->name0 = buf_menu->data->name0;
					if (buf->cmd0)
						g_free(buf->cmd0);
					buf->cmd0 = buf_menu->data->cmd0;
					if (buf->arg0)
						g_free(buf->arg0);
					buf->arg0 = buf_menu->data->arg0;

                                        /* 2nd */
					if (buf->name1)
						g_free(buf->name1);
					buf->name1 = buf_menu->data->name1;
					if (buf->cmd1)
						g_free(buf->cmd1);
					buf->cmd1 = buf_menu->data->cmd1;
					if (buf->arg1)
						g_free(buf->arg1);
					buf->arg1 = buf_menu->data->arg1;

                                        /* 3rd */
					if (buf->name2)
						g_free(buf->name2);
					buf->name2 = buf_menu->data->name2;
					if (buf->cmd2)
						g_free(buf->cmd2);
					buf->cmd2 = buf_menu->data->cmd2;
					if (buf->arg2)
						g_free(buf->arg2);
					buf->arg2 = buf_menu->data->arg2;
					break;
				}
				else {
					buf = buf->next;
				}
			}
		}
		garbage_modified = buf_menu;
		
		/* next */
		buf_menu = buf_menu->next;
		g_free(garbage_modified);
	}


	/* remove */
	buf_removed = removed_menu;
	while (1) {
		if (!buf_removed) {
			break;
		}
		buf = suffix_data;
		while (1) {
			if (!buf) {
				/* New ? */
				break;
			}
			else {
				if (buf == buf_removed->data) {
					if (buf->next) {
						suffix_data = buf->next;
						break;
					}
					else {
						suffix_data = NULL;
						break;
					}
				}
				else if (buf->next == buf_removed->data) {
					if (buf_removed->data->next) {
						buf->next = buf_removed->data->next;
						break;
					}
					else {
						buf->next = NULL;
						break;
					}
				}
				else {
					;
				}
				buf = buf->next;
			}
		}
		garbage_removed = buf_removed;
		
		/* next */
		buf_removed = buf_removed->next;
		g_free(garbage_removed);
	}

	free_SuffixPref ();
}

static void
free_SuffixPref (void)
{
	/* set NULL */
	modified_default_menu = NULL;
	modified_menu = NULL;
	modified_menu_p = NULL;
	removed_menu = NULL;
	removed_menu_p = NULL;
	new_menu = NULL;
	new_menu_p = NULL;
	flags_new = 0;
	current_data = NULL;
	new_tmp = NULL;
	right_box = NULL;
	right_box_child = NULL;
	left_box = NULL;
	entry_suffix = NULL;
	entry_name = NULL;
	entry_cmd = NULL;
	entry_args = NULL;
	image_name = NULL;
	pixmap_box = NULL;
	pixmap = NULL;
	suffix_name = NULL;
	suffix_image = NULL;
	name1_str = NULL;
	cmd1_str = NULL;
	args1_str = NULL;
	name2_str = NULL;
	cmd2_str = NULL;
	args2_str = NULL;
	name3_str = NULL;
	cmd3_str = NULL;
	args3_str = NULL;
	emphasized_suffixname = NULL;
	new_widget_tmp = NULL;
}

void
cancel_SuffixPref (void)
{
	NewMenu       *buf_new;
	NewMenu       *garbage_new;
	RemovedMenu   *buf_removed;
	RemovedMenu   *garbage_removed;
	ModifiedMenu  *buf_modified;
	ModifiedMenu  *garbage_modified;

	/* tmp */
	if (new_tmp) {
		if (new_tmp->suffix)
			g_free(new_tmp->suffix);
		/* image */
		if (new_tmp->image) 
			g_free(new_tmp->image);
		
		/* 1st */
		if (new_tmp->name0)
			g_free(new_tmp->name0);
		if (new_tmp->cmd0)
			g_free(new_tmp->cmd0);
		if (new_tmp->arg0)
			g_free(new_tmp->arg0);
		
		/* 2nd */
		if (new_tmp->name1)
			g_free(new_tmp->name1);
		if (new_tmp->cmd1)
			g_free(new_tmp->cmd1);
		if (new_tmp->arg1)
			g_free(new_tmp->arg1);
		
		/* 3rd */
		if (new_tmp->name2)
			g_free(new_tmp->name2);
		if (new_tmp->cmd2)
			g_free(new_tmp->cmd2);
		if (new_tmp->arg2)
			g_free(new_tmp->arg2);

		g_free(new_tmp);
		new_tmp = NULL;
	}

	/* default */
	if (modified_default_menu) {
		/* 1st */
		if (modified_default_menu->name0)
			g_free(modified_default_menu->name0);
		if (modified_default_menu->cmd0)
			g_free(modified_default_menu->cmd0);
		if (modified_default_menu->arg0)
			g_free(modified_default_menu->arg0);
		
		/* 2nd */
		if (modified_default_menu->name1)
			g_free(modified_default_menu->name1);
		if (modified_default_menu->cmd1)
			g_free(modified_default_menu->cmd1);
		if (modified_default_menu->arg1)
			g_free(modified_default_menu->arg1);
		
		/* 3rd */
		if (modified_default_menu->name2)
			g_free(modified_default_menu->name2);
		if (modified_default_menu->cmd2)
			g_free(modified_default_menu->cmd2);
		if (modified_default_menu->arg2)
			g_free(modified_default_menu->arg2);
	}
	
	/* new */
	buf_new = new_menu;
	while (1) {
		if (!buf_new) {
			break;
		}
		/* suffix */
		if (buf_new->data->suffix)
			g_free(buf_new->data->suffix);
		
		/* image */
		if (buf_new->data->image) 
			g_free(buf_new->data->image);
		
		/* 1st */
		if (buf_new->data->name0)
			g_free(buf_new->data->name0);
		if (buf_new->data->cmd0)
			g_free(buf_new->data->cmd0);
		if (buf_new->data->arg0)
			g_free(buf_new->data->arg0);
		
		/* 2nd */
		if (buf_new->data->name1)
			g_free(buf_new->data->name1);
		if (buf_new->data->cmd1)
			g_free(buf_new->data->cmd1);
		if (buf_new->data->arg1)
			g_free(buf_new->data->arg1);
		
		/* 3rd */
		if (buf_new->data->name2)
			g_free(buf_new->data->name2);
		if (buf_new->data->cmd2)
			g_free(buf_new->data->cmd2);
		if (buf_new->data->arg2)
			g_free(buf_new->data->arg2);
									
		garbage_new = buf_new;
		buf_new = buf_new->next;
		g_free(garbage_new->data);
		g_free(garbage_new);
	}

	/* remove */
	buf_removed = removed_menu;
	while (1) {
		if (!buf_removed) {
			break;
		}
		garbage_removed = buf_removed;
		buf_removed = buf_removed->next;
		g_free(garbage_removed);
	}

	/* modified */
	buf_modified = modified_menu;
	while (1) {
		if (!buf_modified) {
			break;
		}
		/* suffix */
		if (buf_modified->data->suffix)
			g_free(buf_modified->data->suffix);
		
		/* image */
		if (buf_modified->data->image) 
			g_free(buf_modified->data->image);
		
		/* 1st */
		if (buf_modified->data->name0)
			g_free(buf_modified->data->name0);
		if (buf_modified->data->cmd0)
			g_free(buf_modified->data->cmd0);
		if (buf_modified->data->arg0)
			g_free(buf_modified->data->arg0);
		
		/* 2nd */
		if (buf_modified->data->name1)
			g_free(buf_modified->data->name1);
		if (buf_modified->data->cmd1)
			g_free(buf_modified->data->cmd1);
		if (buf_modified->data->arg1)
			g_free(buf_modified->data->arg1);
		
		/* 3rd */
		if (buf_modified->data->name2)
			g_free(buf_modified->data->name2);
		if (buf_modified->data->cmd2)
			g_free(buf_modified->data->cmd2);
		if (buf_modified->data->arg2)
			g_free(buf_modified->data->arg2);
									
		garbage_modified = buf_modified;
		buf_modified = buf_modified->next;
		g_free(garbage_modified->data);
		g_free(garbage_modified);
	}
	
	/* set NULL */
	free_SuffixPref();
}

static void 
init_suffix_tree(GtkWidget *parent)
{
	GtkWidget  *main_box;
	GtkWidget  *event_box;
	GtkWidget  *label;
	Suffix     *buf;

	/* default */
	buf = default_data;
	if (buf) {
		/* main box */
		main_box = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
		gtk_widget_show(main_box);
		
		/* label event widget */
		event_box = gtk_event_box_new ();
		gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
		gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
				   GTK_SIGNAL_FUNC(press_name_handler), NULL);
		gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
				   GTK_SIGNAL_FUNC(emphasize_suffixname), NULL);
		gtk_object_set_user_data(GTK_OBJECT(event_box), buf);
		gtk_box_pack_start(GTK_BOX(main_box), event_box, TRUE, TRUE, 0);
		gtk_widget_show(event_box);
		
		/* name */
		label = gtk_label_new("default");
		gtk_misc_set_alignment (GTK_MISC (label), 0.1, 0.5);
		gtk_container_add(GTK_CONTAINER(event_box), label);
		gtk_widget_show(label);

		/* set widget */
		buf->gw_pref = NULL;
	}
	else {
		create_dialog_message("Set WPSuffix file.");
	}


	buf = suffix_data;
	while (1) {
		if (!buf) {
			break;
		}

		/* main box */
		main_box = gtk_hbox_new(FALSE, 2);
		gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
		gtk_widget_show(main_box);

                /* label event widget */
		event_box = gtk_event_box_new ();
		gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
		gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
				   GTK_SIGNAL_FUNC(press_name_handler), NULL);
		gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
				   GTK_SIGNAL_FUNC(emphasize_suffixname), NULL);
		gtk_object_set_user_data(GTK_OBJECT(event_box), buf);
		gtk_box_pack_start(GTK_BOX(main_box), event_box, TRUE, TRUE, 0);
		gtk_widget_show(event_box);

		/* name */
		label = gtk_label_new(buf->suffix);
		gtk_misc_set_alignment (GTK_MISC (label), 0.1, 0.5);
		gtk_container_add(GTK_CONTAINER(event_box), label);
		gtk_widget_show(label);

		/* set widget */
		buf->gw_pref = label;

		/* next */
		buf = buf->next;
	}
}

static void 
init_buttons(GtkWidget *parent)
{
	GtkWidget  *hbox1;
	GtkWidget  *hbox2;
	GtkWidget  *button;
 
	/* box */
	hbox1 = gtk_hbox_new(TRUE, 4);
	gtk_box_pack_start(GTK_BOX (parent), hbox1, TRUE, TRUE, 0);
	gtk_widget_show(hbox1);

	/* box */
	hbox2 = gtk_hbox_new(TRUE, 4);
	gtk_box_pack_start(GTK_BOX (parent), hbox2, TRUE, TRUE, 0);
	gtk_widget_show(hbox2);
		
	/* button */
	button = gtk_button_new_with_label(" New ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(new_handler), NULL);
	gtk_box_pack_start(GTK_BOX(hbox1), button, TRUE, TRUE, 0);
	gtk_widget_show(button);

	/* button */
	button = gtk_button_new_with_label(" Remove ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(remove_handler), NULL);
	gtk_box_pack_start(GTK_BOX(hbox1), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
}


static GtkWidget *
init_menu_preference(Suffix *suffix)
{
	GtkWidget  *main_box;
	GtkWidget  *name_box1;
	GtkWidget  *name_box2;
	GtkWidget  *name_box3;
	GtkWidget  *name_label;
	GtkWidget  *separator;
	GtkWidget  *image_box;
	GtkWidget  *menu_box;
	
	suffix_name  = suffix->suffix;
	suffix_image = suffix->image;
	
	/* 1st */
	if (suffix->name0) {
		name1_str = (char *) g_malloc(strlen(suffix->name0)+1);
		strcpy(name1_str, suffix->name0);
	}
	else {
		name1_str = NULL;
	}
	if (suffix->cmd0) {
		cmd1_str = (char *) g_malloc(strlen(suffix->cmd0)+1);
		strcpy(cmd1_str, suffix->cmd0);
	}
	else {
		cmd1_str = NULL;
	}
	if (suffix->arg0) {
		args1_str = (char *) g_malloc(strlen(suffix->arg0)+1);
		strcpy(args1_str, suffix->arg0);
	}
	else {
		args1_str = NULL;
	}

	/* 2nd */
	if (suffix->name1) {
		name2_str = (char *) g_malloc(strlen(suffix->name1)+1);
		strcpy(name2_str, suffix->name1);
	}
	else {
		name2_str = NULL;
	}
	if (suffix->cmd1) {
		cmd2_str = (char *) g_malloc(strlen(suffix->cmd1)+1);
		strcpy(cmd2_str, suffix->cmd1);
	}
	else {
		cmd2_str = NULL;
	}
	if (suffix->arg1) {
		args2_str = (char *) g_malloc(strlen(suffix->arg1)+1);
		strcpy(args2_str, suffix->arg1);
	}
	else {
		args2_str = NULL;
	}

	/* 3rd */
	if (suffix->name2) {
		name3_str = (char *) g_malloc(strlen(suffix->name2)+1);
		strcpy(name3_str, suffix->name2);
	}
	else {
		name3_str = NULL;
	}
	if (suffix->cmd2) {
		cmd3_str = (char *) g_malloc(strlen(suffix->cmd2)+1);
		strcpy(cmd3_str, suffix->cmd2);
	}
	else {
		cmd3_str = NULL;
	}
	if (suffix->arg2) {
		args3_str = (char *) g_malloc(strlen(suffix->arg2)+1);
		strcpy(args3_str, suffix->arg2);
	}
	else {
		args3_str = NULL;
	}

	/* main box */
	main_box = gtk_vbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(right_box), main_box, TRUE, TRUE, 0);
	gtk_widget_show(main_box);
	
	/* a part of application name  */
	/* name label */
	name_box1 = gtk_hbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(name_box1), 8);
	gtk_box_pack_start(GTK_BOX (main_box), name_box1, FALSE, FALSE, 0);
	gtk_widget_show(name_box1);
	
	name_box2 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX (name_box1), name_box2, TRUE, TRUE, 0);
	gtk_widget_show(name_box2);
	
	name_box3 = gtk_vbox_new(FALSE, 2);
	gtk_box_pack_end(GTK_BOX (name_box2), name_box3, FALSE, FALSE, 0);
	gtk_widget_show(name_box3);
	
	name_label = gtk_label_new("Suffix:");
	gtk_misc_set_alignment (GTK_MISC (name_label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX (name_box3), name_label, FALSE, FALSE, 0);
	gtk_widget_show(name_label);
	
	/* suffix entry */
	entry_suffix = gtk_entry_new();
	if (suffix_name){
		gtk_entry_set_text(GTK_ENTRY(entry_suffix), suffix_name);
	}
	gtk_signal_connect(GTK_OBJECT(entry_suffix), "changed",
			   GTK_SIGNAL_FUNC(change_suffix), NULL);
	gtk_box_pack_start(GTK_BOX (name_box3), entry_suffix, TRUE, TRUE, 0);
	gtk_widget_show(entry_suffix);
	
	/*separator*/
	separator = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (main_box), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);

	/* a part of application pixmap */
	image_box = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX (main_box), image_box, TRUE, TRUE, 0);
	gtk_widget_show(image_box);
	init_pixmap_parts(image_box);
	
	/*separator*/
	separator = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (main_box), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);


	/* menu parts */
	menu_box = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX (main_box), menu_box, TRUE, TRUE, 0);
	gtk_widget_show(menu_box);
	init_menu_parts(menu_box);

	return main_box;
}

static void
init_pixmap_parts (GtkWidget *box)
{
	SLL        *buf;
	GtkWidget  *main_box;
	GtkWidget  *vbox1;
	GtkWidget  *hbox;
	GtkWidget  *label;
	GtkWidget  *arrow;
	GtkWidget  *vbox2;
	GtkWidget  *swin;
	GtkWidget  *listbox;
	GtkWidget  *list_item;

	/* main box */
	main_box = gtk_hbox_new(FALSE, 8);
	gtk_container_border_width(GTK_CONTAINER (main_box), 8);
	gtk_box_pack_start(GTK_BOX (box), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);
	  
	/*  vbox 2 */
	vbox1 = gtk_vbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(main_box), vbox1, FALSE, FALSE, 0);
	gtk_widget_show(vbox1);

	/* hbox */
	hbox = gtk_hbox_new(FALSE, 8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	/* label */
	label = gtk_label_new ("XPixmap file");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);
	
	/* arrow */
	arrow = gtk_arrow_new(GTK_ARROW_RIGHT, GTK_SHADOW_IN);
	gtk_signal_connect(GTK_OBJECT(arrow), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), arrow, FALSE, FALSE, 0);
	gtk_widget_show(arrow);

	/* hbox */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, TRUE, FALSE, 0);
	gtk_widget_show(hbox);

	init_image_parts(hbox);

	/*  vbox 2 */
	vbox2 = gtk_vbox_new(FALSE, 4);
	gtk_box_pack_end(GTK_BOX(main_box), vbox2, TRUE, TRUE, 0);
	gtk_widget_show(vbox2);
	
	/* label */
	image_name = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (vbox2), image_name, FALSE, FALSE, 0);
	gtk_widget_show (image_name);

	if (suffix_image) {
		gtk_entry_set_text(GTK_ENTRY(image_name), suffix_image);
	}

	/* scroll window */
	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (swin), GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_ALWAYS);
	gtk_widget_set_usize (swin, FILE_LIST_WIDTH, FILE_LIST_HEIGHT);
	gtk_signal_connect (GTK_OBJECT (swin), "button_press_event",
			    (GtkSignalFunc) change_xpm, NULL);
	gtk_box_pack_start (GTK_BOX (vbox2), swin, TRUE, TRUE, 0);
	gtk_widget_show(swin);
		
	listbox = gtk_list_new ();
	gtk_list_set_selection_mode(GTK_LIST (listbox), GTK_SELECTION_BROWSE);
	gtk_container_add(GTK_CONTAINER (swin), listbox);
	gtk_widget_show(listbox);

	/* make list  */
	buf = image_files;
	while (1){
		if (!buf){
			break;
		}
		list_item = gtk_list_item_new_with_label(buf->data);
		gtk_container_add(GTK_CONTAINER (listbox), list_item);
		gtk_object_set_user_data (GTK_OBJECT (list_item), buf->data);
		gtk_widget_show(list_item);
		buf = buf->next;
	}
}

static void
init_menu_parts (GtkWidget *parent)
{
	GtkWidget  *main_box;
	GtkWidget  *hbox;
	GtkWidget  *vbox1;
	GtkWidget  *vbox2;
	GtkWidget  *label;
	GtkWidget  *option_menu;
	GtkWidget  *menu;
	GtkWidget  *menu_item;

	/* main box */
	main_box = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER (main_box), 8);
	gtk_box_pack_start(GTK_BOX(parent), main_box, TRUE, TRUE, 0);
	gtk_widget_show(main_box);

	/* menu */
	menu = gtk_menu_new ();

	/* set a menu item of  */
	menu_item = gtk_menu_item_new_with_label(" 1st menu ");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", 
			   (GtkSignalFunc) change_to_1, NULL);
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_widget_show(menu_item);

	/* set a menu item of */
	menu_item = gtk_menu_item_new_with_label(" 2nd menu ");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", 
			   (GtkSignalFunc) change_to_2, NULL);
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_widget_show(menu_item);

	/* set a menu item of */
	menu_item = gtk_menu_item_new_with_label(" 3rd menu ");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", 
			   (GtkSignalFunc) change_to_3, NULL);
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_widget_show(menu_item);


	/* option menu */
	option_menu = gtk_option_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), menu);
	gtk_box_pack_start (GTK_BOX (main_box), option_menu, FALSE, FALSE, 0);
	gtk_widget_show (option_menu);

	/*  hbox */
	hbox = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(main_box), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);


	/* vbox1 */
	vbox1 = gtk_vbox_new(TRUE, 4);
	gtk_box_pack_start(GTK_BOX(hbox), vbox1, TRUE, TRUE, 0);
	gtk_widget_show(vbox1);

	/* vbox2 */
	vbox2 = gtk_vbox_new(TRUE, 4);
	gtk_box_pack_start(GTK_BOX(hbox), vbox2, TRUE, TRUE, 0);
	gtk_widget_show(vbox2);

	/* label */
	label = gtk_label_new ("Name:");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_box_pack_start (GTK_BOX (vbox1), label, FALSE, FALSE, 0);
	gtk_widget_show (label);

	label = gtk_label_new ("Command:");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_box_pack_start (GTK_BOX (vbox1), label, FALSE, FALSE, 0);
	gtk_widget_show (label);


	label = gtk_label_new ("Args:");
	gtk_misc_set_alignment (GTK_MISC(label), 0.0, 0.5);
	gtk_box_pack_start (GTK_BOX (vbox1), label, FALSE, FALSE, 0);
	gtk_widget_show (label);

	/* entry for name*/
	entry_name = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (vbox2), entry_name, TRUE, TRUE, 0);
	gtk_widget_show (entry_name);

	/* entry for commmad */
	entry_cmd = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (vbox2), entry_cmd, TRUE, TRUE, 0);
	gtk_widget_show (entry_cmd);

	/* entry for args */
	entry_args = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (vbox2), entry_args, TRUE, TRUE, 0);
	gtk_widget_show (entry_args);


	/* set contents */
	menu_num = First;
	gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu), 0);

	/* set on entry */
	if (name1_str)
		gtk_entry_set_text(GTK_ENTRY(entry_name), name1_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_name), "");

	if (cmd1_str)
		gtk_entry_set_text(GTK_ENTRY(entry_cmd), cmd1_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_cmd), "");

	if (args1_str) 
		gtk_entry_set_text(GTK_ENTRY(entry_args), args1_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_args), "");
}

static void
init_image_parts(GtkWidget *box)
{
	GtkWidget   *button;
	GdkPixmap   *pixmap_data = NULL;
	GdkBitmap   *mask;
	GtkStyle    *style;
	char        *pathname;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();

	/* Button (frame) */
	button = gtk_frame_new (NULL);
	gtk_widget_set_usize(button, ICON_SIZE, ICON_SIZE);
	gtk_frame_set_shadow_type (GTK_FRAME (button), GTK_SHADOW_IN);
	gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 0);
	gtk_widget_show (button);
	
	/* Button box */
	pixmap_box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(button), pixmap_box);
	gtk_widget_show(pixmap_box);

	/* style */
	style = gtk_widget_get_style(button);

	/* Pixmap */
	if (suffix_image) {
		pathname = (char *) g_malloc(strlen(Preferences->icon_path)+strlen(suffix_image)+2);
		strcpy(pathname, Preferences->icon_path);
		strcat(pathname, "/");
		strcat(pathname, suffix_image);
		pixmap_data = gdk_pixmap_colormap_create_from_xpm(NULL, cmap, &mask, 
								  &style->bg[GTK_STATE_NORMAL],
								  pathname);
		g_free(pathname);
	}
	else {
		pixmap_data = NULL;
	}
	if (pixmap_data) {
		pixmap = gtk_pixmap_new(pixmap_data, mask);
		gtk_box_pack_start(GTK_BOX(pixmap_box),pixmap, TRUE, FALSE, 0);
		gtk_widget_show(pixmap);
	}
	else {
		pixmap = NULL;
	}
}


static void 
new_handler(GtkWidget * widget)
{
	GtkWidget  *main_box;
	GtkWidget  *event_box;
	GtkWidget  *label;
	GtkStyle   *style;
 
        /* save */
	/*restore_menu();*/
	updata_new();

        new_tmp = (Suffix *) g_malloc(sizeof(Suffix));
	
	new_tmp->suffix = NULL;
	new_tmp->image = NULL;
	
	new_tmp->name0 = NULL;
	new_tmp->cmd0 = NULL;
	new_tmp->arg0 = NULL;
	
	new_tmp->name1 = NULL;
	new_tmp->cmd1 = NULL;
	new_tmp->arg1 = NULL;
	
	new_tmp->name2 = NULL;
	new_tmp->cmd2 = NULL;
	new_tmp->arg2 = NULL;
	
	
	if (current_data) {
		check_modified_menu_suffix();
		destroy_menu_preference(right_box_child);
		current_data = new_tmp;
		right_box_child = init_menu_preference(new_tmp);
	}
	else {
		current_data = new_tmp;
		right_box_child = init_menu_preference(new_tmp);
	}

	style = gtk_style_new();
	style->fg[GTK_STATE_NORMAL] = new_color;

	/* main box */
	main_box = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(left_box), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);
	
	/* label event widget */
	event_box = gtk_event_box_new ();
	gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(press_name_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
				   GTK_SIGNAL_FUNC(emphasize_suffixname), NULL);
	gtk_object_set_user_data(GTK_OBJECT(event_box), new_tmp);
	gtk_box_pack_start(GTK_BOX(main_box), event_box, TRUE, TRUE, 0);
	gtk_widget_show(event_box);
	
	/* name */
	label = gtk_label_new("New");
	gtk_widget_set_style(label, style);
	gtk_misc_set_alignment (GTK_MISC (label), 0.1, 0.5);
	gtk_container_add(GTK_CONTAINER(event_box), label);
	gtk_widget_show(label);
	
	/* set widget */
        new_tmp->gw_pref = label;
	new_widget_tmp =  main_box;

	/* do emphasize */
	if (emphasized_suffixname) {
		if (emphasized_suffixname->window)
			gdk_window_clear(emphasized_suffixname->window);
		gtk_widget_draw_children(emphasized_suffixname);
	}
	emphasized_suffixname = event_box;
	emphasize_suffixname(emphasized_suffixname);
	
	flags_new = 1;
}

static void
undo_new (void)
{
	if (flags_new && !suffix_name) {
		gtk_widget_destroy(new_widget_tmp);

		/* image */
		if (new_tmp->image) 
			g_free(new_tmp->image);
		
		/* 1st */
		if (new_tmp->name0)
			g_free(new_tmp->name0);
		if (new_tmp->cmd0)
			g_free(new_tmp->cmd0);
		if (new_tmp->arg0)
			g_free(new_tmp->arg0);
		
		/* 2nd */
		if (new_tmp->name1)
			g_free(new_tmp->name1);
		if (new_tmp->cmd1)
			g_free(new_tmp->cmd1);
		if (new_tmp->arg1)
			g_free(new_tmp->arg1);
		
		/* 3rd */
		if (new_tmp->name2)
			g_free(new_tmp->name2);
		if (new_tmp->cmd2)
			g_free(new_tmp->cmd2);
		if (new_tmp->arg2)
			g_free(new_tmp->arg2);

		g_free(new_tmp);
		new_widget_tmp = NULL;
		new_tmp = NULL;
		flags_new = 0;
	}
}

static void
updata_new (void)
{
	NewMenu  *p;


	if(!flags_new)
		return;
	undo_new();

	restore_menu();
	p = (NewMenu *) g_malloc(sizeof(NewMenu));
	p->data = new_tmp;

	
	if (suffix_name) {
		p->data->suffix = (char *) g_malloc(strlen(suffix_name)+1);
		strcpy(p->data->suffix, suffix_name);
	}

	if (suffix_image) {
		p->data->image = (char *) g_malloc(strlen(suffix_image)+1);
		strcpy(p->data->image, suffix_image);
	}

	/* 1st menu */
	if (name1_str) {
		p->data->name0 = name1_str; 
	}
	else {
		p->data->name0 = NULL; 
	}
	if (cmd1_str) {
		p->data->cmd0 = cmd1_str;
	}
	else {
		p->data->cmd0 = NULL;
	}
	if (args1_str) {
		p->data->arg0 = args1_str;
	}
	else {
		p->data->arg0 = NULL;
	}

	/* 2nd menu */
	if (name2_str) {
		p->data->name1 = name2_str; 
	}
	else {
		p->data->name1 = NULL; 
	}
	if (cmd2_str) {
		p->data->cmd1 = cmd2_str;
	}
	else {
		p->data->cmd1 = NULL;
	}
	if (args2_str) {
		p->data->arg1 = args2_str;
	}
	else {
		p->data->arg1 = NULL;
	}

	/* 3rd menu */
	if (name3_str) {
		p->data->name2 = name3_str; 
	}
	else {
		p->data->name2 = NULL; 
	}
	if (cmd3_str) {
		p->data->cmd2 = cmd3_str;
	}
	else {
		p->data->cmd2 = NULL;
	}
	if (args3_str) {
		p->data->arg2 = args3_str;
	}
	else {
		p->data->arg2 = NULL;
	}


	if (new_menu) {
		new_menu_p->next = p;
		new_menu_p = new_menu_p->next;
		new_menu_p->next = NULL;
	}
	else {
		new_menu = p;
		new_menu_p = new_menu;
		new_menu_p->next = NULL;
	}

	/* change label */
	if (new_menu_p->data->suffix)
		gtk_label_set(GTK_LABEL(new_menu_p->data->gw_pref),  new_menu_p->data->suffix);
				
	new_tmp = NULL;
	new_widget_tmp = NULL;
	flags_new = 0;
}

static void 
remove_handler(GtkWidget * widget)
{
	RemovedMenu  *p;
	GtkStyle *style;

	style = gtk_style_new();
	style->fg[GTK_STATE_NORMAL] = removed_color;

	if (!current_data)
		return;

	/* save */
	restore_menu();
	p = (RemovedMenu *) g_malloc(sizeof(RemovedMenu));

	p->data = current_data;

	if (removed_menu) {
		removed_menu_p->next = p;
		removed_menu_p = removed_menu_p->next;
		removed_menu_p->next = NULL;
	}
	else {
		removed_menu = p;
		removed_menu_p = removed_menu;
		removed_menu_p->next = NULL;
	}

	gtk_widget_set_style(current_data->gw_pref , style);
	gtk_widget_draw_children(current_data->gw_pref );
}


void 
check_modified_menu_suffix (void)
{
	ModifiedMenu  *p;
	int           flags = 0;
	int           flags_default = 0;

	if (!current_data)
		return;

	p = (ModifiedMenu *) g_malloc(sizeof(ModifiedMenu));
	p->data = (Suffix *) g_malloc(sizeof(Suffix));

	p->data->name0 = NULL;
	p->data->cmd0  = NULL;
	p->data->arg0  = NULL;
	p->data->name1 = NULL;
	p->data->cmd1  = NULL;
	p->data->arg1  = NULL;
	p->data->name2 = NULL;
	p->data->cmd2  = NULL;
	p->data->arg2  = NULL;

	/* save */
	restore_menu();

	if (current_data->suffix) {
		if (suffix_name) {
			if (strcmp(current_data->suffix, suffix_name) != 0) {
				p->data->suffix = (char *) g_malloc(strlen(suffix_name)+1);
				strcpy(p->data->suffix, suffix_name);
				flags = 1;
			}
			else {
				p->data->suffix = (char *) g_malloc(strlen(current_data->suffix)+1);
				strcpy(p->data->suffix, current_data->suffix);
			}
		}
		else {
			p->data->suffix = NULL;
			flags = 1;
			flags_default = 1;
		}
	}
	else {
		if (suffix_name) {
			p->data->suffix = (char *) g_malloc(strlen(suffix_name)+1);
			strcpy(p->data->suffix, suffix_name);
			flags = 1;
		}
		else {
			p->data->suffix = NULL;
			flags_default = 1;
		}
	}

	if (current_data->image) {
		if (suffix_image) {
			if (strcmp(current_data->image, suffix_image) != 0) {
				p->data->image = (char *) g_malloc(strlen(suffix_image)+1);
				strcpy(p->data->image, suffix_image);
				flags = 1;
			}
			else {
				p->data->image = (char *) g_malloc(strlen(current_data->image)+1);
				strcpy(p->data->image, current_data->image);
			}
			
		}
		else {
			p->data->image = NULL;
			flags = 1;
		}
	}
	else {
		if (suffix_image) {
			p->data->image = (char *) g_malloc(strlen(suffix_image)+1);
			strcpy(p->data->image, suffix_image);
			flags = 1;
		}
		else {
			p->data->image = NULL;
		}
	}
	

	/* 1st menu */
	if (current_data->name0) {
		if (name1_str) {
			if (strcmp(current_data->name0, name1_str) != 0) {
				p->data->name0 = name1_str;
				flags = 1;
			}
			else {
				p->data->name0 = (char *) g_malloc(strlen(current_data->name0)+1);
				strcpy(p->data->name0, current_data->name0);
			}
		}
		else {
			p->data->name0 = NULL; 
			flags = 1;
		}
	}
	else {
		if (name1_str) {
			p->data->name0 = name1_str; 
			flags = 1;
		}
		else 
			p->data->name0 = NULL; 
	}

	if (current_data->cmd0) { 
		if (cmd1_str) {
			if (strcmp(current_data->cmd0, cmd1_str) != 0) {
				p->data->cmd0 = cmd1_str; 
				flags = 1;
			}
			else {
				p->data->cmd0 = (char *) g_malloc(strlen(current_data->cmd0)+1);
				strcpy(p->data->cmd0, current_data->cmd0);
			}	
		}
		else {
			p->data->cmd0 = NULL; 
			flags = 1;
		}
	}
	else {
		if (cmd1_str) {
			p->data->cmd0 = cmd1_str; 
			flags = 1;
		}
		else 
			p->data->cmd0 = NULL;
	}

	if (current_data->arg0) {
		if (args1_str) {
			if (strcmp(current_data->arg0, args1_str) != 0) {
				p->data->arg0 = args1_str; 
				flags = 1;
			}
			else {
				p->data->arg0 = (char *) g_malloc(strlen(current_data->arg0)+1);
				strcpy(p->data->arg0, current_data->arg0);
			}
		}
		else {
			p->data->arg0 = NULL; 
			flags = 1;
		}
	}
	else {
		if (args1_str) {
			p->data->arg0 = args1_str; 
			flags = 1;
		}
		else 
			p->data->arg0 = NULL; 
	}

	/* 2nd menu */
	if (current_data->name1) {
		if (name2_str) {
			if (strcmp(current_data->name1, name2_str) != 0) {
				p->data->name1 = name2_str; 
				flags = 1;
			}
			else {
				p->data->name1 = (char *) g_malloc(strlen(current_data->name1)+1);
				strcpy(p->data->name1, current_data->name1);
			}
		}
		else {
			p->data->name1 = NULL; 
			flags = 1;
		}
	}
	else {
		if (name2_str) {
			p->data->name1 = name2_str; 
			flags = 1;
		}
		else {
			p->data->name1 = NULL; 
		}
	}

	if (current_data->cmd1) {
		if (cmd2_str) {
			if (strcmp(current_data->cmd1, cmd2_str) != 0) {
				p->data->cmd1 = cmd2_str; 
				flags = 1;
			}
			else {
				p->data->cmd1 = (char *) g_malloc(strlen(current_data->cmd1)+1);
				strcpy(p->data->cmd1, current_data->cmd1);
			}
		}
		else {
			p->data->cmd1 = NULL; 
			flags = 1;
		}
	}
	else {
		if (cmd2_str) {
			p->data->cmd1 = cmd2_str; 
			flags = 1;
		}
		else 
			p->data->cmd1 = NULL; 
	}

	if (current_data->arg1) {
		if (args2_str) {
			if (strcmp(current_data->arg1, args2_str) != 0) {
				p->data->arg1 = args2_str; 
				flags = 1;
			}
			else {
				p->data->arg1 = (char *) g_malloc(strlen(current_data->arg1)+1);
				strcpy(p->data->arg1, current_data->arg1);
			}
		}
		else {
			p->data->arg1 = NULL; 
			flags = 1;
		}
	}
	else {
		if (args2_str) {
			p->data->arg1 = args2_str; 
			flags = 1;
		}
		else
			p->data->arg1 = NULL; 
	}

	/* 3rd menu */
	if (current_data->name2) {
		if (name3_str) {
			if (strcmp(current_data->name2, name3_str) != 0) {
				p->data->name2 = name3_str; 
				flags = 1;
			}
			else {
				p->data->name2 = (char *) g_malloc(strlen(current_data->name2)+1);
				strcpy(p->data->name2, current_data->name2);
			}
		}
		else {
			p->data->name2 = NULL; 
			flags = 1;
		}
	}
	else {
		if (name3_str) {
			p->data->name2 = name3_str; 
			flags = 1;
		}
		else
			p->data->name2 = NULL; 
	}

	if (current_data->cmd2) {
		if (cmd3_str) {
			if (strcmp(current_data->cmd2, cmd3_str) != 0) {
				p->data->cmd2 = cmd3_str; 
				flags = 1;
			}
			else {
				p->data->cmd2 = (char *) g_malloc(strlen(current_data->cmd2)+1);
				strcpy(p->data->cmd2, current_data->cmd2);
			}
		}
		else {
			p->data->cmd2 = NULL; 
			flags = 1;
		}
	}
	else {
		if (cmd3_str) {
			p->data->cmd2 = cmd3_str; 
			flags = 1;
		}
		else 
			p->data->cmd2 = NULL; 
	}
	if (current_data->arg2) {
		if (args3_str) {
			if (strcmp(current_data->arg2, args3_str) != 0) {
				p->data->arg2 = args3_str; 
				flags = 1;
			}
			else {
				p->data->arg2 = (char *) g_malloc(strlen(current_data->arg2)+1);
				strcpy(p->data->arg2, current_data->arg2);
			}
		}
		else {
			p->data->arg2 = NULL; 
			flags = 1;
		}
	}
	else {
		if (args3_str) {
			p->data->arg2 = args3_str; 
			flags = 1;
		}
		else
			p->data->arg2 = NULL; 
	}

	if (flags) {
		if (flags_default) {
			if (modified_default_menu) {
				if (modified_default_menu->name0)
					g_free(modified_default_menu->name0);
				if (modified_default_menu->cmd0)
					g_free(modified_default_menu->cmd0);
				if (modified_default_menu->arg0)
					g_free(modified_default_menu->arg0);
				if (modified_default_menu->name1)
					g_free(modified_default_menu->name1);
				if (modified_default_menu->cmd1)
					g_free(modified_default_menu->cmd1);
				if (modified_default_menu->arg1)
					g_free(modified_default_menu->arg1);
				if (modified_default_menu->name2)
					g_free(modified_default_menu->name2);
				if (modified_default_menu->cmd2)
					g_free(modified_default_menu->cmd2);
				if (modified_default_menu->arg2)
					g_free(modified_default_menu->arg2);
				
				g_free(modified_default_menu);
			}
			modified_default_menu = p->data;
			g_free(p);
		}
		else {
			p->origin = current_data;
			
			if (modified_menu) {
				modified_menu_p->next = p;
				modified_menu_p = modified_menu_p->next;
				modified_menu_p->next = NULL;
			}
			else {
				modified_menu = p; 
				modified_menu_p = modified_menu;
				modified_menu_p->next = NULL;
			}
		}
	}
	else {
		if (p->data->name0)
			g_free(p->data->name0);
		if (p->data->cmd0)
			g_free(p->data->cmd0);
		if (p->data->arg0)
			g_free(p->data->arg0);
		if (p->data->name1)
			g_free(p->data->name1);
		if (p->data->cmd1)
			g_free(p->data->cmd1);
		if (p->data->arg1)
			g_free(p->data->arg1);
		if (p->data->name2)
			g_free(p->data->name2);
		if (p->data->cmd2)
			g_free(p->data->cmd2);
		if (p->data->arg2)
			g_free(p->data->arg2);
	
		g_free(p->data);
		g_free(p);
	}
}

static void 
press_name_handler(GtkWidget *widget,GdkEventButton *event)
{
	GtkWidget  *event_widget;
	Suffix     *buf;
	
	/* get event */
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	buf = (Suffix *) gtk_object_get_user_data(GTK_OBJECT(event_widget));

        /* do emphasize */
	if (emphasized_suffixname) {
		if (emphasized_suffixname->window)
			gdk_window_clear(emphasized_suffixname->window);
		gtk_widget_draw_children(emphasized_suffixname);
	}
	emphasized_suffixname = widget;
	emphasize_suffixname(emphasized_suffixname);

	if (current_data) {
		updata_new();
		check_modified_menu_suffix();
		destroy_menu_preference(right_box_child);
		current_data = buf;
		right_box_child = init_menu_preference(buf);
	}
	else {
		current_data = buf;
		right_box_child = init_menu_preference(buf);
	}
}

static void
change_suffix(GtkWidget * widget, gpointer data)
{
	char *str;

	str = gtk_entry_get_text(GTK_ENTRY(widget));

	if (strlen(str)<1){
		suffix_name = NULL;
	}
	else {
		suffix_name = str;
	}
}


static void 
change_xpm(GtkWidget  *widget, GdkEventButton *event)
{
	GtkWidget   *event_widget;
	GdkPixmap   *pixmap_data;
	GdkBitmap   *mask;
	GtkStyle    *style;
	char        *pathname;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	suffix_image = (char *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));
	
	if (suffix_image) {
		pathname = (char *) g_malloc(strlen(Preferences->icon_path)+strlen(suffix_image)+2);
		strcpy(pathname,Preferences->icon_path);
		pathname = strcat(pathname, "/");
		pathname = strcat(pathname, suffix_image);
	
		/* set new pixmap */
		if (pixmap && GTK_WIDGET_VISIBLE(pixmap)){
			gtk_widget_hide(pixmap);
		}
		style = gtk_widget_get_style(widget->parent);
		pixmap_data = gdk_pixmap_colormap_create_from_xpm(NULL, cmap, &mask,
								 &style->bg[GTK_STATE_NORMAL],
								 pathname);
		if (pixmap_data) {
			if (pixmap) {
				gtk_pixmap_set (GTK_PIXMAP(pixmap), pixmap_data, mask);
			}
			else {
				pixmap = gtk_pixmap_new(pixmap_data, mask);
				gtk_box_pack_start(GTK_BOX(pixmap_box),pixmap, TRUE, FALSE, 0);
				gtk_widget_show(pixmap);
			}
		}
		gtk_widget_show(pixmap);
		 
		/* set text to the entry of image */
		gtk_entry_set_text(GTK_ENTRY(image_name), suffix_image);
		g_free(pathname);
	}
}

static void
restore_menu (void)
{
	char  *buf;

	if (menu_num == First) {
		buf = gtk_entry_get_text(GTK_ENTRY(entry_name));
		if (buf) {
			if (!name1_str) {
				if (strlen(buf)>1) { 
					name1_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(name1_str, buf);
				}
				else {
					name1_str = NULL;
				} 
			}
			else {
				g_free(name1_str);
				if (strlen(buf)>1) { 
					name1_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(name1_str, buf);
				}
				else {
					name1_str = NULL;
				}
			}
		}
		buf = gtk_entry_get_text(GTK_ENTRY(entry_cmd));
		if (buf) {
			if (!cmd1_str) {
				if (strlen(buf)>1) { 
					cmd1_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(cmd1_str, buf);
				}
				else {
					cmd1_str = NULL;
				}
			}
			else {
				g_free(cmd1_str);
				if (strlen(buf)>1) { 
					cmd1_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(cmd1_str, buf);
				}
				else {
					cmd1_str = NULL;
				}
			}
		}
		buf = gtk_entry_get_text(GTK_ENTRY(entry_args));
		if (buf) {
			if (!args1_str) {
				if (strlen(buf)>1) { 
					args1_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(args1_str, buf);
				}
				else {
					args1_str = NULL;
				}
			}
			else {
				g_free(args1_str);
				if (strlen(buf)>1) { 
					args1_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(args1_str, buf);
				}
				else {
					args1_str = NULL;
				}
			}
		}
	}
	else if (menu_num == Second) {
		buf = gtk_entry_get_text(GTK_ENTRY(entry_name));
		if (buf) {
			if (!name2_str) {
				if (strlen(buf)>1) { 
					name2_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(name2_str, buf);
				}
				else {
					name2_str = NULL;
				}
			}
			else {
				g_free(name2_str);
				if (strlen(buf)>1) { 
					name2_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(name2_str, buf);
				}
				else {
					name2_str = NULL;
				}
			}
		}
		buf = gtk_entry_get_text(GTK_ENTRY(entry_cmd));
		if (buf) {
			if (!cmd2_str) {
				if (strlen(buf)>1) { 
					cmd2_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(cmd2_str, buf);
				}
				else {
					cmd2_str = NULL;
				}
			}
			else {
				g_free(cmd2_str);
				if (strlen(buf)>1) { 
					cmd2_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(cmd2_str, buf);
				}
				else {
					cmd2_str = NULL;
				}
			}
		}
		buf = gtk_entry_get_text(GTK_ENTRY(entry_args));
		if (buf) {
			if (!args2_str) {
				if (strlen(buf)>1) { 
					args2_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(args2_str, buf);
				}
				else {
					args2_str = NULL;
				}
			}
			else {
				g_free(args2_str);
				if (strlen(buf)>1) { 
					args2_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(args2_str, buf);
				}
				else {
					args2_str = NULL;
				}
			}
		}
	}
	else if (menu_num == Third) {
		buf = gtk_entry_get_text(GTK_ENTRY(entry_name));
		if (buf) {
			if (!name3_str) {
				if (strlen(buf)>1) { 
					name3_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(name3_str, buf);
				}
				else {
					name3_str = NULL;
				}
			}
			else {
				g_free(name3_str);
				if (strlen(buf)>1) { 
					name3_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(name3_str, buf);
				}
				else {
					name3_str = NULL;
				}
			}
		}
		buf = gtk_entry_get_text(GTK_ENTRY(entry_cmd));
		if (buf) {
			if (!cmd3_str) {
				if (strlen(buf)>1) { 
					cmd3_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(cmd3_str, buf);
				}
				else {
					name3_str = NULL;
				}
			}
			else {
				g_free(cmd3_str);
				if (strlen(buf)>1) { 
					cmd3_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(cmd3_str, buf);
				}
				else {
					cmd3_str = NULL;
				}
			}
		}
		buf = gtk_entry_get_text(GTK_ENTRY(entry_args));
		if (buf) {
			if (!args3_str) {
				if (strlen(buf)>1) { 
					args3_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(args3_str, buf);
				}
				else {
					args3_str = NULL;
				}
			}
			else {
				g_free(args3_str);
				if (strlen(buf)>1) { 
					args3_str = (char *) g_malloc(strlen(buf)+1);
					strcpy(args3_str, buf);
				}
				else {
					args3_str = NULL;
				}
			}
		}
	}
}

static void
change_to_1 (void)
{
	restore_menu();

	/* set on entry */
	if (name1_str)
		gtk_entry_set_text(GTK_ENTRY(entry_name), name1_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_name), "");

	if (cmd1_str)
		gtk_entry_set_text(GTK_ENTRY(entry_cmd), cmd1_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_cmd), "");

	if (args1_str) 
		gtk_entry_set_text(GTK_ENTRY(entry_args), args1_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_args), "");

	menu_num = First;
}

static void
change_to_2 (void)
{
	restore_menu();

	/* set on entry */
	if (name2_str)
		gtk_entry_set_text(GTK_ENTRY(entry_name), name2_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_name), "");

	if (cmd2_str)
		gtk_entry_set_text(GTK_ENTRY(entry_cmd), cmd2_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_cmd), "");

	if (args3_str) 
		gtk_entry_set_text(GTK_ENTRY(entry_args), args3_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_args), "");

	menu_num = Second;
}

static void
change_to_3 (void)
{
	restore_menu();

	/* set on entry */
	if (name3_str)
		gtk_entry_set_text(GTK_ENTRY(entry_name), name3_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_name), "");

	if (cmd3_str)
		gtk_entry_set_text(GTK_ENTRY(entry_cmd), cmd3_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_cmd), "");

	if (args3_str) 
		gtk_entry_set_text(GTK_ENTRY(entry_args), args3_str);
	else 
		gtk_entry_set_text(GTK_ENTRY(entry_args), "");

	menu_num = Third;
}

static void 
destroy_menu_preference(GtkWidget *widget)
{

	/* Destroy Menu Preference */
	gtk_widget_destroy(widget);
}

static void
emphasize_suffixname(GtkWidget *widget)
{
	if (emphasized_suffixname == widget && GTK_WIDGET_VISIBLE(widget)&& widget->window) {
		/* rectangle (x, y, width, height) */
		gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
				   0, 0, widget->allocation.width, widget->allocation.height);
		gtk_widget_draw_children(widget);
	}
}





