/*
 *    $Id: pref_launcher.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "pages.h"
#include "app_preference.h"
#include "gui_preference.h"
#include "page_preference.h"
#include "pref_launcher.h"

#define PW_COMPONET_HEIGHT 340

static void init_buttons(GtkWidget *parent);
static void init_page_tree(GtkWidget *parent);
static void new_handler(GtkWidget * widget);
static void remove_handler(GtkWidget * widget);
static void press_arrow_handler(GtkWidget * widget, GdkEventButton *event);
static void press_pagename_handler(GtkWidget *widget,GdkEventButton *event);
static void press_appname_handler(GtkWidget *widget,GdkEventButton *event);
static void set_new_page();
static void clear_emphasized (void);
static void emphasize_pagename (GtkWidget *widget);
static void emphasize_appname (GtkWidget *widget);

extern Page *Pages;
extern SLL *image_files; 
extern GtkWidget *page_tmp_widget;
extern GtkWidget *ticon_tmp_widget;
extern NewTrayIcon *trayicon_tmp;
GdkColor removed_color = { 0, 0x7530, 0x7530, 0x7530 };
GdkColor new_color = { 0, 0x0000, 0x0000, 0xffff };

NewTrayIcon *new_trayicon;
NewTrayIcon *new_trayicon_p;
RemovedTrayIcon *removed_trayicon;
RemovedTrayIcon *removed_trayicon_p;
ModifiedTrayIcon *modified_trayicon;
ModifiedTrayIcon *modified_trayicon_p;
NewPage *new_page;
NewPage *new_page_p;
RemovedPage *removed_page;
RemovedPage *removed_page_p;
ModifiedPage *modified_page;
ModifiedPage *modified_page_p;
Page      *page_current;

static GtkWidget *right_box;
static GtkWidget *right_box_child;
static GtkWidget *left_box;
static TypeRight now;
static GtkWidget *emphasized_arrow;
static GtkWidget *emphasized_pagename;
static GtkWidget *emphasized_appname;

void
init_LauncherPref (GtkWidget *parent)
{
	GtkWidget  *main_box;
	GtkWidget  *window;

	/* main box */
	main_box = gtk_vbox_new(FALSE, 8);
	gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);

	/* window */
	window = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_usize(window, 130, PW_COMPONET_HEIGHT-30);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(window),GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(main_box), window, FALSE, FALSE, 0);
	gtk_widget_show(window);


	/* left box */
	left_box = gtk_vbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(left_box), 4);
	gtk_container_add(GTK_CONTAINER(window), left_box);
	gtk_widget_show(left_box);

	/* right box */
	right_box = gtk_vbox_new(FALSE, 0);
	gtk_widget_set_usize(right_box, 300, PW_COMPONET_HEIGHT);
	gtk_box_pack_start(GTK_BOX (parent), right_box,FALSE, FALSE, 0);
	gtk_widget_show(right_box);

	/* init page */
	init_page_tree(left_box);

	/* init button */
	init_buttons(main_box);
}

void 
free_LauncherPref (void)
{
	right_box_child = NULL;
	emphasized_arrow = NULL;
	emphasized_pagename = NULL;
	emphasized_appname = NULL;
}

static void 
init_buttons(GtkWidget *parent)
{
	GtkWidget  *hbox1;
	GtkWidget  *hbox2;
	GtkWidget  *button;
 
	/* box */
	hbox1 = gtk_hbox_new(TRUE, 4);
	gtk_box_pack_start(GTK_BOX (parent), hbox1, TRUE, TRUE, 0);
	gtk_widget_show(hbox1);

	/* box */
	hbox2 = gtk_hbox_new(TRUE, 4);
	gtk_box_pack_start(GTK_BOX (parent), hbox2, TRUE, TRUE, 0);
	gtk_widget_show(hbox2);
		
	/* button */
	button = gtk_button_new_with_label(" New page ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(new_handler), NULL);
	gtk_box_pack_start(GTK_BOX(hbox1), button, TRUE, TRUE, 0);
	gtk_widget_show(button);

	/* button */
	button = gtk_button_new_with_label(" Remove ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(remove_handler), NULL);
	gtk_box_pack_start(GTK_BOX(hbox1), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
}

static void 
init_page_tree(GtkWidget *parent)
{
	GtkWidget  *main_box;
	GtkWidget  *hbox;
	GtkWidget  *vbox;
	GtkWidget  *event_box;
	GtkWidget  *arrow;
	GtkWidget  *label_page;
	GtkWidget  *label_ticon;
	Page       *buf_page;
	Trayicon   *buf_ticon;

	buf_page = Pages;

	while (1) {
		if (!buf_page) {
			break;
		}

		/* main box */
		main_box = gtk_vbox_new(FALSE, 4);
		gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
		gtk_widget_show(main_box);

		/* hbox */
		hbox = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(main_box), hbox, FALSE, FALSE, 0);
		gtk_widget_show(hbox);

                /* arrow event widget */
		event_box = gtk_event_box_new ();
		gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
		gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
				   GTK_SIGNAL_FUNC(press_arrow_handler), NULL);
		gtk_signal_connect(GTK_OBJECT(event_box), "destroy",
				   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
		gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
				   GTK_SIGNAL_FUNC(emphasize_pagename), NULL);
		gtk_object_set_user_data(GTK_OBJECT(event_box), buf_page);
		gtk_box_pack_start(GTK_BOX(hbox), event_box, FALSE, FALSE, 0);
		gtk_widget_show (event_box);

                /* arrow */
		arrow = gtk_arrow_new(GTK_ARROW_RIGHT, GTK_SHADOW_IN);
		gtk_signal_connect(GTK_OBJECT(arrow), "destroy",
				   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
		gtk_container_add(GTK_CONTAINER(event_box), arrow);
		gtk_widget_show(arrow);

                /* label event widget */
		event_box = gtk_event_box_new ();
		gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
		gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
				   GTK_SIGNAL_FUNC(press_pagename_handler), NULL);
		gtk_signal_connect(GTK_OBJECT(event_box), "destroy",
				   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
		gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
				   GTK_SIGNAL_FUNC(emphasize_pagename), NULL);
		gtk_object_set_user_data(GTK_OBJECT(event_box), buf_page);
		gtk_box_pack_start(GTK_BOX(hbox), event_box, TRUE, TRUE, 0);
		gtk_widget_show(event_box);

		/* page name */
		label_page = gtk_label_new(buf_page->name);
		gtk_misc_set_alignment (GTK_MISC (label_page), 0.1, 0.5);
		gtk_container_add(GTK_CONTAINER(event_box), label_page);
		gtk_widget_show(label_page);
	     
		/* vbox */
		vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_end(GTK_BOX(main_box), vbox, FALSE, FALSE, 0);

		/* set */
		buf_page->gw_name_pref  = label_page;
		buf_page->gw_arrow = arrow;
		buf_page->state_arrow = right;
		buf_page->child = vbox;

		buf_ticon = buf_page->ticon;
		while (1) {
			if(!buf_ticon) {
				break;
			}
			
			/* label event widget */
			event_box = gtk_event_box_new ();
			gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
			gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
					   GTK_SIGNAL_FUNC(press_appname_handler), NULL);
			gtk_signal_connect(GTK_OBJECT(event_box), "destroy",
					   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
			gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
					   GTK_SIGNAL_FUNC(emphasize_appname), NULL);
			gtk_object_set_user_data(GTK_OBJECT(event_box), buf_ticon);
			gtk_box_pack_start(GTK_BOX(vbox), event_box, FALSE, FALSE, 0);
			gtk_widget_show (event_box);
				
			/* trayicon name */
			label_ticon = gtk_label_new(buf_ticon->name);
			gtk_misc_set_alignment (GTK_MISC (label_ticon), 0.2, 0.5);
			gtk_container_add(GTK_CONTAINER(event_box), label_ticon);
			gtk_widget_show(label_ticon);
			
			buf_ticon->gw_name_pref = label_ticon;
			
			/* next */
			buf_ticon = buf_ticon->next;
		}
		/* next */
		buf_page = buf_page->next;
	}
}

/*# have prob */
static void 
new_handler(GtkWidget * widget)
{
	if (right_box_child) {
		if (now == PAGE) {
			check_PagePreference();
			destroy_PagePreference(right_box_child);
		}
		else if (now == APP) {
			check_AppPreference();
			destroy_AppPreference(right_box_child);
		}
	}

	clear_emphasized();
	
	/*  new page */
	set_new_page();
}

static void 
remove_handler(GtkWidget * widget)
{
	/*
	if (right_box_child) {
		if (now == PAGE) {
			check_PagePreference();
			destroy_PagePreference(right_box_child);
		}
		else if (now == APP) {
			check_AppPreference();
			destroy_AppPreference(right_box_child);
		}
	}
	*/

	if (emphasized_appname) {
		remove_trayicon_handler();
	}
	else if (emphasized_pagename) {
		request_remove_page();
	}
}

static void 
press_arrow_handler(GtkWidget * widget, GdkEventButton *event)
{
	GtkWidget  *event_widget;
	Page         *buf;

	/* get event */
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	buf = (Page *) gtk_object_get_user_data(GTK_OBJECT(event_widget));

	if(buf->state_arrow == right){
		/* show children */
		gtk_widget_show(buf->child);
		
		/* hide */
		gtk_widget_hide(GTK_WIDGET(left_box));

		/* change arrow */
		gtk_arrow_set(GTK_ARROW(buf->gw_arrow),GTK_ARROW_DOWN, GTK_SHADOW_IN);
		
		/* show */
		gtk_widget_show(GTK_WIDGET(left_box));

		/* set state */
		buf->state_arrow = down;
	}
	else {
                /* hide children */
		gtk_widget_hide(buf->child);
		
		/* hide */
		gtk_widget_hide(GTK_WIDGET(left_box));

		/* change arrow */
		gtk_arrow_set(GTK_ARROW(buf->gw_arrow),GTK_ARROW_RIGHT, GTK_SHADOW_IN);
		
		/* show */
		gtk_widget_show(GTK_WIDGET(left_box));

		/* set state */
		buf->state_arrow = right;
	}
}

static void 
press_pagename_handler(GtkWidget *widget,GdkEventButton *event)
{
	GtkWidget  *event_widget;
	Page       *buf;
	
	/* get event */
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	buf = (Page *) gtk_object_get_user_data(GTK_OBJECT(event_widget));
	page_current = buf;

	/* do emphasize */
	clear_emphasized();
	emphasized_arrow = buf->gw_arrow->parent;
	emphasized_pagename = widget;
	emphasize_pagename(emphasized_arrow);
	emphasize_pagename(emphasized_pagename);

	if (right_box_child) {
		if (now == PAGE) {
			check_PagePreference();
			destroy_PagePreference(right_box_child);
		}
		else if (now == APP) {
			check_AppPreference();
			destroy_AppPreference(right_box_child);
		}
	}

	right_box_child = init_PagePreference(right_box, buf);
	now = PAGE;
}

static void 
press_appname_handler(GtkWidget * widget, GdkEventButton *event)
{
	GtkWidget  *event_widget;
	Trayicon   *buf;
	
	/* get event */
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	buf = (Trayicon *) gtk_object_get_user_data(GTK_OBJECT(event_widget));

	if (ticon_tmp_widget)
		if(widget == ticon_tmp_widget)
			return;

	/* do emphasize */
	clear_emphasized();
	emphasized_appname = widget;
	emphasize_appname(emphasized_appname);

	if (right_box_child) {
		if (now == PAGE) {
			check_PagePreference();
			destroy_PagePreference(right_box_child);
		}
		else if (now == APP) {
			check_AppPreference();
			destroy_AppPreference(right_box_child);
		}
	}
	right_box_child = init_AppPreference(right_box, buf);
	now = APP;
}

static void
set_new_page()
{
	Page       *new_page;
	GtkWidget  *main_box;
	GtkWidget  *event_box;
	GtkWidget  *label;
	GtkWidget  *hbox;
	GtkWidget  *vbox;
	GtkWidget  *arrow;
	GtkStyle   *style;

	/* style */
	style = gtk_style_new();
	style->fg[GTK_STATE_NORMAL] = new_color;

	/* allocate */
	new_page =  request_new_page();
	
	/* main box */
	main_box = gtk_vbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(left_box), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);
	
	/* hbox */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(main_box), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);
	
	/* arrow event widget */
	event_box = gtk_event_box_new ();
	gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(press_arrow_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
			   GTK_SIGNAL_FUNC(emphasize_pagename), NULL);
	gtk_object_set_user_data(GTK_OBJECT(event_box), new_page);
	gtk_box_pack_start(GTK_BOX(hbox), event_box, FALSE, FALSE, 0);
	gtk_widget_show (event_box);
	
	/* set */
	emphasized_arrow =  event_box;
	
	/* arrow */
	arrow = gtk_arrow_new(GTK_ARROW_RIGHT, GTK_SHADOW_IN);
	gtk_signal_connect(GTK_OBJECT(arrow), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_container_add(GTK_CONTAINER(event_box), arrow);
	gtk_widget_show(arrow);
	
	/* label event widget */
	event_box = gtk_event_box_new ();
	gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(press_pagename_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
			   GTK_SIGNAL_FUNC(emphasize_pagename), NULL);
	gtk_object_set_user_data(GTK_OBJECT(event_box), new_page);
	gtk_box_pack_start(GTK_BOX(hbox), event_box, TRUE, TRUE, 0);
	gtk_widget_show(event_box);
	
	/* page name */
	label = gtk_label_new("New");
	gtk_widget_set_style(label, style);
	gtk_misc_set_alignment (GTK_MISC (label), 0.1, 0.5);
	gtk_container_add(GTK_CONTAINER(event_box), label);
	gtk_widget_show(label);
	
	/* vbox */
	vbox = gtk_vbox_new(FALSE, 2);
	gtk_box_pack_end(GTK_BOX(main_box), vbox, FALSE, FALSE, 0);

	/* set */
	emphasized_pagename = event_box;
	page_current = new_page;
	page_tmp_widget = main_box;
	new_page->gw_arrow = arrow;
	new_page->gw_name_pref  = label;
	new_page->state_arrow = right;
	new_page->child = vbox;
	right_box_child = init_PagePreference(right_box, new_page);

	emphasize_pagename(emphasized_pagename);
	emphasize_pagename(emphasized_arrow);
	now = PAGE;
}

void
set_new_app(void)
{
	Trayicon   *new_ticon;
	GtkWidget  *event_box;
	GtkWidget  *label;
	GtkStyle   *style;

	style = gtk_style_new();
	style->fg[GTK_STATE_NORMAL] = new_color;

	/* show parent box */
	if(page_current->state_arrow == right){
		/* show children */
		gtk_widget_show(page_current->child);
		
		/* hide */
		gtk_widget_hide(GTK_WIDGET(left_box));

		/* change arrow */
		gtk_arrow_set(GTK_ARROW(page_current->gw_arrow),GTK_ARROW_DOWN, GTK_SHADOW_IN);
		
		/* show */
		gtk_widget_show(GTK_WIDGET(left_box));

		/* set state */
		page_current->state_arrow = down;
	}

        /* allocate */
	new_ticon = request_new_trayicon();

	/* label event widget */
	event_box = gtk_event_box_new ();
	gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(press_appname_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
			   GTK_SIGNAL_FUNC(emphasize_appname), NULL);
	gtk_object_set_user_data(GTK_OBJECT(event_box), new_ticon);
	gtk_box_pack_start(GTK_BOX(page_current->child), event_box, FALSE, FALSE, 0);
	gtk_widget_show (event_box);
	
	/* trayicon name */
	label = gtk_label_new("New");
	gtk_widget_set_style(label, style);
	gtk_misc_set_alignment (GTK_MISC (label), 0.2, 0.5);
	gtk_container_add(GTK_CONTAINER(event_box), label);
	gtk_widget_show(label);

	/* create */
	if (right_box_child) {
		check_PagePreference();
		destroy_PagePreference(right_box_child);
	}
	right_box_child = init_AppPreference(right_box, new_ticon);

	/* set */
	ticon_tmp_widget = event_box;
	new_ticon->page = page_current;
	new_ticon->gw_name_pref = label;

	/* emphasize */
	clear_emphasized();
	emphasized_arrow = NULL;
	emphasized_pagename = NULL;
	emphasized_appname = event_box;
	emphasize_appname(emphasized_appname);

	now = APP;
}

static void
clear_emphasized (void)
{
	if (emphasized_pagename) {
		/* remove old emphasize */
		if (emphasized_arrow->window)
			gdk_window_clear(emphasized_arrow->window);
		if (emphasized_pagename->window)
			gdk_window_clear(emphasized_pagename->window);
		gtk_widget_draw_children(emphasized_arrow);
		gtk_widget_draw_children(emphasized_pagename);
		emphasized_arrow = NULL;
		emphasized_pagename = NULL;
	}
	else if (emphasized_appname) {
		/* remove old emphasize */
		if (emphasized_appname->window)
			gdk_window_clear(emphasized_appname->window);
		gtk_widget_draw_children(emphasized_appname);
		emphasized_appname = NULL;
	}

}

static void
emphasize_pagename(GtkWidget *widget)
{
	if (emphasized_pagename == widget && GTK_WIDGET_VISIBLE(widget) && widget->window) {
		/* rectangle (x, y, width, height) */
		gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
				   0, 0, widget->allocation.width, widget->allocation.height);
		gtk_widget_draw_children(widget);
	}
	else if (emphasized_arrow == widget && GTK_WIDGET_VISIBLE(widget) && widget->window ) {
		/* rectangle (x, y, width, height) */
		gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
				   0, 0, widget->allocation.width, widget->allocation.height);
		gtk_widget_draw_children(widget);
	}
}

static void
emphasize_appname(GtkWidget *widget)
{
	if (emphasized_appname == widget && GTK_WIDGET_VISIBLE(widget)&& widget->window) {
		/* rectangle (x, y, width, height) */
		gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
				   0, 0, widget->allocation.width, widget->allocation.height);
		gtk_widget_draw_children(widget);
	}
}







