/*
 *    $Id: popup_menu.c,v 1.1.1.1 1998/04/21 02:21:27 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "if_workplace.h"
#include "suffix.h"
#include "popup_menu.h"

typedef struct SLList {
	GtkWidget      *widget;
	struct SLList  *next;
} SLList;


extern Suffix *suffix_data;
static GtkWidget *workplace_menu;
static SLList * menu_list; 

void
init_PopoupMenu(void)
{
	if (!workplace_menu) {
		workplace_menu = gtk_menu_new();
	}
	if (!GTK_WIDGET_VISIBLE (workplace_menu)){
                gtk_menu_popdown(GTK_MENU(workplace_menu));
        }

}

void
popup_menu_show(gint button, guint32 activate_time, Fileinfo *finfo)
{
	Suffix    *buf_suffix;
	SLList    *buf;
	SLList    *garbage;
	GtkWidget *item;

	if (menu_list) {
		buf = menu_list;
		while (1) {
			if (!buf) {
				break;
			}
			gtk_widget_destroy(buf->widget);
			garbage = buf;
			buf = buf->next;
			if (garbage) {
				g_free(garbage);
			}
		}
		menu_list = NULL;
	}

	menu_list =  (SLList *) g_malloc(sizeof(SLList));    
	menu_list->next = NULL;
	buf = menu_list;

	if (finfo->filetype == DIRECTORY) {
		buf_suffix = NULL;
	}
	else {
		buf_suffix = get_suffix_from_name (finfo->name);
	}

	if (buf_suffix) {
		if (buf_suffix->name0) {
			/* 1st */
			item = gtk_menu_item_new_with_label(buf_suffix->name0);
			gtk_signal_connect(GTK_OBJECT(item), "activate", 
					   (GtkSignalFunc) exec_callback0, buf_suffix);
			gtk_menu_append(GTK_MENU(workplace_menu), item);
			gtk_widget_show(item);
			buf->widget = item;

			buf->next=  (SLList *) g_malloc(sizeof(SLList));    
			buf = buf->next;
			buf->next = NULL;

			if (buf_suffix->name1) {
				/* 2nd */
				item = gtk_menu_item_new_with_label(buf_suffix->name1);
				gtk_signal_connect(GTK_OBJECT(item), "activate", 
						   (GtkSignalFunc) exec_callback1, buf_suffix);
				gtk_menu_append(GTK_MENU(workplace_menu), item);
				gtk_widget_show(item);
				buf->widget = item;
				
				buf->next=  (SLList *) g_malloc(sizeof(SLList));    
				buf = buf->next;
				buf->next = NULL;
				
				if (buf_suffix->name2) {
					/* 3rd */
					item = gtk_menu_item_new_with_label(buf_suffix->name2);
					gtk_signal_connect(GTK_OBJECT(item), "activate", 
							   (GtkSignalFunc) exec_callback2,
							   buf_suffix);
					gtk_menu_append(GTK_MENU(workplace_menu), item);
					gtk_widget_show(item);
					buf->widget = item;
					
					buf->next = (SLList *) g_malloc(sizeof(SLList));    
					buf = buf->next;
					buf->next = NULL;
				}
			}
		}
	}

	/* line */
	item = gtk_menu_item_new ();
	gtk_menu_append (GTK_MENU(workplace_menu), item);
	gtk_widget_show (item);

	buf->widget = item;

	/* run */
	if ((finfo->stat->st_mode & S_IXOTH ) && (finfo->filetype != DIRECTORY)) {
		buf->next=  (SLList *) g_malloc(sizeof(SLList));    
		buf = buf->next;
		buf->next = NULL;
	
		item = gtk_menu_item_new_with_label ("Run");
		gtk_signal_connect(GTK_OBJECT(item), "activate", (GtkSignalFunc)  run_callback,
				   NULL);
		gtk_menu_append (GTK_MENU(workplace_menu), item);
		gtk_widget_show (item);
		buf->widget = item;
	}

	/* attribute */
	buf->next=  (SLList *) g_malloc(sizeof(SLList));    
	buf = buf->next;
	buf->next = NULL;
	
	item = gtk_menu_item_new_with_label ("Attribute");
	gtk_signal_connect(GTK_OBJECT(item), "activate", (GtkSignalFunc) attr_callback, NULL);
	gtk_menu_append (GTK_MENU(workplace_menu), item);
   	gtk_widget_show (item);
	buf->widget = item;

	gtk_menu_popup(GTK_MENU(workplace_menu), NULL, NULL, NULL, NULL, button, activate_time);
}

void
remove_popup_menu_item(void)
{
	if (!GTK_WIDGET_VISIBLE (workplace_menu)){
                gtk_menu_popdown(GTK_MENU(workplace_menu));
        }
}






