/*
 *    $Id: pages.h,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */
#ifndef _PAGES_H
#define _PAGES_H

#include <gtk/gtk.h>
#include "preferences.h"

enum arrow_state {
        right,
        down
};

typedef struct  Trayicon {
	/* This var hold a pointer of Page which contain this trayicon. */ 
	struct Page  *page;

	/* This var hold a pointer of next trayicon. If there aren't a next trayicon,
	   this var will hold NULL. */
	struct Trayicon  *next;

	/* This vars hold a name of this trayicon and a label widget ID. */
	char        *name;
	GtkWidget   *gw_name;
	GtkWidget   *gw_name_pref;

        /* This vars hold a image of this trayicon and a pixmap widget ID. */
	char       *image;
	GtkWidget  *gw_image;

	/* this var hold  commands. */
	char  *cmd;

	/* This var hold an argument of the command */
	char  *args;

	/* suort dnd or not */
	Boolen  dnd;

	/* This var hold a widget ID of this trayicon */  
	GtkWidget  *button;
	
	/* This var hold a widget ID of this trayicon */  
	GtkWidget  *box;
} Trayicon;

typedef struct  Page {
	/* This var hold a pointer of previous page. If there aren't a previous page,
	   this var will hold NULL. */	
	struct Page *prev;

	/* This var hold a pointer of next page. If there aren't a next page,
	   this var will hold NULL. */	
	struct Page  *next;

	gint  num;

	/* This vars hold a name of this page and a label widget ID. */
	char       *name;
	GtkWidget  *gw_name;
	GtkWidget  *gw_name_pref;

	/* This var hold a pointer of current trayicon */
	Trayicon  *ticon_p;

        /* This var hold a pointer of the first trayicon */
	Trayicon  *ticon;
	
        /* This var hold a widget ID of this page, for destroy widget */  
	GtkWidget  *widget;

	/* This var hold a state of arrow on PagePreference */
	enum arrow_state  state_arrow;

	/* This var hold a widget ID of arrow on PagePreference */
	GtkWidget  *gw_arrow;

	/*  This var hold a widget ID of box for containning children */
	GtkWidget  *child;
} Page;

/* This var hold preferences of workplace */
//extern Preference *Preferences;

/* This var hold all pages */
extern Page *Pages;

/* This func initalize page */
Page *init_page(void);

/* This func change Page to Preference->note */
void restore_page(void);

/* This func allocate a new trayicon */
Trayicon *alloc_trayicon(Trayicon *tray_icon);

#endif /* _PAGES_H */


