/*
 *    $Id: pages.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>

#include "preferences.h"
#include "pages.h"

/* This var hold preferences of workplace */
extern Preference *Preferences;

Page *current_page;

/* This func initalize pages */
Page *
init_page (void)
{
	Note      *garbage_note;
	App       *garbage_app;
	App       *app;
	Trayicon  *top_ticon = NULL;
	Page      *page;
	Page      *first;
	Page      *buf;

	page = (Page *) g_malloc(sizeof(Page));
	page->prev   = NULL;
	page->next   = NULL;
	page->name   = NULL;
	
	/* set the first page */
	first = page;

	Preferences->note = Preferences->top_note;
	while (1){
		/* make Page */
		page->name = (char *) g_malloc(strlen(Preferences->note->name) +1);
		strcpy(page->name, Preferences->note->name);
		page->ticon_p = NULL;

		/* remove garbage from Preferences */ 
		g_free(Preferences->note->name);
		Preferences->note->name = NULL;

		app = Preferences->note->top_app;

		while (1) {
			if (!app) {
				page->ticon_p = top_ticon;
				top_ticon = NULL;
				break;
			}

			if (!page->ticon_p) {
				page->ticon_p = (Trayicon *) g_malloc(sizeof(Trayicon));
				page->ticon_p->next = NULL;
				page->ticon = page->ticon_p;
			}
			else {
				page->ticon_p->next = (Trayicon *) g_malloc(sizeof(Trayicon));
				page->ticon_p = page->ticon_p->next;
				page->ticon_p->next = NULL;
			}

			page->ticon_p->page = page;

			/* name */
			if (app->name) {
				page->ticon_p->name = (char *) g_malloc(strlen(app->name)+1);
				strcpy(page->ticon_p->name, app->name);
			}
			else {
				page->ticon_p->name = NULL;
			}

			/* command */
			if (app->cmd) {
				page->ticon_p->cmd = (char *) g_malloc(strlen(app->cmd)+1);
				strcpy(page->ticon_p->cmd, app->cmd);
			}
			else {
				page->ticon_p->cmd = NULL;
			}

			/* image */
			if (app->image) {
				page->ticon_p->image = (char *) g_malloc(strlen(app->image)+1);
				strcpy(page->ticon_p->image, app->image);
			}
			else {
				page->ticon_p->image = NULL;
			}

			/* args */
			if (app->args) {
				page->ticon_p->args = (char *) g_malloc(strlen(app->args)+1);
				strcpy(page->ticon_p->args, app->args);
			}
			else {
				page->ticon_p->args = NULL;
			}

			/* DND */
			page->ticon_p->dnd = app->dnd;

			/* set garbage */
			garbage_app = app;

			/* next */
			app = app->next;

			g_free(garbage_app);
		}
		if (Preferences->note->next){
			garbage_note = Preferences->note; 
			Preferences->note = Preferences->note->next;
			g_free(garbage_note);

			/* Page */
			buf = page;
			page->next = (Page *) g_malloc(sizeof(Page));
			page = page->next;
			page->prev   = buf;
			page->next   = NULL;
			page->name   = NULL;
		}
		else {
			break;
		}
	}
	Preferences->top_note = NULL;
	Preferences->note = NULL;
	free_applist();

	return first;
}

/* This func change Page to Preference->note */
void 
restore_page (void)
{
	Trayicon *tray_icon;

	while (1){
		if (!Pages) {
			break;
		}
		if (!Preferences->note){
			Preferences->note = (Note *) g_malloc(sizeof(Note));
			Preferences->top_note = Preferences->note;
		} else {
			Preferences->note->next = (Note *) g_malloc(sizeof(Note));
			Preferences->note = Preferences->note->next;
		}
		Preferences->note->next = NULL;
		Preferences->note->name = Pages->name;
		Preferences->note->app  = NULL;
		Preferences->note->top_app = NULL;
		
		/* set the first tray icon */
		tray_icon = Pages->ticon;
		while (1) {
			if (!tray_icon){
				break;
			}
			if (tray_icon->name && tray_icon->image && tray_icon->cmd){
				if (Preferences->note->top_app == NULL){
					Preferences->note->app = (App *) g_malloc(sizeof(App));
					Preferences->note->top_app = Preferences->note->app;
				}
				else {
					Preferences->note->app->next = (App *) g_malloc(sizeof(App));
					Preferences->note->app = Preferences->note->app->next;
				} 

				Preferences->note->app->next = NULL;
				Preferences->note->app->name  = tray_icon->name;
				Preferences->note->app->image = tray_icon->image;
				Preferences->note->app->cmd   = tray_icon->cmd;
				Preferences->note->app->args  = tray_icon->args;
				Preferences->note->app->dnd   = tray_icon->dnd;
			}
			tray_icon = tray_icon->next;
		}
		Pages = Pages->next;
	}
}

/* This func allocate a new trayicon */
Trayicon *
alloc_trayicon (Trayicon *tray_icon)
{
	Page      *page;
	Trayicon  *buf;

	/* set page which contain this tray_icon */
	page = current_page;

	/* new tray icon */
	if (!page->ticon_p) {
		/* This page conatin no tray icon */ 
		page->ticon_p = (Trayicon *) g_malloc(sizeof(Trayicon));
		page->ticon_p->next  = NULL;
		page->ticon_p->name  = NULL;
		page->ticon_p->image = NULL;
		page->ticon_p->cmd   = NULL;
		page->ticon_p->args  = NULL;
		page->ticon_p->dnd   = NO;
		buf = page->ticon_p;
	}
	else {
		buf = page->ticon_p;
		
		while(1){
			if (!buf->next) {
				buf->next = (Trayicon *) g_malloc(sizeof(Trayicon));
				buf = buf->next;
				buf->page  = current_page;
				buf->next  = NULL;
				buf->name  = NULL;
				buf->image = NULL;
				buf->cmd   = NULL;
				buf->args  = NULL;
				buf->dnd   = NO;
				break;
			}
			buf = buf->next;
		}
	}

	return buf;
}





