/*
 *    $Id: page_preference.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <ctype.h>
#include "d_message.h"
#include "pages.h"
#include "if_launcher.h"
#include "gui_preference.h"
#include "pref_launcher.h"
#include "page_preference.h"

static void undo_new_page (void);
static void do_new_page (void);
static void do_modify_page (void);
static void change_name (GtkWidget * widget, gpointer data);
static void real_modify_page (void);
static void real_new_page (void);
static void real_remove_page (void);
static char *clean_string (char *str);

extern GtkWidget *Launcher;
extern Page *Pages;
extern Page *page_current;
extern NewPage *new_page;
extern NewPage *new_page_p;
extern RemovedPage *removed_page;
extern RemovedPage *removed_page_p;
extern ModifiedPage *modified_page;
extern ModifiedPage *modified_page_p;
extern GdkColor removed_color;

/* This var holds the tmp of widget which is main widget of PageTree. */
GtkWidget *page_tmp_widget;

static GtkWidget *name_entry;
static char      *page_name;
static NewPage   *page_tmp;
static Boolen    flags_new = NO;
static Boolen    flags_modify = NO;

GtkWidget *
init_PagePreference(GtkWidget *parent, Page *page)
{
	GtkWidget    *main_box;
	GtkWidget    *name_label;
	GtkWidget    *button;
	ModifiedPage *buf;

	if (page) {
		if (modified_page) {
			buf = modified_page;
			while (1) {
				if (!buf) {
					page_name  = page->name;
					page_current = page;
					flags_modify = NO;
					break;
				}
				else {
					if (buf->origin == page) {
						page_name  = buf->page->name;
						page_current =  buf->page;
						flags_modify = YES;
						break;
					}
					buf = buf->next;
				}
			}
		}
		else {
			page_name  = page->name;
			page_current = page;
			flags_modify = NO;
		}
	}
	else {
		return NULL;
	}

	/* main box */
	main_box = gtk_vbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX (parent), main_box, TRUE, TRUE, 0);
	gtk_widget_show(main_box);
	
	/* label */
	name_label = gtk_label_new("Change name:");
	gtk_misc_set_alignment (GTK_MISC (name_label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX (main_box), name_label, FALSE, FALSE, 0);
	gtk_widget_show(name_label);

	/* name entry */
	name_entry = gtk_entry_new();
	if (page_name) {
		gtk_entry_set_text(GTK_ENTRY(name_entry), page_name);
	}
	gtk_signal_connect(GTK_OBJECT(name_entry), "changed",
			   GTK_SIGNAL_FUNC(change_name), NULL);
	gtk_box_pack_start(GTK_BOX (main_box), name_entry, TRUE, TRUE, 0);
	gtk_widget_show(name_entry);
	
	/* button */
	button = gtk_button_new_with_label(" Register applications ");
	gtk_box_pack_start(GTK_BOX (main_box), button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(set_new_app), NULL);
	gtk_widget_show(button);

	return main_box;
}

void 
destroy_PagePreference(GtkWidget *widget)
{
	/* Destroy PagePreference */
	gtk_widget_destroy(widget);
	page_name = NULL;
}


/* check whether modified or not */
void
check_PagePreference(void)
{
        /* remove the top and end of spaces */
	page_name = clean_string(page_name);

	/* new */
	if (flags_new == YES) {
		if (!page_name) {
			undo_new_page();
		}
		else {
			do_new_page();
		}
	}
	/* modify */
	else if (flags_modify == NO) {
		/* check */
		if (page_current) {
			if (page_name) {
				if (strcmp(page_name, page_current->name) == 0)
					;
				else 
					do_modify_page();
			}
			else {
				if (page_current->name == NULL)
					;
				else 
					;/*do_modify_page();*/
			}
		}
	}
	else if (flags_modify == YES) {
		/* check */
		if (page_name) {
			if (strcmp(page_name, page_current->name) == 0)
				;
			else 
				do_modify_page();
		}
		else {
		       if (page_current->name == NULL)
			       ;
		       else 
			       do_modify_page();
		}
	}
}

void
cancel_PagePreference (void)
{
	NewPage           *buf_n_page;
	NewPage           *garbage_n_page;
	RemovedPage       *buf_r_page;
	RemovedPage       *garbage_r_page;
	ModifiedPage      *buf_page;
	ModifiedPage      *garbage_page;

	if (new_page) {
		buf_n_page = new_page;
		while (1) {
			if (!buf_n_page) {
				break;
			}
			garbage_n_page = buf_n_page;
			if (garbage_n_page->page->name) {
				g_free(garbage_n_page->page->name);
				garbage_n_page->page->name = NULL;
			}
			buf_n_page = buf_n_page->next;
			g_free(garbage_n_page);
		}
	}

	if (removed_page) {
		buf_r_page = removed_page;
		while (1) {
			if (!buf_r_page) {
				break;
			}
			garbage_r_page = buf_r_page;
			buf_r_page = buf_r_page->next;
			g_free(garbage_r_page);
		}
	}

	if (modified_page) {
		buf_page = modified_page;
		while (1) {
			if (!buf_page) {
				break;
			}
			garbage_page = buf_page;
			if (garbage_page->page->name) {
				g_free(garbage_page->page->name);
				garbage_page->page->name = NULL;
			}
			buf_page = buf_page->next;

			g_free(garbage_page);
		}
	}
	
}

void
save_PagePreference (void)
{
	check_PagePreference();
	/* modify page */
	if (modified_page) {
		real_modify_page();
	}

	/* new pages */
	if (new_page) {
		real_new_page();
	}

	/* remove pages */
	if (removed_page) {
		real_remove_page();
	}
}

void
free_PagePreference (void)
{
	page_tmp_widget = NULL;
	name_entry = NULL;
	page_current = NULL;
	page_name = NULL;
	page_tmp = NULL;
	flags_new = NO;
	flags_modify = NO;
	new_page = NULL;
	removed_page = NULL;
	modified_page = NULL;
}

static void
real_modify_page (void)
{
	ModifiedPage      *buf_page;
	ModifiedPage      *garbage_page;

	buf_page = modified_page;
	while (1) {
		if (!buf_page) {
			break;
		}
		/* name */
		if (buf_page->origin->name) {
			if (buf_page->page->name) {
				if (strcmp(buf_page->origin->name, 
					   buf_page->page->name) != 0) {
					g_free(buf_page->origin->name);
					buf_page->origin->name = buf_page->page->name;
					gtk_label_set(GTK_LABEL(buf_page->origin->gw_name), 
						      buf_page->page->name);
					}
			}
			else {
				/*??*/
				g_free(buf_page->origin->name);
				buf_page->origin->name = NULL;
				gtk_label_set (GTK_LABEL(buf_page->origin->gw_name), "");
				}
		}
		else {
			if (buf_page->page->name) {
				buf_page->origin->name = buf_page->page->name;
				gtk_label_set(GTK_LABEL(buf_page->origin->gw_name), 
					      buf_page->page->name);
			}
			else {
				/*??*/
				g_free(buf_page->origin->name);
				buf_page->origin->name = NULL;
				gtk_label_set (GTK_LABEL(buf_page->origin->gw_name), "");
			}
		}
		/* next */
		garbage_page = buf_page;
		buf_page = buf_page->next;
		g_free(garbage_page);
	}
}

void
request_remove_page(void)
{
	RemovedPage *p;
	RemovedPage *buf;
	GtkStyle    *style;

	style = gtk_style_new();
	style->fg[GTK_STATE_NORMAL] = removed_color;

	if (flags_modify == NO) {
		if (removed_page) {
			buf = removed_page;
			while (1) {
				if (!buf) {
					p = (RemovedPage *) g_malloc(sizeof(RemovedPage));
					p->page = page_current;
					p->next = NULL;
					removed_page_p->next = p;
					removed_page_p = removed_page_p->next;
				
					gtk_widget_set_style(page_current->gw_name_pref, style);
					gtk_widget_draw_children(page_current->gw_name_pref);
					break;
				}
				else {
					if (buf->page == page_current)
						break;
					buf = buf->next;
				}
			}
		}
		else {
			p = (RemovedPage *) g_malloc(sizeof(RemovedPage));
			p->page = page_current;
			p->next = NULL;
			removed_page = p;
			removed_page_p  = removed_page; 

			gtk_widget_set_style(page_current->gw_name_pref, style);
			gtk_widget_draw_children(page_current->gw_name_pref);

		}
	}
	else if (flags_modify == YES) {
		if (removed_page) {
			buf = removed_page;
			while (1) {
				if (!buf) {
					p = (RemovedPage *) g_malloc(sizeof(RemovedPage));
					p->page = page_current;
					p->next = NULL;
					removed_page_p->next = p;
					removed_page_p = removed_page_p->next;

					gtk_widget_set_style(page_current->gw_name_pref, style);
					gtk_widget_draw_children(page_current->gw_name_pref);
					break;
				}
				else {
					if (buf->page == page_current)
						break;
					buf = buf->next;
				}
			}
		}
		else {
			p = (RemovedPage *) g_malloc(sizeof(RemovedPage));
			p->page = page_current;
			p->next = NULL;
			removed_page = p;
			removed_page_p  = removed_page; 

			gtk_widget_set_style(page_current->gw_name_pref, style);
			gtk_widget_draw_children(page_current->gw_name_pref);
		}
	}
}

Page *
request_new_page (void)
{
	/* new page */
	page_tmp = (NewPage *) g_malloc(sizeof(NewPage));
	page_tmp->next = NULL;
	page_tmp->into = NULL;

	page_tmp->page = (Page *) g_malloc(sizeof(Page));
	page_tmp->page->prev   = NULL;
	page_tmp->page->next   = NULL;
	page_tmp->page->name   = NULL;
	page_tmp->page->ticon  = NULL;
	page_tmp->page->ticon_p  = NULL;
	page_tmp->page->widget = NULL;

	flags_new = YES;

	return page_tmp->page;
}

static void
do_modify_page (void)
{
	ModifiedPage  *p;

	/* allocation */
	if (flags_modify == YES) {
		if (page_name) {
			if (page_current->name) {
				g_free(page_current->name);
			}
			page_current->name = (char *) g_malloc(strlen(page_name)+1);
			strcpy(page_current->name, page_name);
		} 
	}
	else {
		p = (ModifiedPage *) g_malloc(sizeof(ModifiedPage));
		p->next = NULL;
		p->origin = page_current;
		p->page = (Page *) g_malloc(sizeof(Page));

		/* set value */
		p->page->name = (char *) g_malloc(strlen(page_name)+1);
		strcpy(p->page->name, page_name);

		if (!modified_page) {
			modified_page = p;
			modified_page_p = modified_page;
		}
		else {
			modified_page_p->next = p;
		}
		/*page = NULL;*/
	}
	flags_new = NO;
	flags_modify = NO;
}

static void
undo_new_page (void)
{
	if (page_tmp) {
		gtk_widget_destroy(page_tmp_widget);
		if (page_tmp->page) {
			if (page_tmp->page->name) 
				g_free(page_tmp->page->name);
			g_free(page_tmp->page);
		}
		g_free(page_tmp);
		page_tmp =NULL;
	}
	flags_new = NO;
}

static void
do_new_page (void)
{
	if (!new_page) {
		new_page = page_tmp;
		new_page_p = new_page;
	}
	else {
		new_page_p->next = page_tmp;
		new_page_p = new_page_p->next;
	}

	new_page_p->page->name = (char *) g_malloc(strlen(page_name)+1);
	strcpy(new_page_p->page->name, page_name);
	gtk_label_set(GTK_LABEL(new_page_p->page->gw_name_pref), new_page_p->page->name);
	/* gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
	 *		   GTK_SIGNAL_FUNC(press_arrow_handler), NULL);
	 */
	page_tmp = NULL;
	flags_new = NO;
}

static void 
real_new_page(void)
{
	NewPage   *buf_new_page;
	Page      *buf_page;

	buf_new_page = new_page;
	while (1) {
		if (!buf_new_page) {
			break;
		}
		else {
			buf_page = Pages;
			if (buf_page) {
				while (1) {
					if (!buf_page->next) {
						buf_page->next = buf_new_page->page;
						add_page(buf_new_page->page);
						break;
					}
					buf_page = buf_page->next;
				}
			}
			else {
				Pages = buf_new_page->page;
				add_page(buf_new_page->page);
			}
			/* next */
			buf_new_page = buf_new_page->next;
		}
	}
}

static void 
real_remove_page (void)
{
	RemovedPage *buf_removed_page;
	RemovedPage *garbage_removed_page;
	Page        *buf_page;
	Page        *prev;
	Page        *next;
	Trayicon    *buf_ticon;
	Trayicon    *garbage;
	gint        i = 0;

	buf_removed_page = removed_page;
	buf_page = buf_removed_page->page;
	while (1) {
		if (!buf_page) {
			break;
		}
		else {	
			if (buf_page == Pages) {
				Pages = buf_page->next;
			}
			prev = buf_page->prev;
			next = buf_page->next;
			
			if (next){
				next->prev = prev;
				if (prev) {
					prev->next = next;
				}
			}
			else {
				if (prev) {
					prev->next = NULL;
				}
			}
			
			/* clear garbage */
			g_free(buf_page->name);
			
			buf_ticon = buf_page->ticon;
			while (1) {
				if (!buf_ticon){
					break;
				}
				garbage = buf_ticon;
				
				if (garbage->name){
					g_free(garbage->name);
				}
				if (garbage->image){
					g_free(garbage->image);
				}
				if (garbage->cmd){
					g_free(garbage->cmd);
				}
				if (garbage->args){
					g_free(garbage->args);
				}
				buf_ticon = buf_ticon->next;
				g_free(garbage);
			}
			gtk_notebook_remove_page(GTK_NOTEBOOK(Launcher), buf_page->num);
			g_free(buf_page);
		}
		garbage_removed_page = buf_removed_page;
		buf_removed_page = buf_removed_page->next;
		g_free(garbage_removed_page);

		if (!buf_removed_page) {
			break;
		}
		else {
			buf_page = buf_removed_page->page;
		}
	}

	buf_page = Pages;
	while (1) {
		if (!buf_page) {
			break;
		}
		else {
			buf_page->num = i++;
			buf_page = buf_page->next;
		}
	}
}



static void 
change_name(GtkWidget * widget, gpointer data)
{
	char *str;

	str = gtk_entry_get_text(GTK_ENTRY(widget));
	if (strlen(str)<1){
		page_name = NULL;
	}
	else {
		page_name = str;
	}
}

static char *
clean_string (char *str)
{
	int length;
	int counter;
	char *p;

	if (!str) {
		return NULL;
	}

	length = strlen(str);
	p = str;
	counter = 1;
	while (1){
		if (isspace((int) *p) == 0){
			break;
		}
		else {
			if (counter == length){
				init_dialog_message("We get invalid string.");
				return NULL;
			}
			counter++;
			p++;
		}
	}
	str = p;

	length = strlen(str);

	p = str + length -1;
	counter = 1;
	while (1){
		if (isspace((int) *p) == 0){
			break;
		}
		else {
			if (counter == length){
				init_dialog_message("We get invalid string.");
				return NULL;
			}
			counter++;
			p--;
		}
	}
	*(p+1) = '\0';

	return str;
}


