/*
 *    $Id: misc_preference.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include "preferences.h"
#include "pages.h"
#include "files.h"
#include "gui_preference.h"
#include "misc_preference.h"

#define LIST_WIDTH  100
#define LIST_HEIGHT 80

typedef struct  SCutList {
	struct SCutList  *next;
	char             *path;
	GtkWidget        *widget;
} SCutList;


static void init_shortcut (GtkWidget *parent);
static void change_ipath (GtkWidget * widget, gpointer data);
static void change_to_icon (void);
static void change_to_list (void);
static void change_scut_list (GtkWidget  *widget, GdkEventButton *event);
static void change_scut (GtkWidget * widget, gpointer data);

/* This var hold preferences of workplace */
extern Preference *Preferences;

static DisplayType  now_type;
static GtkWidget    *ipath_entry;
static GtkWidget    *scut_listbox;
static GtkWidget    *scut_entry;
static char         *ipath_str;
static SCutList     *shortcut;
static SCutList     *shortcut_p;
static char *shortcut_str;

void 
init_misc_gui (GtkWidget *parent)
{
	GtkWidget  *main_box;
	GtkWidget  *ipath_box;
	GtkWidget  *ipath_label;
	GtkWidget  *mode_box;
	GtkWidget  *mode_label;
	GtkWidget  *mode_menu;
	GtkWidget  *menu;
	GtkWidget  *menu_item;

	/* main box */
	main_box =  gtk_vbox_new(FALSE, 16);
	gtk_box_pack_start(GTK_BOX (parent), main_box, TRUE, TRUE, 0);
	gtk_widget_show(main_box);
	
	/* path */
	ipath_box =  gtk_vbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX (main_box), ipath_box, FALSE, FALSE, 0);
	gtk_widget_show(ipath_box);

	ipath_label = gtk_label_new("Icon path:");
	gtk_misc_set_alignment (GTK_MISC (ipath_label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX (ipath_box), ipath_label, FALSE, FALSE, 0);
	gtk_widget_show(ipath_label);

	ipath_entry = gtk_entry_new();
	gtk_signal_connect(GTK_OBJECT(ipath_entry), "changed",
			   GTK_SIGNAL_FUNC(change_ipath), NULL);
	gtk_box_pack_start(GTK_BOX (ipath_box), ipath_entry, TRUE, TRUE, 0);
	gtk_widget_show(ipath_entry);

	/* set path */
	ipath_str = Preferences->icon_path;
	gtk_entry_set_text(GTK_ENTRY(ipath_entry), ipath_str);

	/* mode */
	mode_box =  gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX (main_box), mode_box, FALSE, FALSE, 0);
	gtk_widget_show(mode_box);

	mode_label = gtk_label_new("display files by");
	gtk_misc_set_alignment (GTK_MISC (mode_label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX (mode_box), mode_label, FALSE, FALSE, 0);
	gtk_widget_show(mode_label);

	/* menu */
	menu = gtk_menu_new ();

	/* set a menu item of "Icon" */
	menu_item = gtk_menu_item_new_with_label(" Icon ");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", 
			   (GtkSignalFunc) change_to_icon, NULL);
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_widget_show(menu_item);

	/* set a menu item of "List" */
	menu_item = gtk_menu_item_new_with_label(" List ");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", 
			   (GtkSignalFunc) change_to_list, NULL);
	gtk_menu_append(GTK_MENU(menu), menu_item);
	gtk_widget_show(menu_item);


	/* oprion menu */
	mode_menu = gtk_option_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (mode_menu), menu);
	gtk_box_pack_start (GTK_BOX (mode_box), mode_menu, FALSE, FALSE, 0);
	gtk_widget_show (mode_menu);

	if (Preferences->d_type == ICON) {
		gtk_option_menu_set_history (GTK_OPTION_MENU (mode_menu), 0);
		now_type = ICON;
	}
	else {
		gtk_option_menu_set_history (GTK_OPTION_MENU (mode_menu), 1);
		now_type = LIST;
	}

	init_shortcut(main_box);
}

static void
init_shortcut (GtkWidget *parent)
{
	GtkWidget     *main_box;
	GtkWidget     *label;
	GtkWidget     *swin;
	GtkWidget     *list_item;
	Shortcut      *buf;
	SCutList      *tmp = NULL;

	/* shortcut path */
	main_box =  gtk_vbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX (parent), main_box, TRUE, TRUE, 0);
	gtk_widget_show(main_box);

	label = gtk_label_new("Shortcut path:");
	gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX (main_box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
	
        /* scroll window */
	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (swin), GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_ALWAYS);
	gtk_signal_connect (GTK_OBJECT (swin), "button_press_event",
			    (GtkSignalFunc) change_scut_list, NULL);
	gtk_box_pack_start (GTK_BOX (main_box), swin, TRUE, TRUE, 0);
	gtk_widget_show(swin);
		
	scut_listbox = gtk_list_new ();
	gtk_list_set_selection_mode(GTK_LIST (scut_listbox), GTK_SELECTION_BROWSE);
	gtk_container_add(GTK_CONTAINER (swin), scut_listbox);
	gtk_widget_show(scut_listbox);

        /* custom shortcut */
	if (Preferences->shortcut) {
		buf = Preferences->shortcut;
		while (1) {
			if (!buf){
				break;
			}
			else {
				if (!shortcut) {
					shortcut = (SCutList *) g_malloc(sizeof(SCutList));
					tmp = shortcut;
					tmp->next = NULL;
				}
				else {
					tmp->next = (SCutList *) g_malloc(sizeof(SCutList));
					tmp = tmp->next;
					tmp->next = NULL;
				}
				tmp->path = (char *) g_malloc(strlen(buf->path)+1);
				strcpy(tmp->path, buf->path);

				list_item = gtk_list_item_new();
				gtk_container_border_width(GTK_CONTAINER (list_item), 2);
				gtk_object_set_user_data (GTK_OBJECT (list_item), tmp);
				gtk_container_add(GTK_CONTAINER (scut_listbox), list_item);
				gtk_widget_show(list_item);

				tmp->widget = gtk_label_new(tmp->path); 
				gtk_misc_set_alignment (GTK_MISC(tmp->widget), 0.0, 0.5);
				gtk_container_add(GTK_CONTAINER(list_item), tmp->widget);
				gtk_widget_show(tmp->widget);
				
				/* next */
				buf = buf->next;
			}
		}
	}


	scut_entry = gtk_entry_new();
	gtk_signal_connect(GTK_OBJECT(scut_entry), "changed", GTK_SIGNAL_FUNC(change_scut),
			   NULL);
	gtk_box_pack_start(GTK_BOX (main_box), scut_entry, FALSE, FALSE, 0);
	gtk_widget_show(scut_entry);
}

void
cancel_misc_gui(void)
{
	SCutList  *tmp;
	SCutList  *garbage;


	tmp = shortcut;
	while (1) {
		if (!tmp) {
			break;
		}
		else {
			garbage = tmp;
			
			if (garbage->path) {
				g_free(garbage->path);
			}
			
			/* next */
			tmp = tmp->next;
			g_free(garbage);
		}

	}
}

void
save_misc_gui(void)
{
	Shortcut  *buf;
	SCutList  *tmp;
	SCutList  *garbage;

	g_free(Preferences->icon_path);
	Preferences->icon_path = (char *) g_malloc(strlen(ipath_str)+1);
	strcpy(Preferences->icon_path, ipath_str);

	Preferences->d_type = now_type;

	buf = Preferences->shortcut;
	tmp = shortcut;
	while (1) {
		if (!tmp) {
			break;
		}
		else {
			g_free(buf->path);
			buf->path = tmp->path;

			garbage = tmp;
			/* next */
			buf = buf->next;
			tmp = tmp->next;

			g_free(garbage);
		}
	}
}

void
free_misc_gui(void)
{
	ipath_entry = NULL;
	scut_listbox = NULL;
	scut_entry = NULL;
	ipath_str = NULL;
	shortcut = NULL;
	shortcut_p = NULL;
	shortcut_str = NULL;
}

static void
change_ipath (GtkWidget * widget, gpointer data)
{
	char *str;

	str = gtk_entry_get_text(GTK_ENTRY(widget));
	if (strlen(str)<1){
		ipath_str = NULL;
	}
	else {
		ipath_str = str;
	}
}

static void
change_to_icon (void)
{
	if (now_type == LIST)
		now_type = ICON;
}

static void
change_to_list (void)
{
	if (now_type == ICON)
		now_type = LIST;
}
		
static void
change_scut_list (GtkWidget  *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	SCutList  *buf;

	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	buf = (SCutList *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));

	if (!buf) {
		return;
	}

	if (shortcut_p) {
		if (buf != shortcut_p) {
			if (shortcut_str) {
				if (shortcut_p->path &&
				    strcmp(shortcut_p->path,shortcut_str) != 0) {
					g_free(shortcut_p->path);
					shortcut_p->path = (char *) g_malloc(strlen(shortcut_str+1));
					strcpy(shortcut_p->path,shortcut_str);
					gtk_label_set(GTK_LABEL(shortcut_p->widget),
						      shortcut_p->path);
				}
			}
			else {
				if (shortcut_p->path){
					g_free(shortcut_p->path);
					shortcut_p->path = NULL;
				}
				gtk_label_set(GTK_LABEL(shortcut_p->widget),"");
			}
		}
	}
	shortcut_p = buf;
		
	if (buf->path) {
		gtk_entry_set_text(GTK_ENTRY(scut_entry), buf->path);
	}
}

static void
change_scut (GtkWidget * widget, gpointer data)
{
	char      *str;

	str = gtk_entry_get_text(GTK_ENTRY(widget));

	if(!str) {
		return;
	}

	if (strlen(str)<1){
		shortcut_str = NULL;
	}
	else {
		shortcut_str= str;
	}
}












