/*
 *    $Id: misc.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <sys/stat.h>

extern char *Myname;

/* This func read a file */
char *
read_file(char *name)
{
        FILE *fp;
	struct stat *sb;
	char buf[1024];
	char *p;
	char *text;

	if (!name) {
		return NULL;
	}

	if ((fp = fopen(name, "r")) == NULL) {
		return NULL;
	}

	sb = (struct stat *) g_malloc(sizeof(struct stat));
	if (stat(name, sb) == -1) {
		fprintf(stderr, "stat err\n");
	}

	text = (char *) g_malloc(sb->st_size);
	if (text == NULL) {
		fprintf(stderr, "%s: read_file g_malloc err!\n", Myname);
		exit(1);
	}
	memset((char *) text, 0, sb->st_size);
	g_free (sb); 

	p = text;
	while (1) {
		if ((fgets(buf, 1024, fp)) == NULL) {
			break;
		}
		strcpy(p, buf);
		p += strlen(buf);
	}
	fclose(fp);

	return text;
}

