/*
 *    $Id: interface.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>

#include "main.h"
#include "preferences.h"
#include "commands.h"
#include "if_directory.h"
#include "if_workplace.h"
#include "if_launcher.h"
#include "d_message.h"
#include "toolbar.h"
#include "interface.h"

static void check_message (GtkWidget *widget, GdkEventExpose *event);
static void init_cursor (void);


/* main GtkWidget ID */
GtkWidget *Mainwindow;

/* cursor */
GdkCursor *NCursor;
GdkCursor *WCursor;
 
void 
init_gui(int argc, char *argv[])
{
	GtkWidget *main_box;
	GtkWidget *vpaned;
	GtkWidget *launcher_box;
	GtkWidget *dir_box;
	GtkWidget *workplace_box;
	GtkWidget *control_box;

	/* Initialize Gtk */
	gtk_init(&argc, &argv);

	/* Create the main window */
	Mainwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_wmclass(GTK_WINDOW(Mainwindow), "workplace", "Workplace");
	gtk_window_set_title(GTK_WINDOW(Mainwindow), "Workplace");
	gtk_window_set_policy(GTK_WINDOW(Mainwindow), TRUE, TRUE, FALSE);
	gtk_widget_set_name(Mainwindow, "main window");
	gtk_signal_connect(GTK_OBJECT(Mainwindow), "destroy",
			   GTK_SIGNAL_FUNC(gtk_exit), NULL);
	gtk_signal_connect(GTK_OBJECT(Mainwindow), "delete_event",
			   GTK_SIGNAL_FUNC(gtk_exit), NULL);
	gtk_signal_connect(GTK_OBJECT (Mainwindow), "expose_event",
			   (GtkSignalFunc) check_message, NULL);

	/* Create a container to hold everything */
	main_box = gtk_vbox_new(FALSE, 6);
	gtk_container_add(GTK_CONTAINER(Mainwindow), main_box);
	gtk_container_border_width(GTK_CONTAINER(main_box), 8);
	gtk_widget_show(main_box);

	/* launcher_box */
	launcher_box = gtk_vbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(main_box), launcher_box, FALSE, FALSE, 0);
	gtk_widget_show(launcher_box);

	/* init launcher */
	init_launcher(launcher_box);

	/* init toolbar */
	init_toolbar(main_box);

	/* pane */
	vpaned = gtk_vpaned_new ();
	gtk_box_pack_start(GTK_BOX(main_box),vpaned, TRUE, TRUE, 0);
	gtk_widget_show (vpaned);

	/* directory */
	dir_box = gtk_vbox_new(FALSE, 2);
	gtk_paned_add1 (GTK_PANED (vpaned), dir_box);
	gtk_widget_show(dir_box);

	/* Initalize a componet of directory */
	init_directory(dir_box);

	/* workplace */
	workplace_box = gtk_vbox_new(FALSE, 2);
	gtk_paned_add2 (GTK_PANED (vpaned), workplace_box);
	gtk_widget_show(workplace_box);

	/* Initalize workplace */
	init_workplace(workplace_box);

	/* Create the control window */
	control_box = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(main_box), control_box, FALSE, FALSE, 0);
	gtk_widget_show(control_box);

	/* init cursor */
	init_cursor();

	/* Display everything */
	if ((Preferences->width > 0 && Preferences->width < 1600) &&
	    (Preferences->height > 0 && Preferences->height < 1200)) {
		gtk_widget_set_usize(Mainwindow, Preferences->width, Preferences->height);
	}
	else {
		gtk_widget_set_usize(Mainwindow, 600, 480);
	}
	gtk_widget_show(Mainwindow);
}

static
void  check_message (GtkWidget *widget, GdkEventExpose *event)
{
        /* init Message */
	init_dialog_message(NULL);
}

/* init cursor */
static
void init_cursor (void)
{
	/* init cursor */
	NCursor = gdk_cursor_new(GDK_LEFT_PTR);
	WCursor = gdk_cursor_new(GDK_WATCH);
}




