/*
 *    $Id: if_workplace.c,v 1.1.1.1 1998/04/21 02:21:27 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include "files.h"
#include "file_preference.h"
#include "file_attr.h"
#include "d_message.h"
#include "dnd.h"
#include "toolbar.h"
#include "suffix.h"
#include "if_directory.h"
#include "pages.h"
#include "popup_menu.h"
#include "commands.h"
#include "if_workplace.h"

#include "mFile.xpm"
#define LIST_NORMAL_XPM mFile_xpm
#include "mFolder.xpm" 
#define LIST_DIRECTORY_XPM mFolder_xpm


#define LIST_NAME_WIDTH  284
#define LIST_NAME_HEIGHT 28
#define ICON_WIDTH  136
#define ICON_HEIGHT  76
#define IMAGE_WIDTH  70
#define IMAGE_HEIGHT 60

#define SIZE 170

/* static function */
static void show_copylight (GtkWidget *parent);
static void display_files_by_icon (void);
static void display_files_by_list (void);
static void create_file_icon (FileList *);
static void create_file_list (FileList *file);
static void emphasize_icon_image(GtkWidget *widget);
static void emphasize_icon_label(GtkWidget *widget);
static void press_icon_handler(GtkWidget *widget, GdkEventButton *event);
static void press_list_handler(GtkWidget *widget, gint row, gint column, GdkEventButton *event);
static void press_column_handler(GtkWidget *widget, gint column);
static void by_name_handler (void);
static void by_size_handler (void);
static void by_time_handler (void);


/* main GtkWidget ID */
extern GtkWidget *Mainwindow;

/* main preferences */
extern Preference *Preferences;

/* cursor */
extern GdkCursor *NCursor;
extern GdkCursor *WCursor;
 
/* This var hold a type of displaying*/
DisplayType Display_type;

/* List titles */
static char *list_titles[] = { "", "Name", "Size", "Last Changed" };

/* These var hold the widget id of emphasized file */
static GtkWidget  *emphasized_icon_image;
static GtkWidget  *emphasized_icon_label;

/* This var hold a current file */
FileList *current_file;
Fileinfo *file_info;

/* This var hold a _full_ current pathname */
char *current_path = NULL;

/* This var hold all files of info */
FileList *Files = NULL;

/* workplace pointer */
GtkWidget *workplace;


static GtkWidget *notice;

/* This var hold pixmap data   */
static GdkBitmap *n_list_mask = NULL;
static GdkBitmap *d_list_mask = NULL;
static GdkPixmap *n_list_xpm  = NULL;
static GdkPixmap *d_list_xpm  = NULL;

void 
init_workplace(GtkWidget *parent)
{
	GtkWidget   *space;
	GtkStyle    *style;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();

        /* set style */
	style = gtk_style_new();

	/* init pixmap data */
	n_list_xpm = gdk_pixmap_colormap_create_from_xpm_d(NULL,cmap,&n_list_mask,
							   &style->bg[GTK_STATE_NORMAL],
							   LIST_NORMAL_XPM);
	
	d_list_xpm = gdk_pixmap_colormap_create_from_xpm_d(NULL,cmap,&d_list_mask, 
							   &style->bg[GTK_STATE_NORMAL],
							   LIST_DIRECTORY_XPM);

	/* space */
	space = gtk_vbox_new(FALSE, 2);
	gtk_container_border_width(GTK_CONTAINER (space), 2);
	gtk_box_pack_start(GTK_BOX(parent), space, FALSE, FALSE, 0);
	gtk_widget_show(space);

	/* set default type */
	Display_type = Preferences->d_type;

	/* show copylight */
	show_copylight(parent);
}

/* This func display files on workplace by current "DisplayType". */
void 
display_files (char *pathname, enum sorttype stype)
{
	static GtkWidget *parent;
	GtkWidget        *window;

	/* set cursor */
	gdk_window_set_cursor(Mainwindow->window, WCursor);

	/* remove widget from Workplace */
	if (notice) {
		parent = notice->parent;
		gtk_widget_destroy(notice);
		notice = NULL;
	}
	if (!workplace) {
		if (Display_type == ICON) {
			/* window */
			window = gtk_scrolled_window_new(NULL, NULL);
			gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (window), 
						       GTK_POLICY_AUTOMATIC,
						       GTK_POLICY_AUTOMATIC);
			gtk_container_add(GTK_CONTAINER (parent), window);
			gtk_widget_show(window);

			/* This widget contains everything */
			workplace = gtk_fixed_new ();
			gtk_container_add (GTK_CONTAINER (window), workplace);
			gtk_widget_show(workplace);

			/* init popup menu */
			init_PopoupMenu();
#ifdef DND
			/* DND */
			set_drop_workplace(workplace);
#endif
		}
		else if (Display_type == LIST) {

			workplace = gtk_clist_new_with_titles(4, list_titles);
			gtk_clist_set_selection_mode(GTK_CLIST(workplace), GTK_SELECTION_BROWSE);
			gtk_clist_set_policy(GTK_CLIST(workplace), GTK_POLICY_AUTOMATIC,
					     GTK_POLICY_AUTOMATIC);
			gtk_container_border_width (GTK_CONTAINER (workplace), 5);
			gtk_signal_connect(GTK_OBJECT(workplace),"click_column",
					   GTK_SIGNAL_FUNC(press_column_handler), NULL);
			gtk_signal_connect(GTK_OBJECT(workplace),"select_row",
					   GTK_SIGNAL_FUNC(press_list_handler), NULL);
			gtk_container_add(GTK_CONTAINER (parent), workplace);
			gtk_widget_show (workplace);

			/* set column */
			gtk_clist_column_titles_active(GTK_CLIST(workplace)); 

			gtk_clist_set_column_width(GTK_CLIST(workplace), 0, 20);
			gtk_clist_set_column_width(GTK_CLIST(workplace), 1, 300);
			gtk_clist_set_column_width(GTK_CLIST(workplace), 2, 100);
			gtk_clist_set_column_width(GTK_CLIST(workplace), 3, 150);
			

                        /* set row */
			gtk_clist_set_row_height(GTK_CLIST(workplace), 22);

                        /* init popup menu */
			init_PopoupMenu();
		}
	}

	/* remove old contents */
	if (current_path) {
		if (strcasecmp(current_path, pathname) == 0) {
			if  (Display_type == ICON) {
				/* only clear emphasize */
				if (emphasized_icon_image) {
					/* remove old emphasize */
					if (emphasized_icon_image->window)
						gdk_window_clear(emphasized_icon_image->window);
					gtk_widget_draw_children(emphasized_icon_image);
					emphasized_icon_image = NULL;
				}	
				if (emphasized_icon_label) {
					/* remove old emphasize */
					if (emphasized_icon_label->window)
						gdk_window_clear(emphasized_icon_label->window);
					gtk_widget_draw_children(emphasized_icon_label);
					emphasized_icon_label = NULL;
				}
				current_file = NULL;
			}
		}
		else {
			/* set new pathname */
			g_free(current_path);
			current_path = (char *) g_malloc(strlen(pathname)+1);
			strcpy(current_path, pathname);
			
			/* clear files */
			clear_files(Files);
			gtk_container_foreach (GTK_CONTAINER (workplace), 
					       (GtkCallback)gtk_widget_destroy, NULL);
			if (Display_type == ICON) {
				/* set null */
				emphasized_icon_image = NULL;
				emphasized_icon_label = NULL;
				current_file = NULL;
			}
			else if (Display_type == LIST) {
				gtk_clist_clear(GTK_CLIST(workplace));
			}
		}
		/* flush */
		gdk_flush();
	}
	else {
		current_path = (char *) g_malloc(strlen(pathname)+1);
		strcpy(current_path, pathname);
	}

	/* current directory info */
	Files = init_files(pathname, stype);
	if (!Files) {
		/*
		message = gtk_label_new("No Files!");
		gtk_fixed_put(GTK_FIXED(workplace), message, 10, 10);
		gtk_widget_show(message);
		*/

		/* set null */
		emphasized_icon_image = NULL;
		emphasized_icon_label = NULL;
		current_file = NULL;
	}
	else {
		/* display files */
		if  (Display_type == ICON) {
			display_files_by_icon();
		}
		else if (Display_type == LIST) { 
			display_files_by_list();
		}
	}

	/* set cursor */
	gdk_window_set_cursor(Mainwindow->window, NCursor);
}

void
exec_callback0 (GtkWidget *widget, Suffix  *buf)
{
	char  *pathname;

	pathname = (char *) g_malloc(strlen(current_path)+strlen(file_info->name)+1);
	strcpy(pathname, current_path);
	strcat(pathname, file_info->name);

	wp_exec(buf->cmd0, buf->arg0, pathname, YES);
	g_free(pathname);
	file_info = NULL;
}

void
exec_callback1 (GtkWidget *widget, Suffix  *buf)
{
	char  *pathname;

	pathname = (char *) g_malloc(strlen(current_path)+strlen(file_info->name)+1);
	strcpy(pathname, current_path);
	strcat(pathname, file_info->name);

	wp_exec(buf->cmd1, buf->arg1, pathname, YES);
	g_free(pathname);
	file_info = NULL;
}

void
exec_callback2 (GtkWidget *widget, Suffix  *buf)
{
	char  *pathname;

	pathname = (char *) g_malloc(strlen(current_path)+strlen(file_info->name)+1);
	strcpy(pathname, current_path);
	strcat(pathname, file_info->name);

	wp_exec(buf->cmd2, buf->arg2, pathname, YES);
	g_free(pathname);
	file_info = NULL;
}

void 
run_callback(void)
{
	char  *pathname;

	pathname = (char *) g_malloc(strlen(current_path)+strlen(file_info->name)+1);
	strcpy(pathname, current_path);
	strcat(pathname, file_info->name);

	wp_exec(pathname, NULL, NULL, NO);
	g_free(pathname);
	file_info = NULL;
}

void 
attr_callback(void)
{
	init_FilePreference(current_path, file_info);
	file_info = NULL;
}

static void 
show_copylight(GtkWidget *parent)
{
	notice = gtk_label_new("Copyright (C) 1997, 1998  Hideki Fujimoto");
	gtk_box_pack_start(GTK_BOX(parent), notice, TRUE, TRUE, 0);
	gtk_widget_show(notice);
}

static void 
display_files_by_icon (void)
{
	FileList *buf;
	int       main_width;
	int       width;
	int       max_num;
	int       margin;
	int       x;
	int       y;
	int       xp;

	/* set Files */
	buf = Files;
	while (1){
		if (!buf){
			break;
		}
		create_file_icon(buf);
		buf = buf->next;
	}

	/* This is an easy hack */
	main_width = Mainwindow->allocation.width-30;
	width = ICON_WIDTH + 2;
	max_num = main_width / width;
	margin  = (main_width % width) / 2;

	/* put files */
	x = 0;
	y = 0;
	buf = Files;
	while (1){
		if (!buf) {
			break;
		}
		if (x >= max_num) {
			y++;
			x = 0;
		}
		xp =  x*width + margin;
	
		if (buf->icon) {
			buf->x = xp;
			buf->y = y*80;
			gtk_fixed_put(GTK_FIXED(workplace), buf->icon, buf->x, buf->y);
			x++;
			//gtk_widget_show(buf->icon);
#ifdef DND	
			/* DND */
			set_drag(buf->image);
#endif
		}
		buf = buf->next;
	}
}

static void 
display_files_by_list(void)
{
	FileList  *buf;

	/* set Files */
	buf = Files;
	while (1){
		if (!buf){
			break;
		}
		create_file_list(buf);
		buf = buf->next;
	}

	gtk_clist_freeze(GTK_CLIST(workplace));
	buf = Files;
	while (1){
		if (!buf){
			break;
		}
		if (buf->info->filetype == DIRECTORY || buf->info->filetype == NORMAL){
				buf->row = (int) gtk_clist_append(GTK_CLIST(workplace), NULL);
				if (buf->info->filetype == DIRECTORY) {
					gtk_clist_set_pixmap(GTK_CLIST(workplace), buf->row, 0,
							     d_list_xpm, d_list_mask);   
				}
				else {
					gtk_clist_set_pixmap(GTK_CLIST(workplace), buf->row, 0,
							     n_list_xpm, n_list_mask);  
				}
				gtk_clist_set_text(GTK_CLIST(workplace), buf->row, 1,
						   buf->info->name);
				gtk_clist_set_text(GTK_CLIST(workplace), buf->row, 2, buf->size);
				gtk_clist_set_text(GTK_CLIST(workplace), buf->row, 3, buf->time);
				gtk_clist_set_row_data(GTK_CLIST(workplace), buf->row, buf);

#ifdef DND
				/* DND */
				/* set_drag(buf->list); */
#endif
		}
		buf = buf->next;
	}
	gtk_clist_thaw(GTK_CLIST(workplace));
}

static void 
create_file_icon(FileList *file)
{
	GtkWidget  *main_box;
	GtkWidget  *box;
	GtkWidget  *hbox;
	GtkWidget  *event_box;
	GtkWidget  *event_box2;
	GtkWidget  *pixmap;
	GtkWidget  *label;

	/* main_box *
	main_box = gtk_event_box_new();
	gtk_widget_set_usize(main_box, ICON_WIDTH, ICON_HEIGHT);
	gtk_widget_set_events (main_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(main_box), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(main_box), "button_press_event",
			   GTK_SIGNAL_FUNC(press_icon_handler), NULL);
	gtk_object_set_user_data(GTK_OBJECT(main_box), file);
	gtk_widget_show (main_box);
	*/

	/* box */
	box = gtk_vbox_new(FALSE, 0);
	gtk_widget_set_usize(box, ICON_WIDTH, ICON_HEIGHT);
	//gtk_container_add (GTK_CONTAINER(main_box), box);
	gtk_widget_show(box);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), hbox, TRUE, FALSE, 0);
	gtk_widget_show(hbox);

	/* event box for pixmap */
	event_box = gtk_event_box_new();
	gtk_widget_set_usize(event_box, IMAGE_WIDTH, IMAGE_HEIGHT);
	gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
	//gtk_signal_connect(GTK_OBJECT(event_box), "destroy",
	//		   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(press_icon_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
			   GTK_SIGNAL_FUNC(emphasize_icon_image), NULL);
	gtk_object_set_user_data(GTK_OBJECT(event_box), file);
	gtk_box_pack_start(GTK_BOX(hbox), event_box, TRUE, FALSE, 0);
	gtk_widget_show (event_box);

	
	/* pixmap */
	if (file->info->filetype == DIRECTORY) {
		pixmap = get_pixmap_from_name(file->info->name, DIRECTORY);
	}
	else if (file->info->filetype == NORMAL) {
		pixmap = get_pixmap_from_name(file->info->name, NORMAL);
	}
	else {
		pixmap = get_pixmap_from_name(file->info->name, NORMAL);
	}
	//gtk_box_pack_start(GTK_BOX(box), pixmap, TRUE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);
	
	/* event box for label */
	event_box2 = gtk_event_box_new();
	gtk_signal_connect(GTK_OBJECT(event_box2), "expose_event",
			   GTK_SIGNAL_FUNC(emphasize_icon_label), NULL);
	//gtk_signal_connect(GTK_OBJECT(event_box2), "button_press_event",
	//		   GTK_SIGNAL_FUNC(press_icon_handler), NULL);
	//gtk_object_set_user_data(GTK_OBJECT(event_box2), file);
	gtk_box_pack_start(GTK_BOX(box), event_box2, FALSE, TRUE, 0);
	gtk_widget_show (event_box2);


	/* label */
	if (file->info->name_abbr){
		label = gtk_label_new(file->info->name_abbr);
	}
	else {
		label = gtk_label_new(file->info->name);
	}
	gtk_signal_connect(GTK_OBJECT(label), "expose_event",
			   GTK_SIGNAL_FUNC(emphasize_icon_label), NULL);
	gtk_container_add (GTK_CONTAINER(event_box2), label);
	gtk_widget_show(label);

	file->icon = box;
	file->image = event_box;
	file->label = event_box2;
	file->size = NULL;
	file->time = NULL;
}

/* This func create a list of file */
static void 
create_file_list(FileList *file)
{
	time_t     now;
	time_t     timet;
	struct tm  *tm;
	struct tm  *tm_now;
	char       *size;
	char       *the_day;
	char       buf[256];
	char       *year, *month, *mday, *dtime;
	int        now_day;


	/* size */
	size = parse_size(file->info->stat);

	/* Day */
	year  = parse_year(file->info->stat, 1);
	month = parse_month(file->info->stat, 1);
	mday  = parse_mday(file->info->stat);
	dtime  = parse_time(file->info->stat);
	
	if (!year) {
		/* get now */
		now = time(NULL);
		tm_now = localtime(&now);
		now_day = tm_now->tm_yday;

		/* file */
		timet = file->info->stat->st_ctime;
		tm = localtime(&timet);

		/* today ? or yesterday ? or not */
		if (tm->tm_yday == now_day){
			sprintf(buf, "Today      %s", dtime);
		}
		else if (tm->tm_yday == (now_day -1)){
			sprintf(buf, "Yesterday %s", dtime);
		}
		else {
			sprintf(buf, "%s  %s   %s", month, mday, dtime);
		}
	}
	else {
		sprintf(buf, "%s %s   %s", month, mday, year);
	}
	the_day = (char *) g_malloc(strlen(buf)+1);
	strcpy(the_day,buf); 

	file->icon = NULL;
	file->image = NULL;
	file->label = NULL;
	file->size = size;
	file->time = the_day;
}

/* This func emphasize an icon of image which is selected. */
static void
emphasize_icon_image (GtkWidget *widget)
{
	if (!widget) return;

	if (emphasized_icon_image == widget && widget->window) {
		/* rectangle (x, y, width, height) 0, 2, 70, 60 */
		gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
				   8, 2, IMAGE_WIDTH -16, IMAGE_HEIGHT);
		gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
				   0, 10, IMAGE_WIDTH, IMAGE_HEIGHT -16);
		
		gdk_draw_arc((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
			     IMAGE_WIDTH -16, 2, 16, 16, 0, 90*64);
		gdk_draw_arc((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
			     0, 2, 16, 16, 90*64,180*64);
		gdk_draw_arc((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
			     0, IMAGE_HEIGHT -16, 16, 16, 180*64, 270*64);
		gdk_draw_arc((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
			     IMAGE_WIDTH -16, IMAGE_HEIGHT -16, 16, 16, 270*64,360*64);
	
		gtk_widget_draw_children(widget);
	}
}

/* This func emphasize an icon of label which is selected. */
static void
emphasize_icon_label(GtkWidget *widget)
{
	if (!widget) return;

	if (emphasized_icon_label == widget && widget->window) {
		/* rectangle (x, y, width, height) */
		gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
				   0, 0, widget->allocation.width, widget->allocation.height);
		gtk_widget_draw_children(widget);
	}
}

/* This func get an event of icon clicked */
static void  
press_icon_handler(GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget  *event_widget;
	FileList   *fl;
	char       *pathname;

	/* get event */
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	fl = (FileList *) gtk_object_get_user_data(GTK_OBJECT(widget));
       
	current_file = fl;

	if (emphasized_icon_image) {
		/* remove old emphasize */
		if (emphasized_icon_image->window)
			gdk_window_clear(emphasized_icon_image->window);
		gtk_widget_draw_children(emphasized_icon_image);
	}
	if (emphasized_icon_label) {
		/* remove old emphasize */
		if (emphasized_icon_label->window)
			gdk_window_clear(emphasized_icon_label->window);
		gtk_widget_draw_children(emphasized_icon_label);
	}
	
	/* do emphasize */
	emphasized_icon_image = fl->image;
	emphasized_icon_label = fl->label;

	emphasize_icon_image(emphasized_icon_image);
	emphasize_icon_label(emphasized_icon_label);

	/* set file info */
	file_info = fl->info;

	switch (event->button){
	case 1:
		if (fl->info->filetype == DIRECTORY) {
			pathname = (char *) g_malloc(strlen(current_path)+strlen(fl->info->name)+2);
			strcpy(pathname, current_path);
			strcat(pathname, fl->info->name);
			strcat(pathname, "/");

                        /* add path to index window */
			select_dirname(fl->info->name);

			/* display files on workplace */
			display_files(pathname, BY_NAME);
		}
		break;
	
	case 2:
		/* init_FilePreference(current_path, fl->info); */
		break;
	
	case 3:
		popup_menu_show(event->button, event->time, fl->info);
		break;

	default:
		init_dialog_message("We get a invalid event in open_file_handler");
	
	}
}

static void  
press_list_handler (GtkWidget *widget, gint row, gint column, GdkEventButton *event)
{
	FileList   *fl;
	char       *pathname;

	/* get event *
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	fl = (FileList *) gtk_object_get_user_data(GTK_OBJECT(event_widget));
        */
	if (!event) {
		return;
	}
	fl = (FileList *) gtk_clist_get_row_data (GTK_CLIST(workplace), row);

	current_file = fl;

	/* set file info */
	file_info = fl->info;

	switch (event->button){
	case 1:
		if (fl->info->filetype == DIRECTORY) {
			pathname = (char *) g_malloc(strlen(current_path)+strlen(fl->info->name)+2);
			strcpy(pathname, current_path);
			strcat(pathname, fl->info->name);
			strcat(pathname, "/");

			/* add path to index window */
			select_dirname(fl->info->name);

			/* display files on workplace */
			display_files(pathname, BY_NAME);
		}
		break;
	
	case 2:
		/* init_FilePreference(current_path, fl->info);*/
		break;
	
	case 3:
		popup_menu_show(event->button, event->time, fl->info);
		break;

	default:
		init_dialog_message("We get a invalid event in open_file_handler");
	
	}
}

static void
press_column_handler (GtkWidget *widget, gint column)
{
	if (column == 1) {
		by_name_handler();
	}
	else if (column == 2) {
		by_size_handler();
	}
	else if (column == 3) {
		by_time_handler();
	}
	else {
		;
	}
}

/* This func sort files by name */
static void 
by_name_handler (void)
{
	FileList  *buf;

        /* set cursor */
	gdk_window_set_cursor(Mainwindow->window, WCursor);

        /* sort files */
	Files = sort_files (Files, BY_NAME);

	if (Display_type == ICON) {
		/* remove widget  */
		gtk_container_foreach(GTK_CONTAINER(workplace), 
				      (GtkCallback) gtk_widget_destroy, NULL);
		emphasized_icon_image = NULL;
		emphasized_icon_label = NULL;

		display_files_by_icon();
	}
	else if (Display_type == LIST) {
		/* remove widget  */
		gtk_clist_clear(GTK_CLIST(workplace));

		buf = Files;
		while (1) {
			if (!buf) {
				break;
			}
			create_file_list(buf);
			buf = buf->next;
		}

		display_files_by_list();
	}

        /* set cursor */
	gdk_window_set_cursor(Mainwindow->window, NCursor);
}

/* This func sort files by size */
static void 
by_size_handler (void)
{
	FileList  *buf;

        /* set cursor */
	gdk_window_set_cursor(Mainwindow->window, WCursor);

        /* sort files */
	Files = sort_files (Files, BY_SIZE);

	if (Display_type == ICON) {
		/* remove widget  */
		gtk_container_foreach(GTK_CONTAINER(workplace), 
				      (GtkCallback) gtk_widget_destroy, NULL);
		emphasized_icon_image = NULL;
		emphasized_icon_label = NULL;

		display_files_by_icon();
	}
	else if (Display_type == LIST) {
		/* remove widget  */
		gtk_clist_clear(GTK_CLIST(workplace));

		buf = Files;
		while (1) {
			if (!buf) {
				break;
			}
			create_file_list(buf);
			buf = buf->next;
		}

		display_files_by_list();
	}

        /* set cursor */
	gdk_window_set_cursor(Mainwindow->window, NCursor);
}

/* This func sort files by time */
static void 
by_time_handler (void)
{
	FileList  *buf;

	/* set cursor */
	gdk_window_set_cursor(Mainwindow->window, WCursor);

	/* sort files */
	Files = sort_files (Files, BY_TIME);

	if (Display_type == ICON) {
		/* remove widget  */
		gtk_container_foreach(GTK_CONTAINER(workplace), 
				      (GtkCallback) gtk_widget_destroy, NULL);
		emphasized_icon_image = NULL;
		emphasized_icon_label = NULL;

		display_files_by_icon();
	}
	else if (Display_type == LIST) {
		/* remove widget  */
		gtk_clist_clear(GTK_CLIST(workplace));

		buf = Files;
		while (1) {
			if (!buf) {
				break;
			}
			create_file_list(buf);
			buf = buf->next;
		}
		display_files_by_list();
	}

        /* set cursor */
	gdk_window_set_cursor(Mainwindow->window, NCursor);
}

/* This func remake icon  */
void
create_file_icon2(FileList *file)
{
	int  x, y;
	
	x = file->x;
	y = file->y;

	
	/* destroy widget */
	if (file->icon) {
		if (file->image->window) 
			gdk_window_clear(file->image->window);
		gtk_widget_destroy(file->icon);
		file->icon = NULL;
		file->image = NULL;
	}
	if (file->label) {
		if (file->label->window) 
			gdk_window_clear(file->label->window);
		gtk_widget_destroy(file->label);
		file->label = NULL;
	}
	if (file->size) {
		g_free(file->size);
		file->size = NULL;
	}
	if (file->time) {
		g_free(file->time);
		file->time = NULL;
	}
			
	create_file_icon(file);
	gtk_fixed_put(GTK_FIXED(workplace), file->icon, file->x, file->y);
}

/* This func create a list of file */
void 
create_file_list2(FileList *file)
{
	gtk_clist_set_text(GTK_CLIST(workplace), file->row, 1, file->info->name);
}



