/*
 *    $Id: if_launcher.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include "Workplace.h"
#include "main.h"
#include "preferences.h"
#include "interface.h"
#include "commands.h"
#include "app_preference.h"
#include "pages.h"
#include "gui_preference.h"
#include "d_message.h"
#include "dnd.h"
#include "if_launcher.h"


static void create_page(Page *page);
static void trayicon_handler (GtkWidget  *widget, GdkEventButton *event);
static void vtrayicon_handler (GtkWidget  *widget, GdkEventButton *event);
static void switch_launcher (void);

extern Page *current_page;

/* This var hold the current tray icon */
Trayicon *current_trayicon;

/* This var hold all pages */
Page *Pages;
GtkWidget *Launcher;

static GtkWidget *bar_button;

void 
init_launcher (GtkWidget *parent)
{
	GtkWidget  *hbox;
	GtkWidget  *event_box;
	GtkWidget  *label;
	Page       *buf;

#ifdef DND
	Trayicon   *buf2;
#endif
	gint        i = 0;

	/* init page */
	Pages = init_page();
	
	/* notebook */
	Launcher = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(Launcher), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(parent), Launcher, TRUE, TRUE, 0);
	gtk_widget_show(Launcher);

	buf = Pages;
	while (1) {
		if (!buf){
			break;
		}
		/* label */
		label = gtk_label_new(buf->name);
		gtk_signal_connect_object(GTK_OBJECT(label), "destroy",
					  GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
		gtk_widget_show(label);

		/* set label */
		buf->gw_name = label;

		/* create contents */
		create_page(buf);

		/* append notebook */
		gtk_notebook_append_page(GTK_NOTEBOOK(Launcher), buf->widget, buf->gw_name);
		buf->num = i++;

                /* DND */
#ifdef DND
		buf2 = buf->ticon;
		while (1) {
			if (!buf2) {
				break;
			}
			set_drop_trayicon(buf2->button);
			
			buf2 = buf2->next;
		}
#endif
		/* next */
		buf = buf->next;
	}

	/* hbox */
	hbox = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 2);
	gtk_box_pack_start(GTK_BOX(parent), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

        /* able/disabel switch */
	event_box = gtk_event_box_new();
	gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(switch_launcher), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), event_box, FALSE, FALSE, 0);
	gtk_widget_show(event_box);

        /* arrow */
	bar_button = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_IN);
	gtk_container_add(GTK_CONTAINER(event_box), bar_button);
	gtk_widget_show(bar_button);

}

void 
add_page(Page *page)
{
	GtkWidget *page_box;
	GtkWidget *event_box;
	GtkWidget *label;

	/* Box */
	page_box = gtk_hbox_new(FALSE, 0);
	gtk_signal_connect_object(GTK_OBJECT(page_box), "destroy",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_container_border_width(GTK_CONTAINER(page_box), 10);
	gtk_widget_show(page_box);

	/* set widget */
	page->widget = page_box;

	/* void button */
	event_box = gtk_event_box_new();
	gtk_widget_set_usize(event_box,ICON_SIZE,-1);
	gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(vtrayicon_handler), NULL);
	gtk_object_set_user_data(GTK_OBJECT(event_box), page);
	gtk_box_pack_end(GTK_BOX(page_box),event_box,TRUE,TRUE,0);
	gtk_widget_show(event_box);


	/* label widget */
	label = gtk_label_new(page->name);
	gtk_signal_connect_object(GTK_OBJECT(label), "destroy",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_widget_show(label);
 
	/* set label */
	page->gw_name = label;

	/* append to notebook */
	gtk_notebook_append_page(GTK_NOTEBOOK(Launcher), page->widget, page->gw_name);
}

void 
add_trayicon(Trayicon *ticon)
{
	GtkWidget   *button;
	GtkWidget   *button_box;
	GtkWidget   *pixmap;
	GtkWidget   *pixmap_label;
	GdkPixmap   *pixmap_data;
	GdkBitmap   *mask;
	GtkStyle    *style;
	char        *pathname;
	char        *xpm;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();
	xpm  = ticon->image;

	/* Button */
	button = gtk_button_new();
	gtk_widget_set_usize(button,ICON_SIZE,ICON_SIZE);
	gtk_signal_connect(GTK_OBJECT(button), "button_press_event",
			   GTK_SIGNAL_FUNC(trayicon_handler), NULL);
	gtk_object_set_user_data(GTK_OBJECT(button), ticon);
	gtk_signal_connect(GTK_OBJECT(button), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_box_pack_start(GTK_BOX(ticon->page->widget),button,FALSE,FALSE,0);
	gtk_widget_show(button);

	/* set widget */
	ticon->button = button;

	/* Button box */
	button_box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(button), button_box);
	gtk_widget_show(button_box);

	/* set widget */
	ticon->box = button_box;

	/* Pixmap */
	if (xpm) {
		pathname = (char *) g_malloc(strlen(Preferences->icon_path)
					     +strlen(xpm)+2);
		strcpy(pathname, Preferences->icon_path);
		strcat(pathname, "/");
		strcat(pathname, xpm);
		
		style = gtk_widget_get_style(button);
		pixmap_data = gdk_pixmap_colormap_create_from_xpm(NULL,cmap,&mask, 
								  &style->bg[GTK_STATE_NORMAL], 
								  pathname);
		g_free(pathname);
		
		if (pixmap_data) {
			pixmap = gtk_pixmap_new(pixmap_data, mask);
			gtk_signal_connect_object(GTK_OBJECT(pixmap), "destroy",
						  GTK_SIGNAL_FUNC(gtk_widget_destroy),
						  NULL);
			gtk_box_pack_start(GTK_BOX(button_box),pixmap,FALSE,FALSE,0);
			gtk_widget_show(pixmap);
			
			/* set widget */
			ticon->gw_image = pixmap;
		}
		else {
			init_dialog_message("Make path correct.");

			/* set widget */
			ticon->gw_image = NULL;
		}
	}
	else {
		/* set widget */
		ticon->gw_image = NULL;
	}

	/* name */
	if (ticon->name != NULL){
		/* label */
		pixmap_label = gtk_label_new(ticon->name);
		gtk_signal_connect(GTK_OBJECT(pixmap_label), "destroy",
				   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
		gtk_box_pack_end(GTK_BOX(button_box), pixmap_label, FALSE, FALSE, 0);
		gtk_widget_show(pixmap_label);
		ticon->gw_name = pixmap_label;
	}

#ifdef DND
	/* DND */
	set_drop_trayicon(button);
#endif
}

static void 
create_page(Page *page)
{
	Trayicon  *tray_icon;
	GtkWidget *page_box;
	GtkWidget *event_box;
	GtkWidget *app_button;
	GtkWidget *button_box;
	GtkWidget *pixmap;
	GtkWidget *pixmap_label;
	GdkPixmap *pixmap_data;
	GdkBitmap *mask;
	GtkStyle *style;
	char *pathname;
	char *name;
	char *xpm;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();

	/* Box */
	page_box = gtk_hbox_new(FALSE, 0);
	gtk_signal_connect_object(GTK_OBJECT(page_box), "destroy",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_container_border_width(GTK_CONTAINER(page_box), 10);
	gtk_widget_show(page_box);

	/* set widget */
	page->widget = page_box;
	
	/* set style */
	style = gtk_widget_get_style(Launcher);

	tray_icon = page->ticon;
	while (1) {
		if (!tray_icon){
			break;
		}

		name = tray_icon->name;
		xpm  = tray_icon->image;

		/* Button */
		app_button = gtk_button_new();
		gtk_widget_set_usize(app_button,ICON_SIZE,ICON_SIZE);
		gtk_signal_connect(GTK_OBJECT(app_button), "button_press_event",
				   GTK_SIGNAL_FUNC(trayicon_handler), NULL);
		gtk_signal_connect(GTK_OBJECT(app_button), "destroy",
				   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
		gtk_object_set_user_data(GTK_OBJECT(app_button), tray_icon);
		gtk_box_pack_start(GTK_BOX(page_box),app_button,FALSE,FALSE,0);
		gtk_widget_show(app_button);

		/* set widget */
		tray_icon->button = app_button;

		/* Button box */
		button_box = gtk_vbox_new(FALSE, 0);
		gtk_container_add(GTK_CONTAINER(app_button), button_box);
		gtk_widget_show(button_box);

		/* set widget */
		tray_icon->box = button_box;

		/* Pixmap */
		if (tray_icon->image) {

			/* set pathname and load pixmap data */
			pathname = (char *) g_malloc(strlen(Preferences->icon_path)
						      + strlen(tray_icon->image) + 2);
			strcpy(pathname, Preferences->icon_path);
			strcat(pathname, "/");
			strcat(pathname, tray_icon->image);
			pixmap_data = gdk_pixmap_colormap_create_from_xpm
				(NULL,cmap, &mask, &style->bg[GTK_STATE_NORMAL], pathname);
			g_free(pathname);

			if (pixmap_data) {
				pixmap = gtk_pixmap_new(pixmap_data, mask);
				gtk_signal_connect_object(GTK_OBJECT(pixmap), "destroy",
							  GTK_SIGNAL_FUNC(gtk_widget_destroy),
							  NULL);
				gtk_box_pack_start(GTK_BOX(button_box),pixmap,FALSE,FALSE,0);
				gtk_widget_show(pixmap);
			
				/* set widget */
				tray_icon->gw_image = pixmap;
			}
			else {
				init_dialog_message("Make path correct.");

				/* set widget */
				tray_icon->gw_image = NULL;
			}
		}
		else {
			/* set widget */
			tray_icon->gw_image = NULL;
		}

		/* name */
		if (name != NULL){
			/* label */
			pixmap_label = gtk_label_new(tray_icon->name);
			gtk_signal_connect(GTK_OBJECT(pixmap_label), "destroy",
					   GTK_SIGNAL_FUNC(gtk_widget_destroy),
					   NULL);
			gtk_box_pack_end(GTK_BOX(button_box),pixmap_label,FALSE,FALSE,0);
			gtk_widget_show(pixmap_label);
			tray_icon->gw_name = pixmap_label;
		}

		/* next */
		tray_icon = tray_icon->next;
	}

	/* void button */
	event_box = gtk_event_box_new();
	gtk_widget_set_usize(event_box,ICON_SIZE,-1);
	gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(vtrayicon_handler), NULL);
	gtk_object_set_user_data(GTK_OBJECT(event_box), page);
	gtk_box_pack_end(GTK_BOX(page_box),event_box,TRUE,TRUE,0);
	gtk_widget_show(event_box);
}



static void 
trayicon_handler(GtkWidget  *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	Trayicon  *tray_icon;

	/* get event */
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	tray_icon = (Trayicon *) gtk_object_get_user_data(GTK_OBJECT(event_widget));

	/* set current page */
	current_page = tray_icon->page;

	/* set current trayicon */
	current_trayicon = tray_icon;

	switch (event->button){
	case 1:
		wp_exec(tray_icon->cmd, tray_icon->args, NULL, tray_icon->dnd);
		break;
	
	case 2:
		break;
	
	case 3:
		;
		break;

	default:
		init_dialog_message("Workplace gets a invalid event");
	}

}

static void 
vtrayicon_handler(GtkWidget  *widget, GdkEventButton *event)
{
	Page       *page;
	GtkWidget  *event_widget;

	/* get event */
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	page = (Page *) gtk_object_get_user_data(GTK_OBJECT(event_widget));

	/* set current page */
	current_page = page;
	
	/* set current trayicon null */
	current_trayicon = NULL;


	switch (event->button){
	case 1:
		break;
	
	case 2:
		break;
	
	case 3:
		;
		break;

	default:
		init_dialog_message("Workplace gets a invalid event");
	}
}     

static void
switch_launcher (void)
{
	if (!GTK_WIDGET_VISIBLE(Launcher)){
		gtk_widget_show(Launcher);
		if (bar_button->window)
			gdk_window_clear(bar_button->window);
		gtk_arrow_set(GTK_ARROW(bar_button),GTK_ARROW_DOWN, GTK_SHADOW_IN);
	}
	else {
		gtk_widget_hide(Launcher->parent);
		gtk_widget_hide(Launcher);
		if (bar_button->window)
			gdk_window_clear(bar_button->window);
		gtk_arrow_set(GTK_ARROW(bar_button),GTK_ARROW_UP, GTK_SHADOW_IN);
		gtk_widget_show(Launcher->parent);
	}
}

