/*
 *    $Id: if_directory.c,v 1.1.1.1 1998/04/21 02:21:27 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include "preferences.h"
#include "if_workplace.h"
#include "d_message.h"
#include "if_directory.h"

/* macro */
#define NO_SELECTED  0
#define SELECTED     1
#define MAX_SIZE 1000

struct slist {
	struct slist *next;
	char         *data;
};

typedef struct PathList {
	/* next */
	struct PathList  *next;

	/* something to hold this structur */
	struct DIndex *dir;
	
	/* widget box */
	GtkWidget  *box;

	/* widget ID fo arrow */
	GtkWidget *image;

	/* current directory name */
	char  *name;
} PathList;

typedef struct DIndex {
	/* next */
	struct DIndex *next;

	/* list of pathname */
	struct PathList  *path;

	/* name */
	char  *name;

	/* widget box */
	GtkWidget  *box;

	/* emphasize */
	GtkWidget  *emphasize;

	/* style which contain bg color */
	GtkStyle  *style;
} DIndex;

/* static function */
static void init_index(void);
static void add_index(DIndex *dir);
static void emphasize_dindex(GtkWidget *widget);
static void emphasize_dindex2(GtkWidget *widget);
static void press_dindex_handler(GtkWidget  *widget, GdkEventButton *event);
static void press_pathname_handler(GtkWidget  *widget, GdkEventButton *event);
static void add_pathname(DIndex *dir, char *str);

static char * get_absolute_pathname(DIndex *dir);
static struct DIndex *new_dindex(const char *pathname, const char *name);

/* This var has a current absolute pathname */
static char *current_path;

/* This var hold structure od dir_index */
static DIndex *d_index;
static DIndex *current_dindex;

/* change list box bg color */
static GtkStyle *mystyle;

/* path window */
static GtkStyle *selected_style;

/*   */
static GtkWidget *index_box;
static GtkWidget *emphasized_dindex;
static GtkWidget *emphasized_dindex2;

/* This func initalize a component of directory */ 
void 
init_directory(GtkWidget *parent)
{
	GtkWidget *vbox;
	GtkWidget *window;
	GtkStyle *style;


	/* set style to change list box color */
	style = gtk_widget_get_style(Mainwindow);
	style->fg[GTK_STATE_SELECTED] = (GdkColor)  { 0, 0x0000, 0x0000, 0x0000 };
	style->bg[GTK_STATE_SELECTED] = (GdkColor) style->bg[GTK_STATE_NORMAL];

	/* main box */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), vbox, TRUE, TRUE, 0);
	gtk_widget_show(vbox);
	
	/*==================  directory window  ===================*/
	/* set style to change arrow and label color */
	mystyle = gtk_style_new();
	selected_style = gtk_style_new();
	selected_style->bg[GTK_STATE_NORMAL] = (GdkColor) {0,0xffff,0xffff,0xffff};

	/* index window */
	window = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(window),GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox), window, TRUE, TRUE, 0);
	gtk_widget_show(window);

	
	/* This widget contains bookmarks (path) */
	index_box = gtk_vbox_new(FALSE, 2);
	gtk_container_add (GTK_CONTAINER(window), index_box);
	gtk_widget_show(index_box);

	/* run */
	init_index();
}

void 
select_dirname(char *str)
{
	char      *pathname;

	add_pathname(current_dindex, str);

	/* set absolute pathname */
	pathname =  get_absolute_pathname(current_dindex);
	if (current_path){
		g_free(current_path);
	}
	current_path = pathname;
}

static void 
init_index(void)
{	
	DIndex   *buf;
	Shortcut *scut;
	char     *str;

	/* add a index: localhost */
	str =  getenv("HOSTNAME");
	d_index = new_dindex("/", str);
	add_index(d_index);

	/* add a index: home directory */
 	str = (char *) g_malloc(strlen(Preferences->home) +2);
	strcpy(str, Preferences->home);
	strcat(str, "/");
	d_index->next = new_dindex(str, "Home directory");
	add_index(d_index->next);
	

	/* custom shortcut */
	if (Preferences->shortcut) {
		buf = d_index->next;
		scut = Preferences->shortcut;
		while (1) {
			if (!scut){
				break;
			}
			buf->next = new_dindex(scut->path, NULL);
			add_index(buf->next);
			buf = buf->next;
			buf->next = NULL;
	
			/* next */
			scut = scut->next;
		}
	}
}

static void 
add_index(DIndex *dindex)
{
	GtkWidget *color_box;
	GtkWidget *main_box;
	GtkWidget *hbox;
	GtkWidget *space;
	GtkWidget *event_box;
	GtkWidget *label;
	GtkWidget *arrow;
	
	/* This widget exist to change background color */
	color_box = gtk_event_box_new ();
	gtk_widget_set_style(color_box, dindex->style);
	gtk_signal_connect(GTK_OBJECT(color_box), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(color_box), "expose_event",
			   GTK_SIGNAL_FUNC(emphasize_dindex), NULL);
	gtk_box_pack_start(GTK_BOX(index_box), color_box, FALSE, TRUE, 0);
	gtk_widget_show(color_box);
	
	/* main box */
	main_box = gtk_hbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(color_box), main_box);
	gtk_widget_show(main_box);
	
	/* box */
	hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(main_box), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	/*# space */
	space = gtk_label_new(" ");
	gtk_box_pack_start(GTK_BOX(hbox), space, FALSE, FALSE, 0);
	gtk_widget_show(space);

	/* event box */
	event_box = gtk_event_box_new ();
	gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(press_dindex_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
			   GTK_SIGNAL_FUNC(emphasize_dindex), NULL);
	gtk_object_set_user_data(GTK_OBJECT(event_box), dindex);
	gtk_box_pack_start(GTK_BOX(hbox), event_box, FALSE, FALSE, 0);
	gtk_widget_show (event_box);

	/* label */
	if (dindex->name){
		label = gtk_label_new(dindex->name);
	}
	else {
		label = gtk_label_new(dindex->path->name);
	}
	gtk_signal_connect(GTK_OBJECT(label), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_container_add(GTK_CONTAINER(event_box), label);
	gtk_widget_show(label);
	
	/* arrow */
	arrow = gtk_arrow_new(GTK_ARROW_RIGHT, GTK_SHADOW_NONE);
	gtk_signal_connect(GTK_OBJECT(arrow), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), arrow, FALSE, FALSE, 0);
	gtk_widget_show(arrow);

	/* set dir_files */
	dindex->box          = main_box;
	dindex->emphasize    = event_box;
	dindex->path->image  = arrow;
	dindex->path->box    = hbox;    
}


/* This func is ocuured by pressing pathname in index. */
static void 
press_dindex_handler(GtkWidget  *widget, GdkEventButton *event)
{
	GtkWidget  *event_widget;
	PathList   *garbage;
	PathList   *tmp1;
	DIndex     *tmp2;
	char       *pathname;

	/* get event */
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	tmp2 = (DIndex *) gtk_object_get_user_data(GTK_OBJECT(event_widget));

	/* change current index */
	if (current_dindex){
		/* clear garbage */
		tmp1 = current_dindex->path->next; 
		while (1) {
			if (!tmp1){
				break;
			}
			garbage = tmp1;
			tmp1 = tmp1->next;
			if (garbage->name) {
				g_free(garbage->name);
			}
			gtk_widget_destroy(garbage->box);
			g_free(garbage);
		}
		current_dindex->path->next = NULL;
		gtk_arrow_set(GTK_ARROW(current_dindex->path->image),GTK_ARROW_RIGHT, 
			      GTK_SHADOW_NONE);
	}
	current_dindex = tmp2;
	
	/* set arrow */
	gtk_arrow_set(GTK_ARROW(current_dindex->path->image),GTK_ARROW_RIGHT, GTK_SHADOW_IN);

	/*set absolute  pathname*/
	pathname = get_absolute_pathname(current_dindex);
	if (current_path) {
		g_free(current_path);
	}
	current_path = pathname;

	/* emphasize */
	if (emphasized_dindex) {
		/* remove old emphasize */
		if (emphasized_dindex->window)
			gdk_window_clear(emphasized_dindex->window);
		gtk_widget_draw_children(emphasized_dindex);
		emphasized_dindex = NULL;
	}
	if (emphasized_dindex2) {
		/* remove old emphasize */
		if (emphasized_dindex2->window)
			gdk_window_clear(emphasized_dindex2->window);
		gtk_widget_draw_children(emphasized_dindex2);
		emphasized_dindex2 = NULL;
	}
	emphasized_dindex = current_dindex->box->parent;
	emphasized_dindex2 = widget;
	emphasize_dindex(emphasized_dindex);
	emphasize_dindex(emphasized_dindex2);

	/* send pathname to workplace */
	display_files(current_path, BY_NAME);
}

static void 
press_pathname_handler(GtkWidget  *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	PathList  *pathlist;
	PathList  *tmp;
	PathList  *garbage;
	char      *pathname;

	event_widget = gtk_get_event_widget((GdkEvent*)event);
	pathlist = (PathList *) gtk_object_get_user_data(GTK_OBJECT(event_widget));

	/* remove garbage */
	tmp = pathlist->next; 
	while (1) {
		if (!tmp){
			break;
		}
		else {
			garbage = tmp;
			tmp = tmp->next;
			if(garbage->name){
				g_free(garbage->name);
			}
			gtk_widget_destroy(garbage->box);
			g_free(garbage);
		}
	}
	pathlist->next = NULL;

	/* flush */
	gdk_flush();

	/* set absolute pathname */
	pathname = get_absolute_pathname(current_dindex);
	if(current_path){
		g_free(current_path);
	}
	current_path = pathname;

        /* send pathname to workplace */
	display_files(current_path, BY_NAME);
}


static void
emphasize_dindex(GtkWidget *widget)
{
	if (emphasized_dindex == widget) {
		/* rectangle (x, y, width, height) */
		gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
				   0, 0, widget->allocation.width, widget->allocation.height);
		gtk_widget_draw_children(widget);
	}
	if (emphasized_dindex2 == widget) {
		/* rectangle (x, y, width, height) */
		gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
				   0, 0, widget->allocation.width, widget->allocation.height);
		gtk_widget_draw_children(widget);
	}
}

static void
emphasize_dindex2(GtkWidget *widget)
{
	/* rectangle (x, y, width, height) */
	gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->white_gc, TRUE,
			   0, 0, widget->allocation.width, widget->allocation.height);
	gtk_widget_draw_children(widget);
}

static void 
add_pathname(DIndex *dindex, char *str)
{
	GtkWidget  *hbox;
	GtkWidget  *event_box;
	GtkWidget  *label;
	GtkWidget  *arrow;
	PathList   *buf;

	for (buf = dindex->path ; buf->next ; buf = buf->next) ;

	buf->next = (PathList *) g_malloc(sizeof(PathList));
	buf  = buf->next;
	buf->next = NULL;
	buf->dir = current_dindex;
	buf->name = (char *) g_malloc(strlen(str)+1);
	strcpy(buf->name, str);

	/* box */
	hbox = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(dindex->box), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);
	
	/* event box */
	event_box = gtk_event_box_new();
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(press_pathname_handler), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(event_box), "expose_event",
			   GTK_SIGNAL_FUNC(emphasize_dindex2), NULL);
	gtk_object_set_user_data(GTK_OBJECT(event_box), buf);
	gtk_box_pack_start(GTK_BOX(hbox), event_box, FALSE, FALSE, 0);
	gtk_widget_show (event_box);

	/* label */
	label = gtk_label_new(buf->name);
	gtk_signal_connect(GTK_OBJECT(label), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_container_add(GTK_CONTAINER(event_box), label);
	gtk_widget_show(label);

	/* arrow */
	arrow = gtk_arrow_new(GTK_ARROW_RIGHT, GTK_SHADOW_IN);
	gtk_signal_connect(GTK_OBJECT(arrow), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), arrow, FALSE, FALSE, 0);
	gtk_widget_show(arrow);

	/* set dir_files */
	buf->box    = hbox;
	buf->image  = arrow;
}

static char *
get_absolute_pathname(DIndex *dindex)
{
	PathList  *tmp;
	char      *buf;
	char      *pathname;

	/* make full pathname */
	tmp = dindex->path;

	buf = (char *) g_malloc(MAX_SIZE);
	strcpy(buf,  tmp->name);

	tmp = tmp->next;
	while(1){
		if(!tmp){
			break;
		}
		strcat(buf, tmp->name);
		strcat(buf, "/");
		tmp = tmp->next;
	}

	pathname = (char *) g_malloc(strlen(buf) +1);
	strcpy(pathname, buf);
	g_free(buf);

	return pathname;
}

static DIndex *
new_dindex(const char *pathname, const char *name)
{
	DIndex    *dindex;
	PathList  *buf;

	dindex = (DIndex *) g_malloc(sizeof(DIndex));

	dindex->next = NULL;

	if(name){
		dindex->name  = (char *) g_malloc(strlen(name) +1);
		strcpy(dindex->name, name);
	}
	else {
		dindex->name = NULL;
	}

	/* set style */
	dindex->style = mystyle;

	/* new path info */
	dindex->path  = (PathList *) g_malloc(sizeof(PathList));
	buf = dindex->path;

	buf->next = NULL;
	buf->dir  = dindex;
	buf->name = (char *) g_malloc(strlen(pathname)+1);
	strcpy(buf->name, pathname);
	buf->box = NULL;
	buf->image = NULL;

	return dindex;
}

