/*
 *    $Id: gui_preference.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include "preferences.h"
#include "pages.h"
#include "if_launcher.h"
#include "page_preference.h"
#include "pref_launcher.h"
#include "pref_suffix.h"
#include "app_preference.h"
#include "misc_preference.h"
#include "gui_preference.h"

static void init_button (GtkWidget *parent);
static void save_Preference (void);
static void cancel_Preference(void);
static void destroy_PreferenceWindow (void);

/* This var hold preferences of workplace */
extern Preference *Preferences;
extern NewTrayIcon *new_trayicon;
extern NewTrayIcon *new_trayicon_p;
extern RemovedTrayIcon *removed_trayicon;
extern RemovedTrayIcon *removed_trayicon_p;
extern ModifiedTrayIcon *modified_trayicon;
extern ModifiedTrayIcon *modified_trayicon_p;
extern NewPage *new_page;
extern NewPage *new_page_p;
extern RemovedPage *removed_page;
extern RemovedPage *removed_page_p;
extern ModifiedPage *modified_page;
extern ModifiedPage *modified_page_p;
extern Page *Pages;
extern SLL *image_files; 
extern GtkWidget *ticon_tmp_widget;
extern NewTrayIcon *trayicon_tmp;


GtkWidget *preference_window;

void 
create_PreferenceWindow(void)
{
	GtkWidget *main_box;
	GtkWidget *notebook;
	GtkWidget *label;
	GtkWidget *main_hbox;

	if(!preference_window) {
		/* Create the main window */
		preference_window = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_container_border_width(GTK_CONTAINER(preference_window), 10);
		gtk_window_set_title(GTK_WINDOW(preference_window), "Preference");
		gtk_window_position(GTK_WINDOW(preference_window), GTK_WIN_POS_CENTER);
		gtk_signal_connect(GTK_OBJECT(preference_window), "delete_event",
				   GTK_SIGNAL_FUNC(destroy_PreferenceWindow), NULL);

		/* Create a container to hold everything */
		main_box = gtk_vbox_new(FALSE, 6);
		gtk_container_add(GTK_CONTAINER(preference_window), main_box);
		gtk_widget_show(main_box);

		/* pixmap names */
		image_files = get_image_files();

		/* notebook */
		notebook = gtk_notebook_new();
		gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
		gtk_box_pack_start(GTK_BOX(main_box), notebook, FALSE, FALSE, 0);
		gtk_widget_show(notebook);


		/* launcher parts */
		/* label */
		label = gtk_label_new(" Launcher ");
		gtk_widget_show(label);	
		
		/* box */
		main_hbox = gtk_hbox_new(FALSE, 6);
		gtk_container_border_width(GTK_CONTAINER(main_hbox), 12);
		gtk_widget_show(main_hbox);

		init_LauncherPref(main_hbox);

		/* append notebook */
		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), main_hbox, label);


		/* suffix parts */
		/* label */
		label = gtk_label_new(" Suffix ");
		gtk_widget_show(label);	

		/* box */
		main_hbox = gtk_hbox_new(FALSE, 6);
		gtk_container_border_width(GTK_CONTAINER(main_hbox), 12);
		gtk_widget_show(main_hbox);

		init_SuffixPref(main_hbox);

		/* append notebook */
		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), main_hbox, label);
		

		/* misc parts */
		/* label */
		label = gtk_label_new(" Misc ");
		gtk_widget_show(label);	
		
		/* box */
		main_hbox = gtk_hbox_new(FALSE, 6);
		gtk_container_border_width(GTK_CONTAINER(main_hbox), 12);
		gtk_widget_show(main_hbox);

		init_misc_gui(main_hbox);
		
		/* append notebook */
		gtk_notebook_append_page(GTK_NOTEBOOK(notebook), main_hbox, label);

		/* init button */
		init_button(main_box);
	}

	if (!GTK_WIDGET_VISIBLE(preference_window)){
		/* show all */
		gtk_widget_show(preference_window);
	}
}

static void 
init_button(GtkWidget *parent)
{
	GtkWidget *main_box;
	GtkWidget *hbox;
	GtkWidget *ok_button;
	GtkWidget *cancel_button;
 
	/* box */
	main_box = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_end(GTK_BOX (parent), main_box, TRUE, TRUE, 0);
	gtk_widget_show(main_box);

	/* hbox */
	hbox = gtk_hbox_new(FALSE, 6);
	gtk_box_pack_end(GTK_BOX (main_box), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);
		
			
	/*  The OK button  */
	ok_button = gtk_button_new_with_label(" Save ");
	gtk_signal_connect(GTK_OBJECT(ok_button), "clicked",
			   GTK_SIGNAL_FUNC(save_Preference), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), ok_button, FALSE, FALSE, 0);
	gtk_widget_show(ok_button);

	/*  The Cancel button  */
	cancel_button = gtk_button_new_with_label(" Cancel ");
	gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
			   GTK_SIGNAL_FUNC(cancel_Preference), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), cancel_button, FALSE, FALSE, 0);
	gtk_widget_show(cancel_button);
}

static void 
save_Preference(void)
{
	/*
	if (now == PAGE) {
		check_PagePreference();
	}
	else if (now == APP) {
		check_AppPreference();
	}
	*/
	save_misc_gui();
	save_PagePreference();
	save_AppPreference();
	save_SuffixPref();

	/* destroy */
	destroy_PreferenceWindow();
}


static void 
cancel_Preference(void)
{
	/* remove pages */
	cancel_PagePreference();

	/* remove apps */
	cancel_AppPreference ();

	/* remove shorcut in misc */
	cancel_misc_gui();

	/* remove suffix */
	cancel_SuffixPref();

	/* destroy */
	destroy_PreferenceWindow();
}

static void 
destroy_PreferenceWindow(void)
{
	SLL *garbage;
	SLL *p;

	/* clean memory */
	p = image_files;
	if (p){
		while (1) {
			garbage = p;
			g_free(p->data);
			p = p->next;
			g_free(garbage);
			if (!p){
				break;
			}
		}
	}
	image_files = NULL; 

	gtk_widget_destroy(preference_window);
	preference_window = NULL;

	/* pages */
	new_page = NULL;
	new_page_p = NULL;
	removed_page = NULL;
	removed_page_p = NULL;
	modified_page = NULL;
	modified_page_p = NULL;

	/* trayicon */
	new_trayicon = NULL;
	new_trayicon_p = NULL;
	removed_trayicon = NULL;
	removed_trayicon_p = NULL;
	modified_trayicon = NULL;
	modified_trayicon_p = NULL;
	ticon_tmp_widget = NULL;
	trayicon_tmp = NULL;

	/* emphasize */
	free_misc_gui();
	free_AppPreference();
	free_PagePreference();
	free_LauncherPref();
}




