/*
 *    $Id: files.h,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#ifndef _FILES_H
#define _FILES_H

#include <gtk/gtk.h>

typedef enum FileType {
        S_LINK,
        DIRECTORY,
        NORMAL,
	NONE
} FileType;

typedef enum DisplayType {
	ICON,
	LIST
} DisplayType;

typedef struct Fileinfo {
	/* parent */
	struct FileList *parent;

	/* path name */
	char *path;

	/* a file name */
        char *name;
	
	/* an abbreviated file name*/
        char *name_abbr;

	/* stat */
        struct stat *stat;
	
	/* an abbreviated day */
	char *day_abbr;

	/* ?? */
        char *linkname;

	/* ?? */
        unsigned int linkmode;

	/* ?? */
        int linkok;

	/* file type */
        enum FileType filetype;
} Fileinfo;

typedef struct FileList {
	struct FileList *next;
	struct FileList *prev;

	/* This var hold a info of file */
	Fileinfo        *info;

	/* This var hold a widget ID of box which contain all */
	GtkWidget  *icon;
	GtkWidget  *image;
	GtkWidget  *label;

	/* position */
	int  x;
	int  y;

	/* for List */
	char  *size;
	char  *time;
	int   row;
} FileList;

enum sorttype {
        BY_NAME,
        BY_TIME,
        BY_SIZE 
};

FileList *init_files (const char *, enum sorttype);
FileList *sort_files (FileList  *list, enum sorttype stype);
void clear_files (FileList *);
#endif /* _FILES_H */

