/*
 *    $Id: file_preference.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <utime.h>
#include <fcntl.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include "d_message.h"
#include "if_workplace.h"
#include "file_attr.h"
#include "suffix.h"
#include "file_preference.h"

#include "maru.xpm" 
#define ON_XPM maru_xpm
#include "batu.xpm" 
#define OFF_XPM batu_xpm

#define TABEL_WIDTH  240 
#define TABEL_HEIGHT 100
#define MARGIN 10

 
typedef struct FilePref {
	GtkWidget    *widget;
	GtkWidget    *label;
	GtkWidget    *entry;
	GtkWidget    *gw_name;
	int          mode;
	char         *path;
	char         *name;
	char         *size;
	char         *year;
	char         *day;
	char         *time;
	char         *owner;
	char         *group;
	struct stat  *stat;
} FilePref;

typedef enum Changes {
	 OWNER,
	 GROUP,
	 NAME
} Changes;

static void init_name_panel (GtkWidget *parent, Fileinfo *fi, const char *path);
static void init_size_time (GtkWidget *main_box, Fileinfo *fi);
static void init_owner_group (GtkWidget *parent, Fileinfo *fi);
static void init_permission (GtkWidget *main_box, Fileinfo *fi);
static void init_button (GtkWidget *main_box, Fileinfo *fi);
static void change_name (GtkWidget *widget);
static void change_owner (GtkWidget *widget);
static void change_group (GtkWidget *widget);
static void change_rusr (GtkWidget *widget,GdkEventButton *event);
static void change_wusr (GtkWidget *widget,GdkEventButton *event);
static void change_xusr (GtkWidget *widget,GdkEventButton *event);
static void change_rgrp (GtkWidget *widget,GdkEventButton *event);
static void change_wgrp (GtkWidget *widget,GdkEventButton *event);
static void change_xgrp (GtkWidget *widget,GdkEventButton *event);
static void change_roth (GtkWidget *widget,GdkEventButton *event);
static void change_woth (GtkWidget *widget,GdkEventButton *event);
static void change_xoth (GtkWidget *widget,GdkEventButton *event);
static void change_FilePreference (GtkWidget *widget, Fileinfo *fi);
static void destroy_FilePreference (void);
static void expose_event (GtkWidget *widget, GdkEventExpose *event);

/* This var hold a type of displaying*/
extern DisplayType Display_type;

/* This var hold pointers which should clear garbage when FilePreference is destroyed. */
static FilePref *file_preference = NULL;

/* This var contains pixmap data   */
static GdkBitmap *on_mask = NULL;
static GdkPixmap *on_xpm = NULL;
static GdkBitmap *off_mask = NULL;
static GdkPixmap *off_xpm = NULL;

/* This var hold a changes of application */

static char *name;
static char *owner;
static char *group;

static GtkWidget *entry_name;
static GtkWidget *entry_owner;
static GtkWidget *entry_group;

static changed_mode = 0;

void 
init_FilePreference(const char *path, Fileinfo *fi)
{
	GtkWidget *main_box;
	GtkWidget *separator;

	if(!file_preference) {
	
		/* allocate */
		file_preference = (FilePref *) g_malloc(sizeof(FilePref)); 
		file_preference->path = (char *) g_malloc(strlen(path)+1);
		strcpy(file_preference->path, path);
		file_preference->stat = fi->stat;

		/* Create the main window */
		file_preference->widget = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_window_set_title(GTK_WINDOW(file_preference->widget), "Attribute");
		gtk_window_position(GTK_WINDOW(file_preference->widget), GTK_WIN_POS_CENTER);
		gtk_signal_connect(GTK_OBJECT(file_preference->widget), "delete_event",
				   GTK_SIGNAL_FUNC(destroy_FilePreference), NULL);

		/* Create a container to hold everything */
		main_box = gtk_vbox_new(FALSE, 4);
		gtk_container_add(GTK_CONTAINER(file_preference->widget), main_box);
		gtk_widget_show(main_box);

		init_name_panel(main_box, fi, path);

		/*separator*/
		separator = gtk_hseparator_new();
		gtk_box_pack_start (GTK_BOX (main_box), separator, FALSE, TRUE, 0);
		gtk_widget_show (separator);

		init_size_time(main_box, fi);
		init_owner_group(main_box,fi);
		init_permission(main_box, fi);
		
                /*separator*/
		separator = gtk_hseparator_new ();
		gtk_box_pack_start (GTK_BOX (main_box), separator, FALSE, TRUE, 0);
		gtk_widget_show (separator);

		init_button(main_box, fi);
	}
	if (!GTK_WIDGET_VISIBLE(file_preference->widget)){
		/* show all */
		gtk_widget_show(file_preference->widget);
	
	}
}

static void 
init_name_panel(GtkWidget *parent, Fileinfo *fi, const char *str)
{
	GtkWidget     *main_box;
	GtkWidget     *hbox1;
	GtkWidget     *pixmap;
	GtkWidget     *name_label;
	GtkWidget     *hbox2;
	GtkWidget     *path_label;
	GtkWidget     *hbox3;
	GtkWidget     *label;
	GtkStyle      *style;


	/* set style */
	style = gtk_style_new();
	style->font = gdk_font_load ("-adobe-times-medium-*-*--*-180-*-*-*-*-*-*");
	
	/* box */
	main_box = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER (main_box), 10);
	gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);

	/* hbox */
	hbox1 = gtk_hbox_new(FALSE, 20);
	gtk_container_border_width(GTK_CONTAINER (hbox1), 8);
	gtk_box_pack_start(GTK_BOX(main_box), hbox1, FALSE, FALSE, 0);
	gtk_widget_show(hbox1);
	
	/* pixmap */
	if (fi->filetype == DIRECTORY) {
		pixmap = get_pixmap_from_name (fi->name, DIRECTORY);
	}
	else {
		pixmap = get_pixmap_from_name (fi->name, NORMAL);
	}
	gtk_box_pack_start(GTK_BOX(hbox1), pixmap, FALSE, FALSE, 0);
	gtk_widget_show(pixmap);

	/* name */
	name_label = gtk_label_new(fi->name);
	gtk_widget_set_style(name_label, style);
	gtk_box_pack_start(GTK_BOX (hbox1), name_label, FALSE, FALSE, 0);
	gtk_widget_show(name_label);

	/* set */
	file_preference->name = fi->name;
	file_preference->gw_name = name_label;

	/* hbox */
	hbox2 = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(main_box), hbox2, FALSE, FALSE, 0);
	gtk_widget_show(hbox2);

	/* path */
	path_label = gtk_label_new("Path:");
	gtk_box_pack_start(GTK_BOX (hbox2), path_label, FALSE, FALSE, 0);
	gtk_widget_show(path_label);

	/* path */
	path_label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX (hbox2), path_label, FALSE, FALSE, 0);
	gtk_widget_show(path_label);

	/* hbox for name */
	hbox3 = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(main_box), hbox3, FALSE, FALSE, 0);
	gtk_widget_show(hbox3);

	/* label */
	label = gtk_label_new("Name:");
	gtk_box_pack_start(GTK_BOX (hbox3), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	/* entry for name */
	entry_name = gtk_entry_new();
	gtk_signal_connect(GTK_OBJECT(entry_name), "changed",
			   GTK_SIGNAL_FUNC(change_name), NULL);
	gtk_box_pack_start(GTK_BOX (hbox3), entry_name, TRUE, TRUE, 0);
	gtk_widget_show(entry_name);

	/* set name */
	gtk_entry_set_text(GTK_ENTRY(entry_name), file_preference->name);
}

static void 
init_size_time(GtkWidget *parent, Fileinfo *fi)
{
	GtkWidget *main_box;
	GtkWidget *hbox;
	GtkWidget *size_label;
	GtkWidget *size_size;
	GtkWidget *frame;
	GtkWidget *time_label;
	GtkWidget *vbox;
	GtkWidget *year_label;
	GtkWidget *mon_label;
	GtkWidget *day_label;
	GtkStyle  *style;
	char      *month = NULL;

	/* set size */
	file_preference->size = parse_size(fi->stat);

	/* set time */
	file_preference->time = parse_time(fi->stat);

	/* year */
	file_preference->year = parse_year(fi->stat, 0);

	/* month */
	month = parse_month(fi->stat, 0);

	/* day */
	file_preference->day = parse_mday(fi->stat);

	/*----- create GUI ----*/
	/* set style */
	style = gtk_style_new();
	style->font = gdk_font_load ("-adobe-times-medium-*-*--*-240-*-*-*-*-*-*");

        /* box */
	main_box = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER (main_box), 10);
	gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);

        /* hbox */
	hbox = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(main_box), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	/* size label */
	size_label =  gtk_label_new("Size:");
	gtk_box_pack_start(GTK_BOX (hbox), size_label, FALSE, FALSE, 0);
	gtk_widget_show(size_label);

        /* size label */
	size_size =  gtk_label_new(file_preference->size);
	gtk_box_pack_start(GTK_BOX (hbox), size_size, FALSE, FALSE, 0);
	gtk_widget_show(size_size);


	/* frame */
	frame = gtk_frame_new ("Last changed");
	gtk_box_pack_start(GTK_BOX(main_box), frame, TRUE, FALSE, 0);
	gtk_widget_show (frame);

        /* hbox */
	hbox = gtk_hbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER (hbox), 8);
	gtk_container_add(GTK_CONTAINER (frame), hbox);
	gtk_widget_show(hbox);

	/* time */
	time_label = gtk_label_new(file_preference->time);
	gtk_widget_set_style(time_label, style);
	gtk_box_pack_start(GTK_BOX (hbox), time_label, TRUE, FALSE, 0);
	gtk_widget_show(time_label);

	/* day */
        /* vbox */
	vbox = gtk_vbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX (hbox), vbox, TRUE, FALSE, 0);
	gtk_widget_show(vbox);

	/* year */
	year_label = gtk_label_new(file_preference->year);
	gtk_box_pack_start(GTK_BOX (vbox), year_label, TRUE, FALSE, 0);
	gtk_widget_show(year_label);

	/* month */
	mon_label = gtk_label_new(month);
	gtk_box_pack_start(GTK_BOX (vbox), mon_label, TRUE, FALSE, 0);
	gtk_widget_show(mon_label);

	/* day */
	day_label = gtk_label_new(file_preference->day);
	gtk_box_pack_start(GTK_BOX (vbox), day_label, TRUE, FALSE, 0);
	gtk_widget_show(day_label);


}

static void 
init_owner_group(GtkWidget *parent, Fileinfo *fi)
{
	struct passwd  *pw;
	struct group   *gr;
	GtkWidget      *main_box;
	GtkWidget      *vbox1;
	GtkWidget      *vbox2;
	GtkWidget      *label;

	/* set owner */
	pw = getpwuid(fi->stat->st_uid);
	file_preference->owner = (char *) g_malloc(strlen(pw->pw_name)+1);
	strcpy(file_preference->owner, pw->pw_name);

	/* set group */
	gr = getgrgid(fi->stat->st_gid);
	file_preference->group = (char *) g_malloc(strlen(gr->gr_name)+1);
	strcpy(file_preference->group, gr->gr_name);

        /* box */
	main_box = gtk_hbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER (main_box), 10);
	gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);

	/* vbox 1*/
	vbox1 = gtk_vbox_new(TRUE, 4);
	gtk_box_pack_start(GTK_BOX (main_box), vbox1, TRUE, TRUE, 0);
	gtk_widget_show(vbox1);

	/* vbox 2 */
	vbox2 = gtk_vbox_new(TRUE, 4);
	gtk_box_pack_start(GTK_BOX (main_box), vbox2, TRUE, TRUE, 0);
	gtk_widget_show(vbox2);

	/* owner */
	label = gtk_label_new("Owner:");
	gtk_box_pack_start(GTK_BOX (vbox1), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	/* entry for owner */
	entry_owner =  gtk_entry_new();
	gtk_signal_connect(GTK_OBJECT(entry_owner), "changed",
			   GTK_SIGNAL_FUNC(change_owner), NULL);
	gtk_box_pack_start(GTK_BOX (vbox2), entry_owner, FALSE, FALSE, 0);
	gtk_widget_show(entry_owner);

	/* set name */
	gtk_entry_set_text(GTK_ENTRY(entry_owner), file_preference->owner);

	/* group */
	label = gtk_label_new("Group:");
	gtk_box_pack_start(GTK_BOX (vbox1), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	/* entry for group */
	entry_group = gtk_entry_new();
	gtk_signal_connect(GTK_OBJECT(entry_group), "changed",
			   GTK_SIGNAL_FUNC(change_group), NULL);
	gtk_box_pack_start(GTK_BOX (vbox2), entry_group, FALSE, FALSE, 0);
	gtk_widget_show(entry_group);

	/* set name */
	gtk_entry_set_text(GTK_ENTRY(entry_group), file_preference->group);
}

static void 
init_permission(GtkWidget *parent, Fileinfo *fi)
{
	GtkWidget    *main_box;
	GtkWidget    *frame;
	GtkWidget    *area;
	GtkWidget    *label_box1;
	GtkWidget    *rea_label;
	GtkWidget    *wri_label;
	GtkWidget    *exe_label;
	GtkWidget    *label_box2;
	GtkWidget    *own_label;
	GtkWidget    *grp_label;
	GtkWidget    *oth_label;
	GtkWidget    *event_box;
	GtkWidget    *pixmap;
	GtkStyle     *style;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();
	style = gtk_style_new();

	/* box */
	main_box = gtk_hbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER (main_box), 10);
	gtk_box_pack_start(GTK_BOX(parent), main_box, TRUE, TRUE, 0);
	gtk_widget_show(main_box);

	/* init pixmap data */
	style = gtk_style_new();
	on_xpm = gdk_pixmap_colormap_create_from_xpm_d
		(NULL, cmap, &on_mask,&style->bg[GTK_STATE_NORMAL], ON_XPM);
	off_xpm = gdk_pixmap_colormap_create_from_xpm_d
		(NULL, cmap,&off_mask,&style->bg[GTK_STATE_NORMAL],OFF_XPM);

	/* frame */
	frame = gtk_frame_new("Permissions");
	gtk_box_pack_start(GTK_BOX(main_box), frame, TRUE, FALSE, 0);
	gtk_widget_show(frame);

	/* copy mode */
	file_preference->mode = fi->stat->st_mode;
	
	/* fixed */
	area = gtk_fixed_new();
	gtk_widget_set_events(area, GDK_EXPOSURE_MASK);
	gtk_signal_connect(GTK_OBJECT (area), "expose_event",
			   (GtkSignalFunc) expose_event, NULL);
	
	gtk_widget_set_usize (area, TABEL_WIDTH, TABEL_HEIGHT);
	gtk_container_add(GTK_CONTAINER (frame), area);
	gtk_widget_show(area);
	
	/*====== label  ======*/
	/* label box */
	label_box1 = gtk_vbox_new(FALSE, 5);
	gtk_fixed_put(GTK_FIXED(area),label_box1, MARGIN, 12);
	gtk_widget_show(label_box1);

	/* Read */
	rea_label = gtk_label_new("Read");
	gtk_misc_set_alignment (GTK_MISC (rea_label), 1.0, 0.5);
	gtk_box_pack_start(GTK_BOX(label_box1), rea_label, FALSE, FALSE, 0);
	gtk_widget_show(rea_label);

	/* Write */
	wri_label = gtk_label_new("Write");
	gtk_misc_set_alignment (GTK_MISC (wri_label), 1.0, 0.5);
	gtk_box_pack_start(GTK_BOX(label_box1), wri_label, FALSE, FALSE, 0);
	gtk_widget_show(wri_label);
	
	/* Execute */
	exe_label = gtk_label_new("Execute");
	gtk_misc_set_alignment (GTK_MISC (exe_label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX(label_box1), exe_label, FALSE, FALSE, 0);
	gtk_widget_show(exe_label);

        /*====== label  ======*/
	/* label box */
	label_box2 = gtk_hbox_new(TRUE, 12);
	gtk_fixed_put(GTK_FIXED(area),label_box2, 74, 78);
	gtk_widget_show(label_box2);

	/* Owner */
	own_label = gtk_label_new("Owner");
	gtk_box_pack_start(GTK_BOX(label_box2), own_label, FALSE, FALSE, 0);
	gtk_widget_show(own_label);

	/* Group */
	grp_label = gtk_label_new("Group");
	gtk_box_pack_start(GTK_BOX(label_box2), grp_label, FALSE, FALSE, 0);
	gtk_widget_show(grp_label);
	
	/* Others */
	oth_label = gtk_label_new("Other");
	gtk_box_pack_start(GTK_BOX(label_box2), oth_label, FALSE, FALSE, 0);
	gtk_widget_show(oth_label);

	/*============= check  ===========*/
	/* Owner Read */
	if (fi->stat->st_mode & S_IRUSR) {
		pixmap = gtk_pixmap_new(on_xpm, on_mask);
	}
	else {
		pixmap = gtk_pixmap_new(off_xpm, off_mask);
	}

	event_box = gtk_event_box_new();
	gtk_widget_set_events(event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(change_rusr), NULL);
	gtk_object_set_user_data (GTK_OBJECT (event_box), pixmap);
	gtk_fixed_put(GTK_FIXED(area), event_box, 82, 11);
	gtk_widget_show(event_box);

	gtk_container_add(GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);

	/* tooltips *
	tooltips = gtk_tooltips_new();
	gtk_tooltips_set_tips(tooltips, event_box, "Change permission");
	*/

	/* Owner Write */
	if (fi->stat->st_mode & S_IWUSR) {
		pixmap = gtk_pixmap_new(on_xpm, on_mask);
	}
	else {
		pixmap = gtk_pixmap_new(off_xpm, off_mask);
	}

	event_box = gtk_event_box_new();
	gtk_widget_set_events(event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(change_wusr), NULL);
	gtk_object_set_user_data (GTK_OBJECT (event_box), pixmap);
	gtk_fixed_put(GTK_FIXED(area), event_box, 82, 33);
	gtk_widget_show(event_box);

	gtk_container_add(GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);

	/* Owner Execute */
	if (fi->stat->st_mode & S_IXUSR) {
		pixmap = gtk_pixmap_new(on_xpm, on_mask);
	}
	else {
		pixmap = gtk_pixmap_new(off_xpm, off_mask);
	}

	event_box = gtk_event_box_new();
	gtk_widget_set_events(event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(change_xusr), NULL);
	gtk_object_set_user_data (GTK_OBJECT (event_box), pixmap);
	gtk_fixed_put(GTK_FIXED(area), event_box, 82, 55);
	gtk_widget_show(event_box);

	gtk_container_add(GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);

	/* Group Read */
	if (fi->stat->st_mode & S_IRGRP) {
		pixmap = gtk_pixmap_new(on_xpm, on_mask);
	}
	else {
		pixmap = gtk_pixmap_new(off_xpm, off_mask);
	}

	event_box = gtk_event_box_new();
	gtk_widget_set_events(event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(change_rgrp), NULL);
	gtk_object_set_user_data (GTK_OBJECT (event_box), pixmap);
	gtk_fixed_put(GTK_FIXED(area), event_box, 132, 11);
	gtk_widget_show(event_box);

	gtk_container_add(GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);

	/* tooltips *
	tooltips = gtk_tooltips_new();
	gtk_tooltips_set_tips(tooltips, event_box, "Change permission");
	*/

	/* Group Write */
	if (fi->stat->st_mode & S_IWGRP) {
		pixmap = gtk_pixmap_new(on_xpm, on_mask);
	}
	else {
		pixmap = gtk_pixmap_new(off_xpm, off_mask);
	}

	event_box = gtk_event_box_new();
	gtk_widget_set_events(event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(change_wgrp), NULL);
	gtk_object_set_user_data (GTK_OBJECT (event_box), pixmap);
	gtk_fixed_put(GTK_FIXED(area), event_box, 132, 33);
	gtk_widget_show(event_box);

	gtk_container_add(GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);

	/* Group Execute */
	if (fi->stat->st_mode & S_IXGRP) {
		pixmap = gtk_pixmap_new(on_xpm, on_mask);
	}
	else {
		pixmap = gtk_pixmap_new(off_xpm, off_mask);
	}

	event_box = gtk_event_box_new();
	gtk_widget_set_events(event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(change_xgrp), NULL);
	gtk_object_set_user_data (GTK_OBJECT (event_box), pixmap);
	gtk_fixed_put(GTK_FIXED(area), event_box, 132, 55);
	gtk_widget_show(event_box);

	gtk_container_add(GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);

	/* Others Read */
	if (fi->stat->st_mode & S_IROTH) {
		pixmap = gtk_pixmap_new(on_xpm, on_mask);
	}
	else {
		pixmap = gtk_pixmap_new(off_xpm, off_mask);
	}

	event_box = gtk_event_box_new();
	gtk_widget_set_events(event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(change_roth), NULL);
	gtk_object_set_user_data (GTK_OBJECT (event_box), pixmap);
	gtk_fixed_put(GTK_FIXED(area), event_box, 182, 11);
	gtk_widget_show(event_box);

	gtk_container_add(GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);

	/* Others Write */
	if (fi->stat->st_mode & S_IWOTH) {
		pixmap = gtk_pixmap_new(on_xpm, on_mask);
	}
	else {
		pixmap = gtk_pixmap_new(off_xpm, off_mask);
	}

	event_box = gtk_event_box_new();
	gtk_widget_set_events(event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(change_woth), NULL);
	gtk_object_set_user_data (GTK_OBJECT (event_box), pixmap);
	gtk_fixed_put(GTK_FIXED(area), event_box, 182, 33);
	gtk_widget_show(event_box);

	gtk_container_add(GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);

	/* Others Execute */
	if (fi->stat->st_mode & S_IXOTH) {
		pixmap = gtk_pixmap_new(on_xpm, on_mask);
	}
	else {
		pixmap = gtk_pixmap_new(off_xpm, off_mask);
	}

	event_box = gtk_event_box_new();
	gtk_widget_set_events(event_box, GDK_BUTTON_PRESS_MASK);
	gtk_signal_connect(GTK_OBJECT(event_box), "button_press_event",
			   GTK_SIGNAL_FUNC(change_xoth), NULL);
	gtk_object_set_user_data (GTK_OBJECT (event_box), pixmap);
	gtk_fixed_put(GTK_FIXED(area), event_box, 182, 55);
	gtk_widget_show(event_box);

	gtk_container_add(GTK_CONTAINER(event_box), pixmap);
	gtk_widget_show(pixmap);
}

static void 
init_button(GtkWidget *parent, Fileinfo *fi)
{
	GtkWidget *main_box;
	GtkWidget *done_button;
	GtkWidget *cancel_button;

	/* box */
	main_box = gtk_hbox_new(TRUE, 10);
	gtk_container_border_width(GTK_CONTAINER (main_box), 10);
	gtk_box_pack_start(GTK_BOX(parent), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);

	/* button */
	done_button = gtk_button_new_with_label(" Done ");
	GTK_WIDGET_SET_FLAGS(done_button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(done_button), "clicked",
			   GTK_SIGNAL_FUNC(change_FilePreference), fi);
	gtk_object_set_user_data (GTK_OBJECT (done_button), fi);
	gtk_box_pack_start(GTK_BOX(main_box), done_button, TRUE, TRUE, 0);
	gtk_widget_show(done_button);

	/* button */
	cancel_button = gtk_button_new_with_label(" Cancel ");
	GTK_WIDGET_SET_FLAGS(cancel_button, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(cancel_button), "clicked",
			   GTK_SIGNAL_FUNC(destroy_FilePreference), NULL);
	gtk_box_pack_end(GTK_BOX(main_box), cancel_button, TRUE, TRUE, 0);
	gtk_widget_grab_default(cancel_button);
	gtk_widget_show(cancel_button);
}

static void 
change_name(GtkWidget *widget)
{
	char *str;

	if (S_ISREG(file_preference->stat->st_mode)) {
		str = gtk_entry_get_text(GTK_ENTRY(widget));
		if (strlen(str)<1) {
			name = NULL;
		}
		else {
			name = str;
		}
	}
	else {
		/* This code have a probelm
		 *
		 * init_dialog_message("Not yet implemented");
		 */
	}
}

static void 
change_owner(GtkWidget *widget)
{
	char *str;
	
	str = gtk_entry_get_text(GTK_ENTRY(widget));
	if (strlen(str)<1) {
		owner = NULL;
	}
	else {
		owner = str;
	}
}

static void 
change_group(GtkWidget *widget)
{
	char *str;
	
	str = gtk_entry_get_text(GTK_ENTRY(widget));
	if (strlen(str)<1) {
		group = NULL;
	}
	else {
		group = str;
	}
}

static void 
change_rusr (GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	GtkWidget *pixmap;

	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	pixmap = (GtkWidget *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));

	/* clear old pixmap */
	if (widget->window)
		gdk_window_clear(widget->window);

        /* change pixmap */
	if (file_preference->mode & S_IRUSR) {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), off_xpm, off_mask);
		file_preference->mode -= S_IRUSR;
	}
	else {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), on_xpm, on_mask);
		file_preference->mode += S_IRUSR;
	}

	/* set mode */
	changed_mode = 1;
}


static void 
change_wusr (GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	GtkWidget *pixmap;
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	pixmap = (GtkWidget *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));


	/* clear old pixmap */
	if (widget->window)
		gdk_window_clear(widget->window);
	
	if (file_preference->mode & S_IWUSR) {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), off_xpm, off_mask);
		file_preference->mode -= S_IWUSR;
	}
	else {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), on_xpm, on_mask);
		file_preference->mode += S_IWUSR;
	}

	/* set mode */
	changed_mode = 1;
}

static void 
change_xusr (GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	GtkWidget *pixmap;
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	pixmap = (GtkWidget *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));
	

	/* clear old pixmap */
	if (widget->window)
		gdk_window_clear(widget->window);

	if (file_preference->mode & S_IXUSR) {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), off_xpm, off_mask);
		file_preference->mode -= S_IXUSR;
	}
	else {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), on_xpm, on_mask);
		file_preference->mode += S_IXUSR;
	}

	/* set mode */
	changed_mode = 1;
}

static void 
change_rgrp (GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	GtkWidget *pixmap;
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	pixmap = (GtkWidget *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));

	/* clear old pixmap */
	if (widget->window)
		gdk_window_clear(widget->window);

        /* change pixmap */
	if (file_preference->mode & S_IRGRP) {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), off_xpm, off_mask);
		file_preference->mode -= S_IRGRP;
	}
	else {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), on_xpm, on_mask);
		file_preference->mode += S_IRGRP;
	}

	/* set mode */
	changed_mode = 1;
}

static void 
change_wgrp (GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	GtkWidget *pixmap;
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	pixmap = (GtkWidget *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));

	/* clear old pixmap */
	if (widget->window)
		gdk_window_clear(widget->window);
	
	if (file_preference->mode & S_IWGRP) {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), off_xpm, off_mask);
		file_preference->mode -= S_IWGRP;
	}
	else {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), on_xpm, on_mask);
		file_preference->mode += S_IWGRP;
	}

	/* set mode */
	changed_mode = 1;
}

static void 
change_xgrp (GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	GtkWidget *pixmap;
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	pixmap = (GtkWidget *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));

	/* clear old pixmap */
	if (widget->window)
		gdk_window_clear(widget->window);

	if (file_preference->mode & S_IXGRP) {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), off_xpm, off_mask);
		file_preference->mode -= S_IXGRP;
	}
	else {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), on_xpm, on_mask);
		file_preference->mode += S_IXGRP;
	}

	/* set mode */
	changed_mode = 1;
}

static void 
change_roth (GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	GtkWidget *pixmap;
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	pixmap = (GtkWidget *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));

	/* clear old pixmap */
	if (widget->window)
		gdk_window_clear(widget->window);

        /* change pixmap */
	if (file_preference->mode & S_IROTH) {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), off_xpm, off_mask);
		file_preference->mode -= S_IROTH;
	}
	else {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), on_xpm, on_mask);
		file_preference->mode += S_IROTH;
	}

	/* set mode */
	changed_mode = 1;
}

static void 
change_woth (GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	GtkWidget *pixmap;
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	pixmap = (GtkWidget *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));

	/* clear old pixmap */
	if (widget->window)
		gdk_window_clear(widget->window);
	
	if (file_preference->mode & S_IWOTH) {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), off_xpm, off_mask);
		file_preference->mode -= S_IWOTH;
	}
	else {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), on_xpm, on_mask);
		file_preference->mode += S_IWOTH;
	}

	/* set mode */
	changed_mode = 1;
}

static void 
change_xoth (GtkWidget *widget, GdkEventButton *event)
{
	GtkWidget *event_widget;
	GtkWidget *pixmap;
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	pixmap = (GtkWidget *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));
	
	/* clear old pixmap */
	if (widget->window)
		gdk_window_clear(widget->window);

	if (file_preference->mode & S_IXOTH) {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), off_xpm, off_mask);
		file_preference->mode -= S_IXOTH;
	}
	else {
		gtk_pixmap_set (GTK_PIXMAP(pixmap), on_xpm, on_mask);
		file_preference->mode += S_IXOTH;
	}

	/* set mode */
	changed_mode = 1;
}

static void 
change_FilePreference(GtkWidget *widget, Fileinfo *fi)
{
	struct utimbuf tv;
	int            in_fd;
        int            out_fd;
        char           buf[1024 * 8];
        int            len;
	char           *pathname;
	char           *source;
	char           *dest;
	struct passwd  *pw;
	struct group   *gr;

	if (changed_mode) {
		pathname = (char *) g_malloc(strlen(file_preference->path)+
					     strlen(file_preference->name)+1);
		strcpy(pathname, file_preference->path);
		strcat(pathname, file_preference->name);
		chmod(pathname, file_preference->mode);
		g_free(pathname);

		/* set file info */
		fi->stat->st_mode = file_preference->mode; 
	}

	if (strcmp(name,file_preference->name) != 0) {
		/* a full pathname of orignal name */
		source = (char *) g_malloc(strlen(file_preference->path)+
					   strlen(file_preference->name)+1);
		strcpy(source, file_preference->path);
		strcat(source, file_preference->name);

		/* a full pathname of changed name */
		dest = (char *) g_malloc(strlen(file_preference->path)+
					 strlen(name)+1);
		strcpy(dest, file_preference->path);
		strcat(dest, name);

		/* input */
		in_fd = open(source,  O_RDONLY, 0);
		if (in_fd < 0) {
			close(in_fd);
			init_dialog_message("We cannot open.");
			return;
		}

		/* out put */
		out_fd = open(dest,  O_WRONLY | O_CREAT | O_TRUNC, 0600);
		if (out_fd < 0) {
			close(out_fd);
			init_dialog_message("We cannot open.");
			return;
		}
		
		while (1) {
			len = read(in_fd, buf, sizeof(buf));
			if (len <= 0){
				break;
			}

			if (write(out_fd, buf, len) < 0) {
				close(in_fd);
				close(out_fd);
				/*unlink(dest);*/
				return;
			}
		}
		close(in_fd);
		close(out_fd);

		/* set time */
		tv.actime = file_preference->stat->st_atime;
                tv.modtime = file_preference->stat->st_mtime;
                if (utime(dest, &tv)) {
			init_dialog_message("We cannot change time.");
                        return;
                }

		chown(dest, file_preference->stat->st_uid, file_preference->stat->st_gid);
		chmod(dest, file_preference->mode & 07777);

		/* change name */
		rename(source, dest);

		/* free */
		g_free(source);
		g_free(dest);

		/* set file info */
		if (fi->name) {
			g_free(fi->name);
		}
		fi->name = (char *) g_malloc(strlen(name)+1);
		memset ((char*) fi->name, 0, strlen(name)+1);

		strcpy(fi->name, name);
		if (strlen(name)>18){
			if (fi->name_abbr) {
				g_free(fi->name_abbr);
			}
			fi->name_abbr = (char *) g_malloc(19);
			strncpy(fi->name_abbr, name, 16);
			*((fi->name_abbr)+16) = '\0';
			strcat(fi->name_abbr, "...");
		}
		else {
			fi->name_abbr = NULL;
		}
			
	}
	if ((strcmp(owner, file_preference->owner) != 0) 
	    ||(strcmp(group, file_preference->group) != 0)) {
		pw = getpwnam(owner);
		gr = getgrnam(group);
		if (pw && gr) {
			if (chown(fi->name,pw->pw_uid, gr->gr_gid) == -1) {
				init_dialog_message("Operation not permitted.\n");
			}
		}
	}

	/* set current pathname */
	pathname = (char *) g_malloc(strlen(file_preference->path)+1);
	strcpy(pathname, file_preference->path);

	if (Display_type == ICON) {
		/* re-create icon */
		create_file_icon2(fi->parent);
	}
	else if (Display_type == LIST) {
		create_file_list2(fi->parent);
	}

	/* destroy everything */
	destroy_FilePreference();
}


static void 
destroy_FilePreference(void)
{
	/* Destroy FilePreference */
	gtk_widget_destroy(file_preference->widget);

	/* clear garbage */
	if (file_preference->path){
		g_free(file_preference->path);
	}
	if (file_preference->size){
		g_free(file_preference->size);
	}
	if (file_preference->year){
		g_free(file_preference->year);
	}
	if (file_preference->day){
		g_free(file_preference->day);
	}
	if (file_preference->time){
		g_free(file_preference->time);
	}
	if (file_preference->owner){
		g_free(file_preference->owner);
	}
	if (file_preference->group){
		g_free(file_preference->group);
	}
	file_preference = NULL;
}

static void  
expose_event (GtkWidget *widget, GdkEventExpose *event)
{
	/* rectangle (x, y, width, height) */
	gdk_draw_rectangle((GdkDrawable *) widget->window, widget->style->black_gc, FALSE,
			   65, 8, 150, 66);
	/*  */
	gdk_draw_line((GdkDrawable *) widget->window, widget->style->black_gc,
		      65, 30, 215, 30);
	gdk_draw_line((GdkDrawable *) widget->window, widget->style->black_gc,
		      65, 52, 215, 52);
	/*  */
	gdk_draw_line((GdkDrawable *) widget->window, widget->style->black_gc,
		      115, 8, 115, 74);
	gdk_draw_line((GdkDrawable *) widget->window, widget->style->black_gc,
		      165, 8, 165, 74);

}







