/*
 *    $Id: file_attr.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gdk/gdk.h>
#include <string.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include "d_message.h"
#include "file_attr.h"

char *
parse_size(struct stat *stat)
{
	float     f_size;
	char      *size;
	char      buf[256];

	/* set size */
	if(stat->st_size > 1000 && stat->st_size < 1000000){
		f_size = (float) stat->st_size / 1000;
		sprintf(buf, "%.3fKB",f_size);
		size = (char *) g_malloc(strlen(buf)+1);
		strcpy(size, buf);
	}
	else if (stat->st_size > 1000000){
		f_size = (float) stat->st_size / 1000000;
		sprintf(buf, "%.3fMB",f_size);
		size = (char *) g_malloc(strlen(buf)+1);
		strcpy(size, buf);
	}
	else {
		sprintf(buf, "%dB", (int) stat->st_size);
		size = (char *) g_malloc(strlen(buf)+1);
		strcpy(size, buf);
	}
	
	return size;
}

char *
parse_year(struct stat *stat, int flags)
{
	time_t    now;
	time_t    timet;
	struct tm *tm;
	struct tm *tm_now;
	char      buf[256];
	char      *year;
	int       i_year;
	int       now_year;

	/* get now */
	now = time(NULL);
	tm_now = localtime(&now);
	now_year = tm_now->tm_year;

	/* set time */
	timet = stat->st_ctime;
	tm = localtime(&timet);
	
	/* this solve 2000 year's problem */
	i_year =  (int) tm->tm_year;
	if (flags) {
		if (i_year == now_year){
			return NULL;
		}
	}
	if (i_year < 70){
		sprintf(buf, "20%d", i_year);
	}
	else {
		sprintf(buf, "19%d", i_year);
	}
	year = (char *) g_malloc(strlen(buf) +1);
	strcpy(year, buf);

	return year;
}

char *
parse_month(struct stat *stat,  int flags)
{
	time_t    timet;
	struct tm *tm;
	char      *month = NULL;

	/* set time */
	timet = stat->st_ctime;
	tm = localtime(&timet);

	/* month */
	switch (tm->tm_mon){
	case 0:
		if (flags) {
			month = "JAN";
		}
		else {
			month = "January";
		}
		break;
	case 1:
		if (flags) {
			month = "FEB";
		}
		else {
			month = "February";
		}
		break;
	case 2:
		if (flags) {
			month = "MAR";
		}
		else {
			month = "March";
		}
		break;
	case 3:
		if (flags) {
			month = "APR";
		}
		else {
			month = "April";
		}
		break;
	case 4:
		if (flags) {
			month = "MAY";
		}
		else {
			month = "May";
		}
		break;
	case 5:
		if (flags) {
			month = "JUN";
		}
		else {
			month = "June";
		}
		break;
	case 6:
		if (flags) {
			month = "JUL";
		}
		else {
			month = "July";
		}
		break;
	case 7:
		if (flags) {
			month = "AUG";
		}
		else {
			month = "August";
		}
		break;
	case 8:
		if (flags) {
			month = "SEP";
		}
		else {
			month = "September";
		}
		break;
	case 9:
		if (flags) {
			month = "OCT";
		}
		else {
			month = "October";
		}
		break;
	case 10:
		if (flags) {
			month = "NOV";
		}
		else {
			month = "November";
		}
		break;
	case 11:
		if (flags) {
			month = "DEC";
		}
		else {
			month = "December";
		}
		break;
	default:
		init_dialog_message("We have a invalid case in parse_month.");
		break;
	}

	return month;
}

char *
parse_time(struct stat *stat)
{
	time_t    timet;
	struct tm *tm;
	char      buf_hour[3];
	char      buf_min[3];
	char      *time;

	/* set time */
	timet = stat->st_ctime;
	tm = localtime(&timet);

	/* hour */
	if(tm->tm_hour == 0){
		sprintf(buf_hour, "00");
	}
	else if(tm->tm_hour < 10 ){
		sprintf(buf_hour, "0%d", (int) tm->tm_hour);
	}
	else {
		sprintf(buf_hour, "%d", (int) tm->tm_hour);
	}
	
	/* minits */
	if(tm->tm_min == 0){
		sprintf(buf_min, "00");
	}
	else if(tm->tm_min < 10 ){
		sprintf(buf_min, "0%d", (int) tm->tm_min);
	}
	else {
		sprintf(buf_min, "%d", (int) tm->tm_min);
	}
	time = (char *) g_malloc(6);
	strcpy(time, buf_hour);
	strcat(time, ":");
	strcat(time, buf_min);

	return time;
}

char *
parse_mday(struct stat *stat)
{
	time_t    timet;
	struct tm *tm;
	char      buf[256];
	char      *mday;

	/* set time */
	timet = stat->st_ctime;
	tm = localtime(&timet);

        /* day */
	if (tm->tm_mday < 10) {
		sprintf(buf, " %d", (int) tm->tm_mday);
	}
	else {
		sprintf(buf, "%d", (int) tm->tm_mday);
	}
	mday = (char *) g_malloc(strlen(buf) +1);
	strcpy(mday, buf);
	
	return mday;
}

char *
parse_week(struct stat *stat)
{
	time_t     timet;
	struct tm  *tm;
	char       *week = NULL;

	/* set time */
	timet = stat->st_ctime;
	tm = localtime(&timet);
	
	/* week */
	switch (tm->tm_wday){
	case 0:
		week = "Sunday";
		break;
	case 1:
		week = "Monday";
		break;
	case 2:
		week = "Tuesday";
		break;
	case 3:
		week = "Wednesday";
		break;
	case 4:
		week = "Thursday";
		break;
	case 5:
		week = "Fryday";
		break;
	case 6:
		week = "Saturday";
		break;
	default:
		init_dialog_message("We have a invalid case in parse_week.");
		break;
	}

	return week;
}


int
check_permission(struct stat *stat)
{

	if (stat->st_uid == getuid()) {
		if (stat->st_mode & S_IWUSR) {
			return 0;
		}
		else {
			return 1;
		}
	}
	else if (stat->st_gid == getgid()) {
		if (stat->st_mode & S_IWGRP) {
			return 0;
		}
		else {
			return 1;
		}
	}
	else {
		if (stat->st_mode & S_IWOTH) {
			return 0;
		}
		else {
			return -1;
		}
	}
}





