/*
 *    $Id: dnd.c,v 1.1.1.1 1998/04/21 02:21:27 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */
#ifdef DND

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "pages.h"
#include "files.h"
#include "commands.h"
#include "if_workplace.h"
#include "dnd.h"

static void dnd_drag (GtkWidget *widget, GdkEvent *event);
static void dnd_drop_trayicon (GtkWidget *widget, GdkEvent *event);
static void dnd_drop_workplace (GtkWidget *widget, GdkEvent *event);
static void dnd_dialog_filemanage (char *src);
static void dnd_copy (GtkWidget *widget, char *str1);
static void dnd_move (GtkWidget *widget, char *str1);
static void dnd_link (GtkWidget *widget, char *str1);
static void destroy_dnd_dialog(void);

extern char *current_path;
GtkWidget *dnd_dialog;

void
set_drag (GtkWidget *widget)
{
	char  *dnd_types[] = {"text/plain"};

	/* DND */
	gtk_widget_realize(widget);
	gtk_signal_connect(GTK_OBJECT (widget), "drag_request_event",
			    GTK_SIGNAL_FUNC(dnd_drag), widget);
	gtk_widget_dnd_drag_set(widget, TRUE, dnd_types, 1);
}

void
add_drag (GtkWidget *widget)
{
	char  *dnd_types[] = {"text/plain"};
	
	/* DND */
	gtk_widget_realize(widget);
	gtk_signal_connect(GTK_OBJECT (widget), "drag_request_event",
			   GTK_SIGNAL_FUNC(dnd_drag), widget);
	gtk_widget_dnd_drag_set(widget, TRUE, dnd_types, 0);
	gdk_dnd_drag_addwindow (widget->window);
	
}

void  
set_drop_trayicon (GtkWidget *widget)
{
	char  *dnd_types[] = {"text/plain"};

	/* DND */
	gtk_widget_realize (widget);
	gtk_signal_connect (GTK_OBJECT (widget), "drop_data_available_event",
			    GTK_SIGNAL_FUNC(dnd_drop_trayicon), widget);
	gtk_widget_dnd_drop_set (widget, TRUE, dnd_types, 1, FALSE);
	
}

void  
set_drop_workplace (GtkWidget *widget)
{
	char  *dnd_types[] = {"text/plain"};

	/* DND */
	gtk_widget_realize (widget);
	gtk_signal_connect (GTK_OBJECT (widget), "drop_data_available_event",
			    GTK_SIGNAL_FUNC(dnd_drop_workplace), widget);
	gtk_widget_dnd_drop_set (widget, TRUE, dnd_types, 1, FALSE);
       
}

static char *dnd_string;

static void
dnd_drag (GtkWidget *widget, GdkEvent *event)
{
	GtkWidget  *event_widget;
	FileList   *file = NULL;
	char       *str;
	fprintf(stderr,"DRAG\n");
	//gtk_widget_dnd_drag_add (widget);
	/* get event */
	//event_widget = gtk_get_event_widget((GdkEvent*)event);
	//file = (FileList *) gtk_object_get_user_data(GTK_OBJECT(event_widget));
	
	if (!file || !file->info || !file->info->path || !file->info->name)
		return;

	str = (char *) g_malloc(strlen(file->info->path)+strlen(file->info->name) +1);
	strcpy(str, file->info->path);
	strcat(str, file->info->name);
	//dnd_string = str;
	/* set dnd */
	gtk_widget_dnd_data_set (widget, event, str, strlen(str) + 1);
	//gtk_widget_dnd_data_set (widget, event, NULL, 0);

	g_free(str);
}

static void
dnd_drop_trayicon (GtkWidget *widget, GdkEvent *event)
{
	char *str;
	GtkWidget *event_widget;
	Trayicon  *tray_icon;
	fprintf(stderr,"DROP\n");
	/* set parametor */
	str = (char *) event->dropdataavailable.data;

	/* get event */
	event_widget = gtk_get_event_widget((GdkEvent*)event);
	tray_icon = (Trayicon *) gtk_object_get_user_data(GTK_OBJECT(event_widget));

	/* command */
	wp_exec(tray_icon->cmd, tray_icon->args, str,tray_icon->dnd);
}

static void
dnd_drop_workplace (GtkWidget *widget, GdkEvent *event)
{
	char *str;
	char *filename;

	/* get filename */
	str = (char *) event->dropdataavailable.data;
	if (!str)
		return;

	/* set filename */
	filename = (char *)g_malloc(strlen(str)+1);
	memset((char *)filename, 0, strlen(str)+1);
	strcpy(filename, str);

	/* dialog */
	dnd_dialog_filemanage(filename);
}

static void
dnd_dialog_filemanage (char *src)
{
	GtkWidget *main_box;
	GtkWidget *button;

	if(!dnd_dialog) {
	
		/* Create the main window */
		dnd_dialog = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_container_border_width(GTK_CONTAINER(dnd_dialog), 10);
		gtk_window_set_title(GTK_WINDOW(dnd_dialog), "File manage");
		gtk_window_position(GTK_WINDOW(dnd_dialog), GTK_WIN_POS_CENTER);
		gtk_signal_connect(GTK_OBJECT(dnd_dialog), "delete_event",
				   GTK_SIGNAL_FUNC(destroy_dnd_dialog), NULL);

		/* Create a container to hold everything */
		main_box = gtk_vbox_new(FALSE, 6);
		gtk_container_add(GTK_CONTAINER(dnd_dialog), main_box);
		gtk_widget_show(main_box);

		/*  The button  */
		button = gtk_button_new_with_label(" Copy ");
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(dnd_copy), src);
		gtk_box_pack_start(GTK_BOX(main_box), button, TRUE, TRUE, 0);
		gtk_widget_show(button);

		/*  The button  */
		button = gtk_button_new_with_label(" Move ");
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(dnd_move), src);
		gtk_box_pack_start(GTK_BOX(main_box), button, TRUE, TRUE, 0);
		gtk_widget_show(button);

		/*  The button  */
		button = gtk_button_new_with_label(" Symbolic link ");
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(dnd_link), src);
		gtk_box_pack_start(GTK_BOX(main_box), button, TRUE, TRUE, 0);
		gtk_widget_show(button);

		/*  The button  */
		button = gtk_button_new_with_label(" cancel ");
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				   GTK_SIGNAL_FUNC(destroy_dnd_dialog), NULL);
		gtk_box_pack_start(GTK_BOX(main_box), button, TRUE, TRUE, 0);
		gtk_widget_show(button);
	}
	if (!GTK_WIDGET_VISIBLE(dnd_dialog)){
		/* show all */
		gtk_widget_show(dnd_dialog);
	}
}

static void
dnd_copy (GtkWidget *widget, char *str1)
{
	char  *tmp1;
	char  *tmp2;
	char  *str2;

	tmp1 = (char *) g_malloc(strlen(str1));
	memset((char *) tmp1, 0, strlen(str1));
	strcpy(tmp1, str1);

	tmp2 = strrchr(tmp1, '/');
	
	str2 = (char *) g_malloc(strlen(current_path)+strlen(tmp2+1)+1);
	strcpy(str2, current_path);
	strcat(str2, tmp2+1);
	g_free(tmp1);

	if (strcmp(str1, str2) != 0) {
		wp_copy(str1, str2);

                /* display files */
		display_files (current_path, BY_NAME);
	}
	g_free(str1);

	destroy_dnd_dialog();
}

static void
dnd_move (GtkWidget *widget, char *str1)
{
	char  *tmp1;
	char  *tmp2;
	char  *str2;

	tmp1 = (char *) g_malloc(strlen(str1));
	memset((char *) tmp1, 0, strlen(str1));
	strcpy(tmp1, str1);

	tmp2 = strrchr(tmp1, '/');
	
	str2 = (char *) g_malloc(strlen(current_path)+strlen(tmp2+1)+1);
	strcpy(str2, current_path);
	strcat(str2, tmp2+1);
	g_free(tmp1);
	
	if (strcmp(str1, str2) != 0) {
		wp_move(str1, str2);
		/* display files */
		display_files (current_path, BY_NAME);
	}
	g_free(str1);

	destroy_dnd_dialog();
}

static void
dnd_link (GtkWidget *widget, char *str1)
{
	char  *tmp1;
	char  *tmp2;
	char  *str2;

	tmp1 = (char *) g_malloc(strlen(str1));
	memset((char *) tmp1, 0, strlen(str1));
	strcpy(tmp1, str1);

	tmp2 = strrchr(tmp1, '/');
	
	str2 = (char *) g_malloc(strlen(current_path)+strlen(tmp2+1)+1);
	strcpy(str2, current_path);
	strcat(str2, tmp2+1);
	g_free(tmp1);

	if (strcmp(str1, str2) != 0) {
		wp_link(str1, str2);

		/* display files */
		display_files (current_path, BY_NAME);
	}
	g_free(str1);

	destroy_dnd_dialog();
}

static void
destroy_dnd_dialog (void)
{
	/* Destroy dnd dialog */
	gtk_widget_destroy(dnd_dialog);
	dnd_dialog = NULL;
}


#endif





