/*
 *    $Id: d_message.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include "d_message.h"
#include "HandOpen.xpm"
#define PIXMAP_DATA HandOpen_xpm

#define MESSAGE_DIALOG_WIDTH 300
#define MESSAGE_DIALOG_HEIGHT 200


static void destroy_dialog_message1(GtkWidget *widget);
static void destroy_dialog_message2(GtkWidget *widget, GtkWidget *window);
	
static char *message_stack[16];
static int  message_index = 0;

void 
init_dialog_message (char *str)
{		
	int i;

	if (GTK_WIDGET_VISIBLE(Mainwindow)){
		if (message_index > 0) {
			for (i=0;i<message_index;i++){
				create_dialog_message(message_stack[i]);
				gdk_beep();
			}
			message_index = 0;
			if (str) {
				create_dialog_message(str);	
				gdk_beep();
			}
		}
		else {
			if (str) {
				create_dialog_message(str);	
				gdk_beep();
			}
		}
	}
	else {
		if (message_index > 16){
			message_index = 0;
		}
		message_stack[message_index] = str;
		message_index++;
	}
}

void 
create_dialog_message (char *str)
{
	GtkWidget   *window;
	GtkWidget   *main_box;
	GtkWidget   *vbox;
	GtkWidget   *pixmap;
	GtkWidget   *label;
	GtkWidget   *separator;
	GtkWidget   *hbox;
	GtkWidget   *ok_button;
	GdkPixmap   *pixmap_data = NULL;
	GdkBitmap   *mask;
	GtkStyle    *style;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();

	/* set style */
	style = gtk_style_new();
	style->font = gdk_font_load ("-adobe-times-medium-*-*--*-160-*-*-*-*-*-*");
	

	/* Create the main window */
	window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_widget_set_usize(window, MESSAGE_DIALOG_WIDTH, MESSAGE_DIALOG_HEIGHT);
	gtk_window_set_title(GTK_WINDOW(window), "Message");
	gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
			   GTK_SIGNAL_FUNC(destroy_dialog_message1), NULL);
	gtk_widget_show(window);

	/* Create a container to hold everything */
	main_box = gtk_vbox_new(FALSE, 4);
	gtk_container_add(GTK_CONTAINER(window), main_box);
	gtk_widget_show(main_box);

        /* box */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(vbox), 10);
	gtk_box_pack_start(GTK_BOX (main_box), vbox, TRUE, TRUE, 0);
	gtk_widget_show(vbox);	

	
	/* message type box */
	hbox = gtk_hbox_new(FALSE, 14);
	gtk_box_pack_start(GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	/* pixmap */
	pixmap_data = gdk_pixmap_colormap_create_from_xpm_d(NULL, cmap, &mask, 
							    &style->bg[GTK_STATE_NORMAL],
							    PIXMAP_DATA);
	
	if (pixmap_data) {
		pixmap = gtk_pixmap_new(pixmap_data, mask);
		gtk_box_pack_start(GTK_BOX (hbox), pixmap, FALSE, FALSE, 0);
		gtk_widget_show(pixmap);
	}

	/* label */
	label = gtk_label_new("Warning !");
	gtk_widget_set_style(label, style);
	gtk_box_pack_start(GTK_BOX (hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	/* label */
	label = gtk_label_new(str);
	gtk_box_pack_start(GTK_BOX (vbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);

	/*separator*/
	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (main_box), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);
	
	/* box */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 10);
	gtk_box_pack_start(GTK_BOX (main_box), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);
	
	/*  The OK button  */
	ok_button = gtk_button_new_with_label(" OK ");
	GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(ok_button);
	gtk_signal_connect(GTK_OBJECT(ok_button), "clicked",
			   GTK_SIGNAL_FUNC(destroy_dialog_message2), window);
	gtk_box_pack_end(GTK_BOX(hbox), ok_button, FALSE, FALSE, 0);
	gtk_widget_show(ok_button);

}

static void 
destroy_dialog_message1 (GtkWidget *widget)
{	
	/* Destroy Message */
	gtk_widget_hide(widget);
}

static void 
destroy_dialog_message2 (GtkWidget *widget, GtkWidget *window)
{	
	/* Destroy Message */
	gtk_widget_hide(window);
}




