/*
 *    $Id: commands.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <utime.h>
#include <fcntl.h>
#include "d_message.h"
#include "commands.h"

void 
wp_exec(char *str1, char *str2, char *str3, Boolen dnd)
{
	char *cmd;
	char *buf;

	if (str1){
		if (str2) {
			cmd = (char *) g_malloc(strlen(str1)+ strlen(str2) +2);
			strcpy(cmd, str1);
			strcat(cmd, " ");
			strcat(cmd, str2);
		}
		else {
			cmd = (char *) g_malloc(strlen(str1)+1);
			strcpy(cmd, str1);
		}
	}
	else {
		init_dialog_message("We get a void command.");
		return;
	}

	/* if DND */
	if (dnd == YES) {
		if (str3) {
			buf = cmd;
			cmd = (char *) g_malloc(strlen(buf)+ strlen(str3) +2);
			strcpy(cmd, buf);
			strcat(cmd, " ");
			strcat(cmd, str3);
			g_free(buf);
		}
	}

	/* fork */
	if (fork() == 0) {
		execl("/bin/sh", "sh", "-c", cmd, 0);
	}
	g_free(cmd);
}

void 
wp_copy (char *src, char *dest) 
{
	struct utimbuf tv;
	struct stat    *st;
	int            in_fd;
        int            out_fd;
        char           buf[1024 * 8];
        int            len;
		
	st = (struct stat *) g_malloc(sizeof(struct stat));
	/* get  information of a file represented by pathname */
	if (stat(src, st) == -1){
		if (lstat(src, st) == -1) {
			g_free(src);
			g_free(st);
			return;
		}
	}

	
	/* input */
	in_fd = open(src,  O_RDONLY, 0);
	if (in_fd < 0) {
		close(in_fd);
		init_dialog_message("We cannot open.");
		return;
	}

	/* out put */
	out_fd = open(dest,  O_WRONLY | O_CREAT | O_TRUNC, 0600);
	if (out_fd < 0) {
		close(out_fd);
		init_dialog_message("We can't open.");
		return;
	}
		
	while (1) {
		len = read(in_fd, buf, sizeof(buf));
		if (len <= 0){
			break;
		}

		if (write(out_fd, buf, len) < 0) {
			close(in_fd);
			close(out_fd);
			return;
		}
	}
	close(in_fd);
	close(out_fd);

	/* set time */
	tv.actime = st->st_atime;
	tv.modtime = st->st_mtime;
	if (utime(dest, &tv)) {
		init_dialog_message("We cannot change time.");
		return;
	}

	chown(dest, st->st_uid, st->st_gid);
	chmod(dest, st->st_mode & 07777);
}

void 
wp_move (char *src, char *dest) 
{
	struct utimbuf tv;
	struct stat    *st;
	int            in_fd;
        int            out_fd;
        char           buf[1024 * 8];
        int            len;

	st = (struct stat *) g_malloc(sizeof(struct stat));
	/* get  information of a file represented by pathname */
	if (stat(src, st) == -1){
		if (lstat(src, st) == -1) {
			g_free(src);
			g_free(st);
			return;
		}
	}

	
	/* input */
	in_fd = open(src,  O_RDONLY, 0);
	if (in_fd < 0) {
		close(in_fd);
		init_dialog_message("We cannot open.");
		return;
	}

	/* out put */
	out_fd = open(dest,  O_WRONLY | O_CREAT | O_TRUNC, 0600);
	if (out_fd < 0) {
		close(out_fd);
		init_dialog_message("We can't open.");
		return;
	}
		
	while (1) {
		len = read(in_fd, buf, sizeof(buf));
		if (len <= 0){
			break;
		}

		if (write(out_fd, buf, len) < 0) {
			close(in_fd);
			close(out_fd);
			return;
		}
	}
	close(in_fd);
	close(out_fd);

	/* set time */
	tv.actime = st->st_atime;
	tv.modtime = st->st_mtime;
	if (utime(dest, &tv)) {
		init_dialog_message("We cannot change time.");
		return;
	}

	chown(dest, st->st_uid, st->st_gid);
	chmod(dest, st->st_mode & 07777);

	/* change name */
	rename(src, dest);
}

void 
wp_link (char *src, char *dest)
{
	fprintf(stderr,"#%s:%s\n",dest,src);
	symlink(src, dest);
}




