/*
 *    $Id: app_preference.c,v 1.1.1.1 1998/04/21 02:21:26 hideki Exp $
 *    This file is a part of the Workplace.
 *    Copyright (C) 1997, 1998  Hideki Fujimoto.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include "Workplace.h"
#include "main.h"
#include "d_message.h"
#include "preferences.h"
#include "interface.h"
#include "commands.h"
#include "pages.h"
#include "if_launcher.h"
#include "gui_preference.h"
#include "pref_launcher.h"
#include "app_preference.h"

#define FILE_LIST_WIDTH  180
#define FILE_LIST_HEIGHT 120

static void init_trayicon_parts(GtkWidget *box);
static void init_pixmap_parts (GtkWidget *box);
static void init_cmd_parts (GtkWidget *parent);
static void change_name (GtkWidget * widget, gpointer data);
static void change_xpm (GtkWidget  *widget, GdkEventButton *event);
static void change_cmd (GtkWidget *widget, gpointer data);
static void change_args (GtkWidget *widget, gpointer data);
static void radio_on (void);
static void radio_off (void);
static void undo_new_trayicon (void);
static void do_modify(void);
static void do_new_trayicon(void);
static void undo_new_trayicon (void);
static void real_modify_trayicon (void);
static void real_new_trayicon (void);
static void real_remove_trayicon (void);
static char *clean_string (char *str);
static int sort_by_name (const char **file1, const char **file2);


extern GtkWidget *preference_window;
extern NewTrayIcon *new_trayicon;
extern NewTrayIcon *new_trayicon_p;
extern RemovedTrayIcon *removed_trayicon;
extern RemovedTrayIcon *removed_trayicon_p;
extern ModifiedTrayIcon *modified_trayicon;
extern ModifiedTrayIcon *modified_trayicon_p;
extern GdkColor removed_color;

SLL *image_files; 
GtkWidget *ticon_tmp_widget;
NewTrayIcon *trayicon_tmp;

static GtkWidget *pixmap;
static GtkWidget *pixmap_box;
static GtkWidget *name_entry;
static GtkWidget *image_name;

static Trayicon *trayicon_current;
static char *app_name;
static char *app_image;
static char *app_cmd;
static char *app_args;
static Boolen app_dnd;
static Boolen flags_new = NO;
static Boolen flags_modify = NO;


GtkWidget *
init_AppPreference(GtkWidget *parent, Trayicon *ticon)
{
	GtkWidget         *main_box;
	GtkWidget         *name_box1;
	GtkWidget         *name_box2;
	GtkWidget         *name_box3;
	GtkWidget         *name_label;
	GtkWidget         *separator;
	GtkWidget         *image_box;
	ModifiedTrayIcon  *buf;

	if (ticon) {
		if (modified_trayicon) {
			buf = modified_trayicon;
			while (1) {
				if (!buf) {
					app_name  = ticon->name;
					app_image = ticon->image;
					app_cmd   = ticon->cmd;
					app_args  = ticon->args;
					trayicon_current = ticon;
					flags_modify = NO;
					break;
				}
				else {
					if (buf->origin == ticon) {
						app_name  = buf->ticon->name;
						app_image = buf->ticon->image;
						app_cmd   = buf->ticon->cmd;
						app_args  = buf->ticon->args;
						trayicon_current = buf->ticon;
						flags_modify = YES;
						break;
					}
					buf = buf->next;
				}
			}
		}
		else {
			app_name  = ticon->name;
			app_image = ticon->image;
			app_cmd   = ticon->cmd;
			app_args  = ticon->args;
			trayicon_current = ticon;
			flags_modify = NO;
		}
	}
	else {
		return NULL;
	}

	/* Create a container to hold everything */
	main_box = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX (parent), main_box, TRUE, TRUE, 0);
	gtk_widget_show(main_box);
	
	
	/* a part of application name  */
	/* name label */
	name_box1 = gtk_hbox_new(FALSE, 10);
	gtk_container_border_width(GTK_CONTAINER(name_box1), 10);
	gtk_box_pack_start(GTK_BOX (main_box), name_box1, FALSE, FALSE, 0);
	gtk_widget_show(name_box1);
	
	name_box2 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX (name_box1), name_box2, TRUE, TRUE, 0);
	gtk_widget_show(name_box2);
	
	name_box3 = gtk_vbox_new(FALSE, 2);
	gtk_box_pack_end(GTK_BOX (name_box2), name_box3, FALSE, FALSE, 0);
	gtk_widget_show(name_box3);
	
	name_label = gtk_label_new("Name:");
	gtk_misc_set_alignment (GTK_MISC (name_label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX (name_box3), name_label, FALSE, FALSE, 0);
	gtk_widget_show(name_label);
	
	/* name entry */
	name_entry = gtk_entry_new();
	if (app_name){
		gtk_entry_set_text(GTK_ENTRY(name_entry), app_name);
	}
	gtk_signal_connect(GTK_OBJECT(name_entry), "changed",
			   GTK_SIGNAL_FUNC(change_name), NULL);
	gtk_box_pack_start(GTK_BOX (name_box3), name_entry, TRUE, TRUE, 0);
	gtk_widget_show(name_entry);
	
	/*separator*/
	separator = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (main_box), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);
	
	/* a part of application pixmap */
	image_box = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX (main_box), image_box, TRUE, TRUE, 0);
	gtk_widget_show(image_box);
	init_pixmap_parts(image_box);
	
	/*separator*/
	separator = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (main_box), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);
	
	/* a part of application command  */
	init_cmd_parts(main_box);

	return main_box;
}

void 
destroy_AppPreference(GtkWidget *widget)
{
	/* Destroy AppPreference */
	gtk_widget_destroy(widget);
}

void
check_AppPreference(void)
{
	/* remove the top and end of spaces */
	app_name = clean_string(app_name);
	app_cmd  = clean_string(app_cmd);
	app_args  = clean_string(app_args);

	
	if (flags_new == YES) { /* new */
		if (!app_name && !app_cmd ) {
			undo_new_trayicon();
		}
		else {
			do_new_trayicon();
		}
	}
	else if (flags_modify == NO) { /* modify */
		/* check */
		if (trayicon_current) {
			if (app_name) {
				if (strcmp(app_name,trayicon_current->name) == 0)
					;
				else 
					do_modify();
			}
			else {
				if (trayicon_current->name == NULL)
			       ;
				else 
					do_modify();
			}
			if (app_image) {
				if (trayicon_current->image) {
					if (strcmp(app_image,trayicon_current->image) == 0)
						;
					else 
						do_modify();
				}
				else {
					do_modify();
				}
			}
			else {
				if (trayicon_current->image == NULL)
					;
				else 
					do_modify();
			}
			if (app_cmd) {
				if (strcmp(app_cmd,trayicon_current->cmd) == 0)
					;
				else 
					do_modify();
			}
			else {
				if (trayicon_current->cmd == NULL)
					;
				else
					do_modify();
			}
			if (app_args) {
				if (trayicon_current->args) {
					if (strcmp(app_args,trayicon_current->args) == 0)
						;
					else 
						do_modify();
				}
				else {
					do_modify();
				}
			}
			else {
				if (trayicon_current->args == NULL)
					;
				else 
					do_modify();
			}
			if (app_dnd != trayicon_current->dnd)
				do_modify();
		}
	}
	else if (flags_modify == YES) {
		/* check */
		if (app_name) {
			if (strcmp(app_name,trayicon_current->name) == 0)
				;
			else 
				do_modify();
		}
		else {
		       if (trayicon_current->name == NULL)
			       ;
		       else 
			       do_modify();
		}
		if (app_image) {
			if (trayicon_current->image) {
				if (strcmp(app_image,trayicon_current->image) == 0)
					;
				else 
					do_modify();
			}
			else {
				do_modify();
			}
		}
		else {
			if (trayicon_current->image == NULL)
				;
			else 
				do_modify();
		}
		if (app_cmd) {
			if (strcmp(app_cmd,trayicon_current->cmd) == 0)
				;
			else 
				do_modify();
		}
		else {
			if (trayicon_current->cmd == NULL)
				;
			else
				do_modify();
		}
		if (app_args) {
			if (trayicon_current->args) {
				if (strcmp(app_args,trayicon_current->args) == 0)
					;
				else 
					do_modify();
			}
			else {
				do_modify();
			}
		}
		else {
			if (trayicon_current->args == NULL)
				;
			else 
				do_modify();
		}
		if (app_dnd != trayicon_current->dnd)
			do_modify();
	}
}

void
cancel_AppPreference (void)
{
	NewTrayIcon       *buf_n_ticon;
	NewTrayIcon       *garbage_n_ticon;
	RemovedTrayIcon   *buf_r_ticon;
	RemovedTrayIcon   *garbage_r_ticon;
	ModifiedTrayIcon  *buf_ticon;
	ModifiedTrayIcon  *garbage_ticon;

	if (new_trayicon) {
		buf_n_ticon = new_trayicon;
		while (1) {
			if (!buf_n_ticon) {
				break;
			}
			garbage_n_ticon = buf_n_ticon;
			if (garbage_n_ticon->ticon->name) {
				g_free(garbage_n_ticon->ticon->name);
				garbage_n_ticon->ticon->name = NULL;
			}
			if (garbage_n_ticon->ticon->image) {
				g_free(garbage_n_ticon->ticon->image);
				garbage_n_ticon->ticon->image = NULL;
			}
			if (garbage_n_ticon->ticon->cmd) {
				g_free(garbage_n_ticon->ticon->cmd);
				garbage_n_ticon->ticon->cmd = NULL;
			}
			if (garbage_n_ticon->ticon->args) {
				g_free(garbage_n_ticon->ticon->args);
				garbage_n_ticon->ticon->args = NULL;
			}
			buf_n_ticon = buf_n_ticon->next;
			
			g_free(garbage_n_ticon);
		}
	}

	if (removed_trayicon) {
		buf_r_ticon = removed_trayicon;
		while (1) {
			if (!buf_r_ticon) {
				break;
			}
			garbage_r_ticon = buf_r_ticon;
			buf_r_ticon = buf_r_ticon->next;
			g_free(garbage_r_ticon);
		}
	}
	
	if (modified_trayicon) {
		buf_ticon = modified_trayicon;
		while (1) {
			if (!buf_ticon) {
				break;
			}
			garbage_ticon = buf_ticon;
			if (garbage_ticon->ticon->name) {
				g_free(garbage_ticon->ticon->name);
				garbage_ticon->ticon->name = NULL;
			}
			if (garbage_ticon->ticon->image) {
				g_free(garbage_ticon->ticon->image);
				garbage_ticon->ticon->image = NULL;
			}
			if (garbage_ticon->ticon->cmd) {
				g_free(garbage_ticon->ticon->cmd);
				garbage_ticon->ticon->cmd = NULL;
			}
			if (garbage_ticon->ticon->args) {
				g_free(garbage_ticon->ticon->args);
				garbage_ticon->ticon->args = NULL;
			}
			buf_ticon = buf_ticon->next;

			g_free(garbage_ticon);
		}
	}
}

void
save_AppPreference (void)
{	
	check_AppPreference();

	/* modify trayicons */
	if (modified_trayicon) {
		real_modify_trayicon();
	}

	/* remove trayicons */
	if (removed_trayicon) {
		real_remove_trayicon();
	}

        /* new trayicons */
	if (new_trayicon) {
		real_new_trayicon();
	}
}

void
free_AppPreference(void)
{
	ticon_tmp_widget = NULL;
	trayicon_tmp = NULL;
	pixmap = NULL;
	name_entry = NULL;
	image_name = NULL;
	trayicon_current = NULL;
	app_name = NULL;
	app_image = NULL;
	app_cmd = NULL;
	app_args = NULL;
	flags_new = NO;
	flags_modify = NO;
}

static void
real_modify_trayicon (void)
{
	ModifiedTrayIcon  *buf_app;
	ModifiedTrayIcon  *garbage_app;
	GtkWidget         *pixmap;
	GdkPixmap         *pixmap_data;
	GdkBitmap         *mask;
	GtkStyle          *style;
	char              *pathname;
	GdkColormap       *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();

	buf_app = modified_trayicon;
	while (1) {
		if (!buf_app) {
			break;
		}
		
		/* name */
		if (buf_app->origin->name) {
			if (buf_app->ticon->name) {
				if (strcmp(buf_app->origin->name, buf_app->ticon->name) != 0) {
					g_free(buf_app->origin->name);
					buf_app->origin->name = buf_app->ticon->name;
					gtk_label_set(GTK_LABEL(buf_app->origin->gw_name), 
						      buf_app->ticon->name);
				}
			}
			else {
				g_free(buf_app->origin->name);
				buf_app->origin->name = NULL;
				gtk_label_set (GTK_LABEL(buf_app->origin->gw_name), "");
			}
		}
		else {
			if (buf_app->ticon->name) {
				buf_app->origin->name = buf_app->ticon->name;
				gtk_label_set(GTK_LABEL(buf_app->origin->gw_name), 
					      buf_app->ticon->name);
			}
			else {
				buf_app->origin->name = NULL;
				gtk_label_set (GTK_LABEL(buf_app->origin->gw_name), "");
			}
		}
		
		/* image */
		if (buf_app->origin->image) {
			if (buf_app->ticon->image) {
				if (strcmp(buf_app->origin->image, buf_app->ticon->image) != 0) {
					/* make path */
					pathname = (char *) g_malloc(strlen(Preferences->icon_path)
								     +strlen(buf_app->ticon->image)+2);
					strcpy(pathname, Preferences->icon_path);
					strcat(pathname, "/");
					strcat(pathname, buf_app->ticon->image);
					
					/* set */
					g_free(buf_app->origin->image);
					buf_app->origin->image = buf_app->ticon->image;
					
					/* set pixmap */
					if (GTK_WIDGET_VISIBLE(buf_app->origin->gw_image)){
						gtk_widget_hide(buf_app->origin->gw_image);
					}
					/* set style */
					style = gtk_widget_get_style(buf_app->origin->gw_image->parent);
					pixmap_data = gdk_pixmap_colormap_create_from_xpm
						(NULL, cmap,&mask, &style->bg[GTK_STATE_NORMAL],
						 pathname);
					if (pixmap_data) {
						gtk_pixmap_set(GTK_PIXMAP(buf_app->origin->gw_image),
							       pixmap_data, mask);
					}
					gtk_widget_show(buf_app->origin->gw_image);
					
					/* free */
					g_free(pathname);
				}
			}
			else {
				g_free(buf_app->origin->image);
				buf_app->origin->image = NULL;
				/*# I should add here*/
			}
		}
		else {
			if (buf_app->ticon->image) {
				buf_app->origin->image = buf_app->ticon->image;
				/* make path */
				pathname = (char *) g_malloc(strlen(Preferences->icon_path)
							     +strlen(buf_app->ticon->image)+2);
				strcpy(pathname, Preferences->icon_path);
				strcat(pathname, "/");
				strcat(pathname, buf_app->ticon->image);
				
				/* set */
				buf_app->origin->image = buf_app->ticon->image;
				
				/* set pixmap */
				style = gtk_widget_get_style(preference_window);
				pixmap_data = gdk_pixmap_colormap_create_from_xpm
					(NULL, cmap,&mask, &style->bg[GTK_STATE_NORMAL], pathname);

				if (pixmap_data) {
					pixmap = gtk_pixmap_new(pixmap_data, mask);
					gtk_signal_connect_object(GTK_OBJECT(pixmap), "destroy",
								  GTK_SIGNAL_FUNC(gtk_widget_destroy),
								  NULL);
					gtk_box_pack_start(GTK_BOX(buf_app->origin->box), pixmap,
							   FALSE, FALSE, 0);
					/* set widget */
					buf_app->origin->gw_image = pixmap;
				}
				gtk_widget_show(buf_app->origin->gw_image);
				
				/* free */
				g_free(pathname);
			}
			else {
				buf_app->origin->image = NULL;
				/*# I should add here*/
			}
		}

		/* command */
		if (buf_app->origin->cmd) {
			if (buf_app->ticon->cmd) {
				if (strcmp(buf_app->origin->cmd, buf_app->ticon->cmd) != 0) {
					g_free(buf_app->origin->cmd);
					buf_app->origin->cmd = buf_app->ticon->cmd;
				}
			}
			else {
				g_free(buf_app->origin->cmd);
				buf_app->origin->cmd = NULL;
				/*# I should add here*/
			}
		}
		else {
			if (buf_app->ticon->cmd) {
				buf_app->origin->cmd = buf_app->ticon->cmd;
			}
			else {
				buf_app->origin->cmd = NULL;
				/*# I should add here*/
			}
		}
		
		/* args */
		if (buf_app->origin->args) {
			if (buf_app->ticon->args) {
				if (strcmp(buf_app->origin->args, buf_app->ticon->args) != 0) {
					g_free(buf_app->origin->args);
					buf_app->origin->args = buf_app->ticon->args;
				}
			}
			else {
				g_free(buf_app->origin->args);
				buf_app->origin->args = NULL;
			}
		}
		else {
			if (buf_app->ticon->args) {
				buf_app->origin->args = buf_app->ticon->args;
			}
			else {
				buf_app->origin->args = NULL;
			}
		}
		
		/* dnd */
		buf_app->origin->dnd = buf_app->ticon->dnd;
		
		/* next */
		garbage_app = buf_app;
		buf_app = buf_app->next;
		g_free(garbage_app);
	}
}

static void
real_new_trayicon(void)
{
	NewTrayIcon  *buf_new_ticon;
	Trayicon     *buf_ticon;

	buf_new_ticon = new_trayicon;
	while (1) {
		if (!buf_new_ticon) {
			break;
		}
		else {
			buf_ticon = buf_new_ticon->ticon->page->ticon;
			if (buf_ticon) {
				while (1) {
					if(!buf_ticon->next) {
						buf_ticon->next = buf_new_ticon->ticon;
						add_trayicon(buf_new_ticon->ticon);
						break;
					}
					buf_ticon = buf_ticon->next;
				}
			}
			else {
				buf_new_ticon->ticon->page->ticon = buf_new_ticon->ticon;
				add_trayicon(buf_new_ticon->ticon);
			}
			buf_new_ticon = buf_new_ticon->next;
		}
	}
}

static void
real_remove_trayicon(void)
{
	RemovedTrayIcon *buf_removed_ticon;
	RemovedTrayIcon *garbage_removed_ticon;
	Trayicon        *buf_ticon;

	/* remove trayicons */
	buf_removed_ticon = removed_trayicon;

	while (1) {
		if (!buf_removed_ticon) {
			break;
		}
		buf_ticon = buf_removed_ticon->ticon->page->ticon;
		if (!buf_ticon){
			break;
		}
		else if (buf_ticon == buf_removed_ticon->ticon) {
				buf_removed_ticon->ticon->page->ticon = buf_ticon->next;
				if (buf_ticon->name)
					g_free(buf_ticon->name);
				if (buf_ticon->image)
					g_free(buf_ticon->image);
				if (buf_ticon->cmd)
					g_free(buf_ticon->cmd);
				if (buf_ticon->args)
					g_free(buf_ticon->args);
				gtk_widget_destroy(buf_ticon->button);
				g_free(buf_ticon);
		}
		else {
			while (1) {
				if (!buf_ticon->next) {
					if (buf_ticon == buf_removed_ticon->ticon->page->ticon) {
						buf_removed_ticon->ticon->page->ticon = NULL;
						if (buf_ticon->name)
							g_free(buf_ticon->name);
						if (buf_ticon->image)
							g_free(buf_ticon->image);
						if (buf_ticon->cmd)
							g_free(buf_ticon->cmd);
						if (buf_ticon->args)
							g_free(buf_ticon->args);
						gtk_widget_destroy(buf_ticon->button);
						g_free(buf_ticon);
					}
					break;
				}
				else if (buf_ticon->next == buf_removed_ticon->ticon) {
					buf_ticon->next = buf_removed_ticon->ticon->next;
					
					if (buf_removed_ticon->ticon->name)
						g_free(buf_removed_ticon->ticon->name);
					if (buf_removed_ticon->ticon->image)
						g_free(buf_removed_ticon->ticon->image);
					if (buf_removed_ticon->ticon->cmd)
						g_free(buf_removed_ticon->ticon->cmd);
					if (buf_removed_ticon->ticon->args)
						g_free(buf_removed_ticon->ticon->args);
					gtk_widget_destroy(buf_removed_ticon->ticon->button);
					g_free(buf_removed_ticon->ticon);
					break;
				}
				else {
					buf_ticon = buf_ticon->next;
				}
			}
		}
		garbage_removed_ticon = buf_removed_ticon;
		buf_removed_ticon = buf_removed_ticon->next;
		g_free(garbage_removed_ticon);
	}
}

static void
do_modify(void)
{
	ModifiedTrayIcon  *p;
	/* allocation */
	if (flags_new == YES) {
		if (app_name) {
			new_trayicon_p->ticon->name = (char *) g_malloc(strlen(app_name)+1);
			strcpy(new_trayicon_p->ticon->name, app_name);
		} 
		else {
			new_trayicon_p->ticon->name = NULL;
		}
		
		if (app_image) {
			new_trayicon_p->ticon->image = (char *) g_malloc(strlen(app_image)+1);
			strcpy(new_trayicon_p->ticon->image, app_image);
		}
		else {
			new_trayicon_p->ticon->image = NULL;
		}
		
		if (app_cmd) {
			new_trayicon_p->ticon->cmd = (char *) g_malloc(strlen(app_cmd)+1);
			strcpy(new_trayicon_p->ticon->cmd, app_cmd);
		} 
		else {
			new_trayicon_p->ticon->cmd = NULL;
		}
		
		if (app_args) {
			new_trayicon_p->ticon->args = (char *) g_malloc(strlen(app_args)+1);
			strcpy(new_trayicon_p->ticon->args, app_args);
		} 
		else {
			new_trayicon_p->ticon->args = NULL;
		}
		
		new_trayicon_p->ticon->dnd = app_dnd;
		gtk_label_set(GTK_LABEL(new_trayicon_p->ticon->gw_name_pref),
			      new_trayicon_p->ticon->name);
	}
	else if (flags_modify == YES) {
		/* set value */
		if (app_name) {
                        if (trayicon_current->name) {
                                g_free(trayicon_current->name);
                        }
                        trayicon_current->name = (char *) g_malloc(strlen(app_name)+1);
                        strcpy(trayicon_current->name, app_name);
                } 
                else {
                        if (trayicon_current->name) {
                                g_free(trayicon_current->name);
                        }
                        trayicon_current->name = NULL;
                }
                
                if (app_image) {
                        if (trayicon_current->image) {
                                g_free(trayicon_current->image);
                        }
                        trayicon_current->image = (char *) g_malloc(strlen(app_image)+1);
                        strcpy(trayicon_current->image, app_image);
                }
                else {
                        if (trayicon_current->image) {
                                g_free(trayicon_current->image);
                        }
                        trayicon_current->image = NULL;
                }
		if (app_cmd) {
                        if (trayicon_current->cmd) {
                                g_free(trayicon_current->cmd);
                        }
                        trayicon_current->cmd = (char *) g_malloc(strlen(app_cmd)+1);
                        strcpy(trayicon_current->cmd, app_cmd);
                } 
                else {
                        if (trayicon_current->cmd) {
                                g_free(trayicon_current->cmd);
                        }
                        trayicon_current->cmd = NULL;
                }
                if (app_args) {
                        if (trayicon_current->args) {
                                g_free(trayicon_current->args);
                        }
                        trayicon_current->args = (char *) g_malloc(strlen(app_args)+1);
                        strcpy(trayicon_current->args, app_args);
                } 
                else {
                        if (trayicon_current->args) {
                                g_free(trayicon_current->args);
                        }
                        trayicon_current->args = NULL;
                }
                trayicon_current->dnd = app_dnd;
                /*trayicon_m = NULL;*/
		
	}
	else {
		p = (ModifiedTrayIcon *) g_malloc(sizeof(ModifiedTrayIcon));
		p->next = NULL;
		p->origin = trayicon_current;
		p->ticon = (Trayicon *) g_malloc(sizeof(Trayicon));
		
		/* set value */
		if (app_name) {
			p->ticon->name = (char *) g_malloc(strlen(app_name)+1);
			strcpy(p->ticon->name, app_name);
		} 
		else {
			p->ticon->name = NULL;
		}
		
		if (app_image) {
			p->ticon->image = (char *) g_malloc(strlen(app_image)+1);
			strcpy(p->ticon->image, app_image);
		}
		else {
			p->ticon->image = NULL;
		}
		
		if (app_cmd) {
			p->ticon->cmd = (char *) g_malloc(strlen(app_cmd)+1);
			strcpy(p->ticon->cmd, app_cmd);
		} 
		else {
			p->ticon->cmd = NULL;
		}
		
		if (app_args) {
			p->ticon->args = (char *) g_malloc(strlen(app_args)+1);
			strcpy(p->ticon->args, app_args);
		} 
		else {
			p->ticon->args = NULL;
		}
		p->ticon->dnd = app_dnd;

		if (!modified_trayicon) {
			modified_trayicon = p;
			modified_trayicon_p = modified_trayicon;
		}
		else {
			modified_trayicon_p->next = p;
		}
	}
	flags_new = NO;
	flags_modify = NO;
}

Trayicon *
request_new_trayicon (void)
{
	/* allocation */
	trayicon_tmp = (NewTrayIcon *) g_malloc(sizeof(NewTrayIcon));
	trayicon_tmp->next = NULL;
	trayicon_tmp->into = trayicon_current;

	trayicon_tmp->ticon = (Trayicon *) g_malloc(sizeof(Trayicon));
	trayicon_tmp->ticon->page = NULL;
	trayicon_tmp->ticon->next = NULL;
	trayicon_tmp->ticon->name = NULL;
	trayicon_tmp->ticon->gw_name = NULL;
	trayicon_tmp->ticon->gw_name_pref = NULL;
	trayicon_tmp->ticon->image = NULL;
	trayicon_tmp->ticon->gw_image = NULL;
	trayicon_tmp->ticon->cmd = NULL;
	trayicon_tmp->ticon->args = NULL;
	trayicon_tmp->ticon->button = NULL;
	trayicon_tmp->ticon->box = NULL;

	flags_new = YES;
	return trayicon_tmp->ticon;
}

static void
undo_new_trayicon (void)
{
	if (trayicon_tmp) {
		gtk_widget_destroy(ticon_tmp_widget);
		if (trayicon_tmp->ticon) {
			if (trayicon_tmp->ticon->name)
				g_free(trayicon_tmp->ticon->name);

			if (trayicon_tmp->ticon->image)
				g_free(trayicon_tmp->ticon->image);

			if (trayicon_tmp->ticon->cmd)
				g_free(trayicon_tmp->ticon->cmd);

			if (trayicon_tmp->ticon->args)
				g_free(trayicon_tmp->ticon->args);
		}
		g_free(trayicon_tmp);
		trayicon_tmp =NULL;
	}
	flags_new = NO;
}

static void
do_new_trayicon (void)
{

	if (app_name) {
		trayicon_tmp->ticon->name = (char *) g_malloc(strlen(app_name)+1);
		strcpy(trayicon_tmp->ticon->name, app_name);
	}
	else {
		fprintf(stderr,"application name != NULL\n");
		return;
	}

	if (app_image) {
		trayicon_tmp->ticon->image = (char *) g_malloc(strlen(app_image)+1);
		strcpy(trayicon_tmp->ticon->image, app_image);
	}

	if (app_cmd) {
		trayicon_tmp->ticon->cmd = (char *) g_malloc(strlen(app_cmd)+1);
		strcpy(trayicon_tmp->ticon->cmd, app_cmd);
	}
	else {
		fprintf(stderr,"application command != NULL\n");
		return;
	}

	if (app_args) {
		trayicon_tmp->ticon->args = (char *) g_malloc(strlen(app_args)+1);
		strcpy(trayicon_tmp->ticon->args, app_args);
	}

	if (!new_trayicon) {
		new_trayicon = trayicon_tmp;
		new_trayicon_p = new_trayicon;
	}
	else {
		new_trayicon_p->next = trayicon_tmp;
		new_trayicon_p = new_trayicon_p->next;
	}

	gtk_label_set(GTK_LABEL(new_trayicon_p->ticon->gw_name_pref),new_trayicon_p->ticon->name);
	flags_new = NO;
	trayicon_tmp = NULL;
	ticon_tmp_widget = NULL;
}

void
remove_trayicon_handler(void)
{
	RemovedTrayIcon *p;
	RemovedTrayIcon *buf;
	GtkStyle *style;

	style = gtk_style_new();
	style->fg[GTK_STATE_NORMAL] = removed_color;

	if (flags_modify == NO) {
		if (removed_trayicon) {
			buf = removed_trayicon;
			while (1) {
				if (!buf) {
					p = (RemovedTrayIcon *) g_malloc(sizeof(RemovedTrayIcon));
					p->ticon = trayicon_current;
					p->next = NULL;
					removed_trayicon_p->next = p;
					removed_trayicon_p = removed_trayicon_p->next;
				
					gtk_widget_set_style(trayicon_current->gw_name_pref, style);
					gtk_widget_draw_children(trayicon_current->gw_name_pref);
					break;
				}
				else {
					if (buf->ticon == trayicon_current)
						break;
					buf = buf->next;
				}
			}
		}
		else {
			p = (RemovedTrayIcon *) g_malloc(sizeof(RemovedTrayIcon));
			p->ticon = trayicon_current;
			p->next = NULL;
			removed_trayicon = p;
			removed_trayicon_p  = removed_trayicon; 

			gtk_widget_set_style(trayicon_current->gw_name_pref, style);
			gtk_widget_draw_children(trayicon_current->gw_name_pref);

		}
	}
	else if (flags_modify == YES) {
		if (removed_trayicon) {
			buf = removed_trayicon;
			while (1) {
				if (!buf) {
					p = (RemovedTrayIcon *) g_malloc(sizeof(RemovedTrayIcon));
					p->ticon = trayicon_current;
					p->next = NULL;
					removed_trayicon_p->next = p;
					removed_trayicon_p = removed_trayicon_p->next;

					gtk_widget_set_style(trayicon_current->gw_name_pref, style);
					gtk_widget_draw_children(trayicon_current->gw_name_pref);
					break;
				}
				else {
					if (buf->ticon == trayicon_current)
						break;
					buf = buf->next;
				}
			}
		}
		else {
			p = (RemovedTrayIcon *) g_malloc(sizeof(RemovedTrayIcon));
			p->ticon = trayicon_current;
			p->next = NULL;
			removed_trayicon = p;
			removed_trayicon_p  = removed_trayicon; 

			gtk_widget_set_style(trayicon_current->gw_name_pref, style);
			gtk_widget_draw_children(trayicon_current->gw_name_pref);
		}
	}
}

static void
init_trayicon_parts(GtkWidget *box)
{
	GtkWidget   *button;
	GdkPixmap   *pixmap_data = NULL;
	GdkBitmap   *mask;
	GtkStyle    *style;
	char        *pathname;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();

	/* Button (frame) */
	button = gtk_frame_new (NULL);
	gtk_widget_set_usize(button, ICON_SIZE, ICON_SIZE);
	gtk_frame_set_shadow_type (GTK_FRAME (button), GTK_SHADOW_IN);
	gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 0);
	gtk_widget_show (button);
	
	/* Button box */
	pixmap_box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(button), pixmap_box);
	gtk_widget_show(pixmap_box);

	/* style */
	style = gtk_widget_get_style(button);

	/* Pixmap */
	if (app_image) {
		pathname = (char *) g_malloc(strlen(Preferences->icon_path)+strlen(app_image)+2);
		strcpy(pathname, Preferences->icon_path);
		strcat(pathname, "/");
		strcat(pathname, app_image);
		pixmap_data = gdk_pixmap_colormap_create_from_xpm(NULL, cmap, &mask, 
								  &style->bg[GTK_STATE_NORMAL],
								  pathname);
		g_free(pathname);
	}
	else {
		pixmap_data = NULL;
	}
	if (pixmap_data) {
		pixmap = gtk_pixmap_new(pixmap_data, mask);
		gtk_box_pack_start(GTK_BOX(pixmap_box),pixmap, TRUE, FALSE, 0);
		gtk_widget_show(pixmap);
	}
	else {
		pixmap = NULL;
	}
}

static void
init_pixmap_parts (GtkWidget *box)
{
	SLL        *buf;
	GtkWidget  *main_box;
	GtkWidget  *vbox1;
	GtkWidget  *hbox;
	GtkWidget  *label;
	GtkWidget  *arrow;
	GtkWidget  *vbox2;
	GtkWidget  *swin;
	GtkWidget  *listbox;
	GtkWidget  *list_item;

	/* main box */
	main_box = gtk_hbox_new(FALSE, 8);
	gtk_container_border_width(GTK_CONTAINER (main_box), 10);
	gtk_box_pack_start(GTK_BOX (box), main_box, FALSE, FALSE, 0);
	gtk_widget_show(main_box);
	  
	/*  vbox 2 */
	vbox1 = gtk_vbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(main_box), vbox1, FALSE, FALSE, 0);
	gtk_widget_show(vbox1);

	/* hbox */
	hbox = gtk_hbox_new(FALSE, 8);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	/* label */
	label = gtk_label_new ("XPixmap file");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	gtk_widget_show (label);
	
	/* arrow */
	arrow = gtk_arrow_new(GTK_ARROW_RIGHT, GTK_SHADOW_IN);
	gtk_signal_connect(GTK_OBJECT(arrow), "destroy",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), arrow, FALSE, FALSE, 0);
	gtk_widget_show(arrow);

	/* hbox */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, TRUE, FALSE, 0);
	gtk_widget_show(hbox);

	init_trayicon_parts(hbox);

	/*  vbox 2 */
	vbox2 = gtk_vbox_new(FALSE, 4);
	gtk_box_pack_end(GTK_BOX(main_box), vbox2, TRUE, TRUE, 0);
	gtk_widget_show(vbox2);
	
	/* label */
	image_name = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX (vbox2), image_name, FALSE, FALSE, 0);
	gtk_widget_show (image_name);

	if (app_image) {
		gtk_entry_set_text(GTK_ENTRY(image_name), app_image);
	}

	/* scroll window */
	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (swin), GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_ALWAYS);
	gtk_widget_set_usize (swin, FILE_LIST_WIDTH, FILE_LIST_HEIGHT);
	gtk_signal_connect (GTK_OBJECT (swin), "button_press_event",
			    (GtkSignalFunc) change_xpm, NULL);
	gtk_box_pack_start (GTK_BOX (vbox2), swin, TRUE, TRUE, 0);
	gtk_widget_show(swin);
		
	listbox = gtk_list_new ();
	gtk_list_set_selection_mode(GTK_LIST (listbox), GTK_SELECTION_BROWSE);
	gtk_container_add(GTK_CONTAINER (swin), listbox);
	gtk_widget_show(listbox);

	/* make list  */
	buf = image_files;
	while (1){
		if (!buf){
			break;
		}
		list_item = gtk_list_item_new_with_label(buf->data);
		gtk_container_add(GTK_CONTAINER (listbox), list_item);
		gtk_object_set_user_data (GTK_OBJECT (list_item), buf->data);
		gtk_widget_show(list_item);
		buf = buf->next;
	}
}

static void
init_cmd_parts (GtkWidget *parent)
{
	GtkWidget *main_box;
	GtkWidget *cmd_box;
	GtkWidget *cmd_label;
	GtkWidget *cmd_entry;
	GtkWidget *hbox;
	GtkWidget *args_box1;
	GtkWidget *args_box2;
	GtkWidget *args_label;
	GtkWidget *args_entry;
	GtkWidget *frame;
	GtkWidget *dnd_box;
	GtkWidget *dnd_button_on;
	GtkWidget *dnd_button_off;

	/* main box */
	main_box = gtk_vbox_new(FALSE, 6);
	gtk_container_border_width(GTK_CONTAINER (main_box), 10);
	gtk_box_pack_start(GTK_BOX (parent), main_box, TRUE, TRUE, 0);
	gtk_widget_show(main_box);

	/* command box */
	cmd_box = gtk_vbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX (main_box), cmd_box, TRUE, TRUE, 0);
	gtk_widget_show(cmd_box);
	
	/* command label */
	cmd_label = gtk_label_new("command:");
	gtk_misc_set_alignment (GTK_MISC (cmd_label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX (cmd_box), cmd_label, TRUE, TRUE, 0);
	gtk_widget_show(cmd_label);
	
	/* command entry */
	cmd_entry = gtk_entry_new();
	if (app_cmd){
		gtk_entry_append_text(GTK_ENTRY(cmd_entry), app_cmd);
	}
	gtk_signal_connect(GTK_OBJECT(cmd_entry), "changed",
			   GTK_SIGNAL_FUNC(change_cmd), NULL);
	gtk_box_pack_start(GTK_BOX (cmd_box), cmd_entry, TRUE, TRUE, 0);
	gtk_widget_show(cmd_entry);

	/* hbox */
	hbox = gtk_hbox_new(FALSE, 6);
	gtk_box_pack_start(GTK_BOX (main_box), hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	/* args box1 */
	args_box1 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX (hbox), args_box1, TRUE, TRUE, 0);
	gtk_widget_show(args_box1);
	
	/* args box2 */
	args_box2 = gtk_vbox_new(FALSE, 2);
	gtk_box_pack_end(GTK_BOX (args_box1), args_box2, FALSE, FALSE, 0);
	gtk_widget_show(args_box2);
	
	/* args label */
	args_label = gtk_label_new("args:");
	gtk_misc_set_alignment (GTK_MISC (args_label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX (args_box2), args_label, FALSE, FALSE, 0);
	gtk_widget_show(args_label);
	
	/* args entry */
	args_entry = gtk_entry_new();
	if (app_args){
		gtk_entry_set_text(GTK_ENTRY(args_entry), app_args);
	}
	gtk_signal_connect(GTK_OBJECT(args_entry), "changed",
			   GTK_SIGNAL_FUNC(change_args), NULL);
	gtk_box_pack_start(GTK_BOX (args_box2), args_entry, TRUE, TRUE, 0);
	gtk_widget_show(args_entry);

	/* frame */
	frame = gtk_frame_new("DND");
	gtk_box_pack_start(GTK_BOX (hbox), frame, TRUE, TRUE, 0);
	gtk_widget_show(frame);

	/* dnd box */
	dnd_box = gtk_hbox_new(FALSE, 2);
	gtk_container_border_width(GTK_CONTAINER (dnd_box), 4);
	gtk_container_add(GTK_CONTAINER (frame), dnd_box);
	gtk_widget_show(dnd_box);

	/* dnd button on */
	dnd_button_on =  gtk_radio_button_new_with_label(NULL, "ON");
	gtk_signal_connect(GTK_OBJECT(dnd_button_on), "button_press_event",
			   GTK_SIGNAL_FUNC(radio_on), NULL);
	gtk_box_pack_start(GTK_BOX (dnd_box), dnd_button_on, TRUE, TRUE, 0);
	gtk_widget_show(dnd_button_on);

	/* dnd button off */
	dnd_button_off =  gtk_radio_button_new_with_label(gtk_radio_button_group
							  (GTK_RADIO_BUTTON(dnd_button_on)),"OFF");
	gtk_signal_connect(GTK_OBJECT(dnd_button_off), "button_press_event",
			   GTK_SIGNAL_FUNC(radio_off), NULL);
	gtk_box_pack_start(GTK_BOX (dnd_box), dnd_button_off, TRUE, TRUE, 0);
	gtk_widget_show(dnd_button_off);

	if (trayicon_current) {
		if (trayicon_current->dnd == YES) {
			gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (dnd_button_on), TRUE);
			app_dnd = YES;
		}
		else {
			gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (dnd_button_off), TRUE);
			app_dnd = NO;
		}
	}
	else {
		gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (dnd_button_off), TRUE);
		app_dnd = NO;
	}
}

SLL *
get_image_files(void)
{
	SLL            *top;
	SLL            *file_list;
	struct dirent  *dirent;
        struct stat    *st;
	DIR            *dir;
	char           *pathname;
	char           *path;
	char           *files[512];
	int            index = 0;
	int            i;
	int            (*func) () = sort_by_name;;

	/* Open directory */
	path = (char *) g_malloc(strlen(Preferences->icon_path) + 2);
	strcpy(path, Preferences->icon_path);
	strcat(path, "/");
	dir = opendir(path);
	if (!dir){
		return NULL;
	}

	while (1) {
		dirent = readdir(dir);
		if (!dirent){
			break;
		}
		st = (struct stat *) g_malloc(sizeof(struct stat));
		
		/* make abosolute pathname */
		pathname = (char *) g_malloc(strlen(path)+strlen(dirent->d_name)+1);
		strcpy(pathname, path);
		pathname = strcat(pathname, dirent->d_name);

		/* get  information of a file represented by pathname */
		if (stat(pathname, st) == -1){
			fprintf(stderr,"stat err\n");
		}
		if (S_ISREG(st->st_mode) || S_ISLNK(st->st_mode)){
			files[index] = (char *) g_malloc(strlen(dirent->d_name)+1);
			strcpy(files[index], dirent->d_name);
			index++;
		}
		if (pathname){
			g_free(pathname);
			pathname = NULL;
		}
		if (st){
			g_free(st);
			st = NULL;
		}
	}
	closedir(dir);
	
	if (path){
		g_free(path);
	}

	qsort(files, index, sizeof(char *), func);

	/* restore */
	file_list = (SLL *) g_malloc(sizeof(SLL));
	file_list->next = NULL;
	file_list->data = files[0];
	top = file_list;


	for (i=1;i<index;i++) {
		file_list->next = (SLL *) g_malloc(sizeof(SLL));
		file_list = file_list->next;
		file_list->next = NULL;
		file_list->data = files[i];
	}

	return top;
}

static void
change_name(GtkWidget * widget, gpointer data)
{
	char *str;

	str = gtk_entry_get_text(GTK_ENTRY(widget));
	if (strlen(str)<1){
		app_name = NULL;
	}
	else {
		app_name = str;
	}
}

static void
change_cmd(GtkWidget * widget, gpointer data)
{
	char *str;

	str = gtk_entry_get_text(GTK_ENTRY(widget));
	if (strlen(str)<1){
		app_cmd = NULL;
	}
	else {
		app_cmd = str;
	}
}

static void
change_args(GtkWidget * widget, gpointer data)
{
	char *str;

	str = gtk_entry_get_text(GTK_ENTRY(widget));
	if (strlen(str)<1){
		app_args = NULL;
	}
	else {
		app_args = str;
	}
}


static void 
change_xpm(GtkWidget  *widget, GdkEventButton *event)
{
	GtkWidget   *event_widget;
	GdkPixmap   *pixmap_data;
	GdkBitmap   *mask;
	GtkStyle    *style;
	char        *pathname;
	GdkColormap *cmap;

	/* get color map */
	cmap = gdk_colormap_get_system();
	
	event_widget = gtk_get_event_widget ((GdkEvent*) event);
	app_image = (char *)  gtk_object_get_user_data (GTK_OBJECT (event_widget));
	
	if (app_image) {
		pathname = (char *) g_malloc(strlen(Preferences->icon_path)+strlen(app_image)+2);
		strcpy(pathname,Preferences->icon_path);
		pathname = strcat(pathname, "/");
		pathname = strcat(pathname, app_image);
	
		/* set new pixmap to AppPreference */
		if (pixmap && GTK_WIDGET_VISIBLE(pixmap)){
			gtk_widget_hide(pixmap);
		}
		style = gtk_widget_get_style(widget->parent);
		pixmap_data = gdk_pixmap_colormap_create_from_xpm(NULL, cmap, &mask,
								 &style->bg[GTK_STATE_NORMAL],
								 pathname);
		if (pixmap_data) {
			if (pixmap) {
				gtk_pixmap_set (GTK_PIXMAP(pixmap), pixmap_data, mask);
			}
			else {
				pixmap = gtk_pixmap_new(pixmap_data, mask);
				gtk_box_pack_start(GTK_BOX(pixmap_box),pixmap, TRUE, FALSE, 0);
				gtk_widget_show(pixmap);
			}
		}
		gtk_widget_show(pixmap);
		
		/* set text to the entry of image */
		gtk_entry_set_text(GTK_ENTRY(image_name), app_image);
		g_free(pathname);
	}
}

static void
radio_on (void)
{
	app_dnd = YES;
}

static void
radio_off (void)
{
	app_dnd = NO;
}

static char *
clean_string(char *str)
{
	int length;
	int counter;
	char *p;

	if (!str) {
		return NULL;
	}

	length = strlen(str);
	p = str;
	counter = 1;
	while (1){
		if (isspace((int) *p) == 0){
			break;
		}
		else {
			if (counter == length){
				init_dialog_message("We get invalid string.");
				return NULL;
			}
			counter++;
			p++;
		}
	}
	str = p;

	length = strlen(str);

	p = str + length -1;
	counter = 1;
	while (1){
		if (isspace((int) *p) == 0){
			break;
		}
		else {
			if (counter == length){
				init_dialog_message("We get invalid string.");
				return NULL;
			}
			counter++;
			p--;
		}
	}
	*(p+1) = '\0';

	return str;
}

static int 
sort_by_name(const char **file1, const char **file2)
{
	 return strcmp(*file1, *file2);
}









